/*     */ package org.jboss.ws.core.jaxws.binding;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.ws.WebServiceException;
/*     */ import javax.xml.ws.handler.Handler;
/*     */ import javax.xml.ws.soap.SOAPBinding;
/*     */ import org.jboss.ws.core.CommonSOAP12Binding;
/*     */ import org.jboss.ws.core.jaxws.SOAPFaultHelperJAXWS;
/*     */ import org.jboss.ws.core.soap.SOAPFaultImpl;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ 
/*     */ public class SOAP12BindingJAXWS extends CommonSOAP12Binding
/*     */   implements BindingExt, SOAPBinding
/*     */ {
/*  51 */   private SOAPBindingJAXWS delegate = new SOAPBindingJAXWS();
/*     */ 
/*     */   public SOAP12BindingJAXWS()
/*     */   {
/*  56 */     setMTOMEnabled(false);
/*     */   }
/*     */ 
/*     */   public SOAP12BindingJAXWS(boolean mtomEnabled) {
/*  60 */     setMTOMEnabled(mtomEnabled);
/*     */   }
/*     */ 
/*     */   public void setSOAPActionHeader(OperationMetaData opMetaData, SOAPMessage reqMessage)
/*     */   {
/*  65 */     this.delegate.setSOAPActionHeader(opMetaData, reqMessage);
/*     */   }
/*     */ 
/*     */   public Set<String> getRoles()
/*     */   {
/*  72 */     Set soap12Roles = new HashSet(this.delegate.getRoles());
/*  73 */     soap12Roles.add("http://www.w3.org/2003/05/soap-envelope/role/next");
/*  74 */     soap12Roles.add("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver");
/*  75 */     return soap12Roles;
/*     */   }
/*     */ 
/*     */   public void setRoles(Set<String> roles)
/*     */   {
/*  82 */     for (String role : roles)
/*     */     {
/*  84 */       if (role.equals("http://www.w3.org/2003/05/soap-envelope/role/none"))
/*  85 */         throw new WebServiceException("Attempt to configure the binding to play the none role");
/*     */     }
/*  87 */     this.delegate.setRoles(roles);
/*     */   }
/*     */ 
/*     */   public List<Handler> getHandlerChain()
/*     */   {
/*  92 */     return this.delegate.getHandlerChain();
/*     */   }
/*     */ 
/*     */   public List<Handler> getHandlerChain(UnifiedHandlerMetaData.HandlerType handlerType)
/*     */   {
/*  97 */     return this.delegate.getHandlerChain(handlerType);
/*     */   }
/*     */ 
/*     */   public void setHandlerChain(List<Handler> handlerChain)
/*     */   {
/* 102 */     this.delegate.setHandlerChain(handlerChain);
/*     */   }
/*     */ 
/*     */   public void setHandlerChain(List<Handler> handlerChain, UnifiedHandlerMetaData.HandlerType handlerType)
/*     */   {
/* 107 */     this.delegate.setHandlerChain(handlerChain, handlerType);
/*     */   }
/*     */ 
/*     */   public SOAPMessage createFaultMessageFromException(Exception ex)
/*     */   {
/* 112 */     return SOAPFaultHelperJAXWS.exceptionToFaultMessage(ex);
/*     */   }
/*     */ 
/*     */   protected void throwFaultException(SOAPFaultImpl fault) throws Exception
/*     */   {
/* 117 */     throw SOAPFaultHelperJAXWS.getSOAPFaultException(fault);
/*     */   }
/*     */ 
/*     */   public String getBindingID()
/*     */   {
/* 122 */     return isMTOMEnabled() ? "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true" : "http://www.w3.org/2003/05/soap/bindings/HTTP/";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.binding.SOAP12BindingJAXWS
 * JD-Core Version:    0.6.0
 */