/*    */ package org.jboss.ws.core.jaxws.binding;
/*    */ 
/*    */ import java.util.HashSet;
/*    */ import java.util.Set;
/*    */ import javax.xml.soap.MimeHeaders;
/*    */ import javax.xml.soap.SOAPMessage;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.ws.core.CommonMessageContext;
/*    */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*    */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*    */ 
/*    */ class SOAPBindingJAXWS extends BindingImpl
/*    */ {
/* 47 */   private static Logger log = Logger.getLogger(SOAPBindingJAXWS.class);
/*    */ 
/* 49 */   private Set<String> roles = new HashSet();
/*    */ 
/*    */   public Set<String> getRoles()
/*    */   {
/* 53 */     return this.roles;
/*    */   }
/*    */ 
/*    */   public void setRoles(Set<String> roles)
/*    */   {
/* 58 */     this.roles = roles;
/*    */   }
/*    */ 
/*    */   public void setSOAPActionHeader(OperationMetaData opMetaData, SOAPMessage reqMessage)
/*    */   {
/* 63 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 64 */     MimeHeaders mimeHeaders = reqMessage.getMimeHeaders();
/* 65 */     String soapAction = opMetaData.getSOAPAction();
/*    */ 
/* 76 */     if (msgContext.get("javax.xml.ws.soap.http.soapaction.use") != null) {
/* 77 */       log.info("Ignore BindingProvider.SOAPACTION_USE_PROPERTY because of BP-1.0 R2745, R2745");
/*    */     }
/* 79 */     String soapActionProperty = (String)msgContext.get("javax.xml.ws.soap.http.soapaction.uri");
/* 80 */     if (soapActionProperty != null) {
/* 81 */       soapAction = soapActionProperty;
/*    */     }
/* 83 */     mimeHeaders.addHeader("SOAPAction", soapAction != null ? soapAction : "");
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.binding.SOAPBindingJAXWS
 * JD-Core Version:    0.6.0
 */