/*     */ package org.jboss.ws.core.jaxws.handler;
/*     */ 
/*     */ import java.util.Map;
/*     */ import javax.xml.ws.handler.MessageContext;
/*     */ import javax.xml.ws.handler.MessageContext.Scope;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.CommonMessageContext.ScopedProperty;
/*     */ import org.jboss.ws.core.binding.SerializationContext;
/*     */ import org.jboss.ws.core.jaxws.SerializationContextJAXWS;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.xb.binding.NamespaceRegistry;
/*     */ 
/*     */ public abstract class MessageContextJAXWS extends CommonMessageContext
/*     */   implements MessageContext
/*     */ {
/*  53 */   private static Logger log = Logger.getLogger(MessageContextJAXWS.class);
/*     */ 
/*     */   public MessageContextJAXWS()
/*     */   {
/*     */   }
/*     */ 
/*     */   public MessageContextJAXWS(CommonMessageContext msgContext)
/*     */   {
/*  61 */     super(msgContext);
/*     */   }
/*     */ 
/*     */   public SerializationContext createSerializationContext()
/*     */   {
/*  68 */     EndpointMetaData epMetaData = getEndpointMetaData();
/*  69 */     ServiceMetaData serviceMetaData = epMetaData.getServiceMetaData();
/*     */ 
/*  71 */     SerializationContextJAXWS jaxwsContext = new SerializationContextJAXWS();
/*  72 */     jaxwsContext.setTypeMapping(serviceMetaData.getTypeMapping());
/*  73 */     return jaxwsContext;
/*     */   }
/*     */ 
/*     */   public NamespaceRegistry getNamespaceRegistry()
/*     */   {
/*  79 */     return getSerializationContext().getNamespaceRegistry();
/*     */   }
/*     */ 
/*     */   public void setScope(String key, MessageContext.Scope scope)
/*     */   {
/*  85 */     CommonMessageContext.ScopedProperty prop = (CommonMessageContext.ScopedProperty)this.scopedProps.get(key);
/*  86 */     if (prop == null) {
/*  87 */       throw new IllegalArgumentException("Cannot find scoped property: " + key);
/*     */     }
/*  89 */     this.scopedProps.put(key, new CommonMessageContext.ScopedProperty(key, prop.getValue(), scope));
/*     */   }
/*     */ 
/*     */   public MessageContext.Scope getScope(String key)
/*     */   {
/*  95 */     CommonMessageContext.ScopedProperty prop = (CommonMessageContext.ScopedProperty)this.scopedProps.get(key);
/*  96 */     if (prop == null) {
/*  97 */       throw new IllegalArgumentException("Cannot find scoped property: " + key);
/*     */     }
/*  99 */     return prop.getScope();
/*     */   }
/*     */ 
/*     */   public static MessageContextJAXWS processPivot(CommonMessageContext reqContext)
/*     */   {
/* 104 */     log.debug("Begin response processing");
/*     */ 
/* 106 */     Boolean outbound = (Boolean)reqContext.get("javax.xml.ws.handler.message.outbound");
/* 107 */     if (outbound == null) {
/* 108 */       throw new IllegalStateException("Cannot find property: javax.xml.ws.handler.message.outbound");
/*     */     }
/* 110 */     MessageContextAssociation.popMessageContext();
/* 111 */     SOAPMessageContextJAXWS resContext = new SOAPMessageContextJAXWS(reqContext);
/* 112 */     resContext.setSOAPMessage(null);
/*     */ 
/* 115 */     resContext.put("javax.xml.ws.handler.message.outbound", new Boolean(!outbound.booleanValue()));
/*     */ 
/* 117 */     MessageContextAssociation.pushMessageContext(resContext);
/* 118 */     cleanupAttachments(reqContext);
/*     */ 
/* 120 */     return resContext;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.handler.MessageContextJAXWS
 * JD-Core Version:    0.6.0
 */