/*     */ package org.jboss.ws.core.jaxws.spi;
/*     */ 
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.StringTokenizer;
/*     */ import java.util.concurrent.Executor;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.ws.Binding;
/*     */ import javax.xml.ws.BindingProvider;
/*     */ import javax.xml.ws.Endpoint21;
/*     */ import javax.xml.ws.EndpointReference;
/*     */ import javax.xml.ws.WebServicePermission;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.core.jaxws.binding.BindingProviderImpl;
/*     */ import org.jboss.wsf.spi.SPIProvider;
/*     */ import org.jboss.wsf.spi.SPIProviderResolver;
/*     */ import org.jboss.wsf.spi.http.HttpContext;
/*     */ import org.jboss.wsf.spi.http.HttpServer;
/*     */ import org.jboss.wsf.spi.http.HttpServerFactory;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class EndpointImpl extends Endpoint21
/*     */ {
/*  59 */   private final Logger log = Logger.getLogger(EndpointImpl.class);
/*     */ 
/*  62 */   private static final WebServicePermission ENDPOINT_PUBLISH_PERMISSION = new WebServicePermission("publishEndpoint");
/*     */   private Object implementor;
/*     */   private Executor executor;
/*     */   private List<Source> metadata;
/*     */   private BindingProvider bindingProvider;
/*  68 */   private Map<String, Object> properties = new HashMap();
/*     */   private HttpContext serverContext;
/*     */   private boolean isPublished;
/*     */   private boolean isDestroyed;
/*     */ 
/*     */   public EndpointImpl(String bindingId, Object implementor)
/*     */   {
/*  75 */     this.log.debug("new EndpointImpl(bindingId=" + bindingId + ",implementor=" + implementor + ")");
/*     */ 
/*  77 */     if (implementor == null) {
/*  78 */       throw new IllegalArgumentException("Implementor cannot be null");
/*     */     }
/*  80 */     this.implementor = implementor;
/*  81 */     this.bindingProvider = new BindingProviderImpl(bindingId);
/*     */   }
/*     */ 
/*     */   public Binding getBinding()
/*     */   {
/*  87 */     return this.bindingProvider.getBinding();
/*     */   }
/*     */ 
/*     */   public Object getImplementor()
/*     */   {
/*  93 */     return this.implementor;
/*     */   }
/*     */ 
/*     */   public void publish(String address)
/*     */   {
/* 106 */     this.log.debug("publish: " + address);
/*     */     URI addrURI;
/*     */     try {
/* 111 */       addrURI = new URI(address);
/*     */     }
/*     */     catch (URISyntaxException e)
/*     */     {
/* 115 */       throw new IllegalArgumentException("Invalid address: " + address);
/*     */     }
/*     */ 
/* 119 */     checkPublishEndpointPermission();
/*     */ 
/* 122 */     SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
/* 123 */     HttpServer httpServer = ((HttpServerFactory)spiProvider.getSPI(HttpServerFactory.class)).getHttpServer();
/* 124 */     httpServer.setProperties(this.properties);
/* 125 */     httpServer.start();
/*     */ 
/* 127 */     String path = addrURI.getPath();
/* 128 */     String contextRoot = "/" + new StringTokenizer(path, "/").nextToken();
/* 129 */     HttpContext context = httpServer.createContext(contextRoot);
/*     */ 
/* 131 */     publish(context);
/*     */   }
/*     */ 
/*     */   public void publish(Object context)
/*     */   {
/* 144 */     this.log.debug("publish: " + context);
/*     */ 
/* 146 */     if (this.isDestroyed) {
/* 147 */       throw new IllegalStateException("Endpoint already destroyed");
/*     */     }
/*     */ 
/* 150 */     checkPublishEndpointPermission();
/*     */ 
/* 170 */     if ((context instanceof HttpContext))
/*     */     {
/* 172 */       this.serverContext = ((HttpContext)context);
/* 173 */       HttpServer httpServer = this.serverContext.getHttpServer();
/* 174 */       httpServer.publish(this.serverContext, this);
/* 175 */       this.isPublished = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 182 */     this.log.debug("stop");
/*     */ 
/* 184 */     if ((this.serverContext == null) || (!this.isPublished)) {
/* 185 */       this.log.error("Endpoint not published");
/*     */     }
/*     */     try
/*     */     {
/* 189 */       if (this.serverContext != null)
/*     */       {
/* 191 */         HttpServer httpServer = this.serverContext.getHttpServer();
/* 192 */         httpServer.destroy(this.serverContext, this);
/*     */       }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 197 */       this.log.error("Cannot stop endpoint", ex);
/*     */     }
/*     */ 
/* 200 */     this.isPublished = false;
/* 201 */     this.isDestroyed = true;
/*     */   }
/*     */ 
/*     */   public boolean isPublished()
/*     */   {
/* 207 */     return this.isPublished;
/*     */   }
/*     */ 
/*     */   public List<Source> getMetadata()
/*     */   {
/* 213 */     return this.metadata;
/*     */   }
/*     */ 
/*     */   public void setMetadata(List<Source> list)
/*     */   {
/* 219 */     this.log.info("Ignore metadata, not implemented");
/* 220 */     this.metadata = list;
/*     */   }
/*     */ 
/*     */   public Executor getExecutor()
/*     */   {
/* 226 */     return this.executor;
/*     */   }
/*     */ 
/*     */   public void setExecutor(Executor executor)
/*     */   {
/* 232 */     this.log.info("Ignore executor, not implemented");
/* 233 */     this.executor = executor;
/*     */   }
/*     */ 
/*     */   public Map<String, Object> getProperties()
/*     */   {
/* 239 */     return this.properties;
/*     */   }
/*     */ 
/*     */   public void setProperties(Map<String, Object> map)
/*     */   {
/* 245 */     this.properties = map;
/*     */   }
/*     */ 
/*     */   private void checkPublishEndpointPermission()
/*     */   {
/* 256 */     SecurityManager sm = System.getSecurityManager();
/* 257 */     if (sm != null)
/*     */     {
/* 259 */       sm.checkPermission(ENDPOINT_PUBLISH_PERMISSION);
/*     */     }
/*     */   }
/*     */ 
/*     */   public EndpointReference getEndpointReference(Element[] referenceParameters)
/*     */   {
/* 266 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element[] referenceParameters)
/*     */   {
/* 272 */     throw new NotImplementedException();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.spi.EndpointImpl
 * JD-Core Version:    0.6.0
 */