/*    */ package org.jboss.ws.core.server;
/*    */ 
/*    */ import javax.xml.rpc.handler.MessageContext;
/*    */ import javax.xml.rpc.handler.soap.SOAPMessageContext;
/*    */ import javax.xml.soap.SOAPMessage;
/*    */ import org.jboss.ws.WSException;
/*    */ import org.jboss.ws.core.CommonBinding;
/*    */ import org.jboss.ws.core.CommonBindingProvider;
/*    */ import org.jboss.ws.core.EndpointInvocation;
/*    */ import org.jboss.ws.core.binding.BindingException;
/*    */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*    */ import org.jboss.wsf.spi.invocation.Invocation;
/*    */ import org.jboss.wsf.spi.invocation.InvocationContext;
/*    */ 
/*    */ public class DelegatingInvocation extends Invocation
/*    */ {
/*    */   private EndpointInvocation getEndpointInvocation()
/*    */   {
/* 46 */     EndpointInvocation epInv = (EndpointInvocation)getInvocationContext().getAttachment(EndpointInvocation.class);
/* 47 */     if (epInv == null) {
/* 48 */       throw new IllegalStateException("Cannot obtain endpoint invocation");
/*    */     }
/* 50 */     return epInv;
/*    */   }
/*    */ 
/*    */   public void setReturnValue(Object value)
/*    */   {
/* 56 */     EndpointInvocation epInv = getEndpointInvocation();
/* 57 */     epInv.setReturnValue(value);
/*    */ 
/* 59 */     SOAPMessageContext msgContext = (SOAPMessageContext)getInvocationContext().getAttachment(MessageContext.class);
/* 60 */     if ((msgContext != null) && (msgContext.getMessage() == null))
/*    */     {
/*    */       try
/*    */       {
/* 65 */         OperationMetaData opMetaData = epInv.getOperationMetaData();
/* 66 */         CommonBindingProvider bindingProvider = new CommonBindingProvider(opMetaData.getEndpointMetaData());
/* 67 */         CommonBinding binding = bindingProvider.getCommonBinding();
/* 68 */         SOAPMessage resMessage = (SOAPMessage)binding.bindResponseMessage(opMetaData, epInv);
/* 69 */         msgContext.setMessage(resMessage);
/*    */       }
/*    */       catch (BindingException ex)
/*    */       {
/* 73 */         WSException.rethrow(ex);
/*    */       }
/*    */     }
/*    */   }
/*    */ 
/*    */   public Object[] getArgs()
/*    */   {
/* 81 */     EndpointInvocation epInv = getEndpointInvocation();
/* 82 */     return epInv.getRequestPayload();
/*    */   }
/*    */ 
/*    */   public Object getReturnValue()
/*    */   {
/* 88 */     EndpointInvocation epInv = getEndpointInvocation();
/* 89 */     return epInv.getReturnValue();
/*    */   }
/*    */ 
/*    */   public void setArgs(Object[] args)
/*    */   {
/* 95 */     throw new IllegalArgumentException("Cannot set args on this invocation");
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.server.DelegatingInvocation
 * JD-Core Version:    0.6.0
 */