/*     */ package org.jboss.ws.core.server;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Date;
/*     */ import javax.management.ObjectName;
/*     */ 
/*     */ public class ServiceEndpointMetrics
/*     */   implements Serializable, Cloneable
/*     */ {
/*     */   private static final long serialVersionUID = -7730514070812711512L;
/*     */   private ObjectName endpointID;
/*     */   private Date startTime;
/*     */   private Date stopTime;
/*     */   private long requestCount;
/*     */   private long responseCount;
/*     */   private long faultCount;
/*     */   private long maxProcessingTime;
/*     */   private long minProcessingTime;
/*     */   private long avgProcessingTime;
/*     */   private long totalProcessingTime;
/*     */ 
/*     */   public ServiceEndpointMetrics(ObjectName endpointID)
/*     */   {
/*  56 */     this.endpointID = endpointID;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*  61 */     this.startTime = new Date();
/*  62 */     this.stopTime = null;
/*  63 */     this.requestCount = 0L;
/*  64 */     this.responseCount = 0L;
/*  65 */     this.faultCount = 0L;
/*  66 */     this.maxProcessingTime = 0L;
/*  67 */     this.minProcessingTime = 0L;
/*  68 */     this.avgProcessingTime = 0L;
/*  69 */     this.totalProcessingTime = 0L;
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*  74 */     this.stopTime = new Date();
/*     */   }
/*     */ 
/*     */   public long processRequestMessage()
/*     */   {
/*  79 */     this.requestCount += 1L;
/*  80 */     return System.currentTimeMillis();
/*     */   }
/*     */ 
/*     */   public void processResponseMessage(long beginTime)
/*     */   {
/*  85 */     this.responseCount += 1L;
/*  86 */     processAnyMessage(beginTime);
/*     */   }
/*     */ 
/*     */   public void processFaultMessage(long beginTime)
/*     */   {
/*  91 */     this.faultCount += 1L;
/*  92 */     processAnyMessage(beginTime);
/*     */   }
/*     */ 
/*     */   private void processAnyMessage(long beginTime)
/*     */   {
/*  97 */     if (beginTime > 0L)
/*     */     {
/*  99 */       long procTime = System.currentTimeMillis() - beginTime;
/*     */ 
/* 101 */       if (this.minProcessingTime == 0L) {
/* 102 */         this.minProcessingTime = procTime;
/*     */       }
/* 104 */       this.maxProcessingTime = Math.max(this.maxProcessingTime, procTime);
/* 105 */       this.minProcessingTime = Math.min(this.minProcessingTime, procTime);
/* 106 */       this.totalProcessingTime += procTime;
/* 107 */       this.avgProcessingTime = (this.totalProcessingTime / (this.responseCount + this.faultCount));
/*     */     }
/*     */   }
/*     */ 
/*     */   public ObjectName getEndpointID()
/*     */   {
/* 113 */     return this.endpointID;
/*     */   }
/*     */ 
/*     */   public Date getStartTime()
/*     */   {
/* 118 */     return this.startTime;
/*     */   }
/*     */ 
/*     */   public Date getStopTime()
/*     */   {
/* 123 */     return this.stopTime;
/*     */   }
/*     */ 
/*     */   public long getMinProcessingTime()
/*     */   {
/* 128 */     return this.minProcessingTime;
/*     */   }
/*     */ 
/*     */   public long getMaxProcessingTime()
/*     */   {
/* 133 */     return this.maxProcessingTime;
/*     */   }
/*     */ 
/*     */   public long getAverageProcessingTime()
/*     */   {
/* 138 */     return this.avgProcessingTime;
/*     */   }
/*     */ 
/*     */   public long getTotalProcessingTime()
/*     */   {
/* 143 */     return this.totalProcessingTime;
/*     */   }
/*     */ 
/*     */   public long getRequestCount()
/*     */   {
/* 148 */     return this.requestCount;
/*     */   }
/*     */ 
/*     */   public long getFaultCount()
/*     */   {
/* 153 */     return this.faultCount;
/*     */   }
/*     */ 
/*     */   public long getResponseCount()
/*     */   {
/* 158 */     return this.responseCount;
/*     */   }
/*     */ 
/*     */   public Object clone() throws CloneNotSupportedException
/*     */   {
/* 163 */     ServiceEndpointMetrics sem = new ServiceEndpointMetrics(this.endpointID);
/*     */ 
/* 165 */     sem.avgProcessingTime = this.avgProcessingTime;
/* 166 */     sem.maxProcessingTime = this.maxProcessingTime;
/* 167 */     sem.minProcessingTime = this.minProcessingTime;
/*     */ 
/* 169 */     sem.faultCount = this.faultCount;
/* 170 */     sem.requestCount = this.requestCount;
/* 171 */     sem.responseCount = this.responseCount;
/*     */ 
/* 173 */     sem.startTime = this.startTime;
/* 174 */     sem.stopTime = this.stopTime;
/* 175 */     sem.totalProcessingTime = this.totalProcessingTime;
/*     */ 
/* 177 */     return sem;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 182 */     StringBuilder buffer = new StringBuilder("\nEndpoint Metrics: " + this.endpointID);
/* 183 */     buffer.append("\n  startTime=" + this.startTime);
/* 184 */     buffer.append("\n  stopTime=" + this.stopTime);
/* 185 */     buffer.append("\n  requestCount=" + this.requestCount);
/* 186 */     buffer.append("\n  responseCount=" + this.responseCount);
/* 187 */     buffer.append("\n  faultCount=" + this.faultCount);
/* 188 */     buffer.append("\n  maxProcessingTime=" + this.maxProcessingTime);
/* 189 */     buffer.append("\n  minProcessingTime=" + this.minProcessingTime);
/* 190 */     buffer.append("\n  avgProcessingTime=" + this.avgProcessingTime);
/* 191 */     buffer.append("\n  totalProcessingTime=" + this.totalProcessingTime);
/* 192 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.server.ServiceEndpointMetrics
 * JD-Core Version:    0.6.0
 */