/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.Name;
/*     */ import javax.xml.soap.SOAPBody;
/*     */ import javax.xml.soap.SOAPBodyElement;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.soap.SOAPEnvelope;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPHeader;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.transform.dom.DOMSource;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.Constants;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.CommonSOAPFaultException;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.w3c.dom.Comment;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ import org.xml.sax.InputSource;
/*     */ 
/*     */ public class EnvelopeBuilderDOM
/*     */   implements EnvelopeBuilder
/*     */ {
/*  63 */   private static Logger log = Logger.getLogger(EnvelopeBuilderDOM.class);
/*     */ 
/*  65 */   private SOAPFactoryImpl soapFactory = new SOAPFactoryImpl();
/*     */   private Style style;
/*     */ 
/*     */   public Style getStyle()
/*     */   {
/*  70 */     return this.style;
/*     */   }
/*     */ 
/*     */   public void setStyle(Style style)
/*     */   {
/*  75 */     this.style = style;
/*     */   }
/*     */ 
/*     */   public SOAPEnvelope build(SOAPMessage soapMessage, InputStream ins, boolean ignoreParseError)
/*     */     throws IOException, SOAPException
/*     */   {
/*  81 */     Element domEnv = null;
/*     */     try
/*     */     {
/*  84 */       domEnv = DOMUtils.parse(ins);
/*     */     }
/*     */     catch (IOException ex)
/*     */     {
/*  88 */       if (ignoreParseError)
/*     */       {
/*  90 */         return null;
/*     */       }
/*  92 */       QName faultCode = Constants.SOAP11_FAULT_CODE_CLIENT;
/*  93 */       throw new CommonSOAPFaultException(faultCode, ex.getMessage());
/*     */     }
/*     */ 
/*  96 */     return build(soapMessage, domEnv);
/*     */   }
/*     */ 
/*     */   public SOAPEnvelope build(SOAPMessage soapMessage, Reader reader, boolean ignoreParseError)
/*     */     throws IOException, SOAPException
/*     */   {
/* 102 */     Element domEnv = null;
/*     */     try
/*     */     {
/* 105 */       domEnv = DOMUtils.parse(new InputSource(reader));
/*     */     }
/*     */     catch (IOException ex)
/*     */     {
/* 109 */       if (ignoreParseError)
/*     */       {
/* 111 */         return null;
/*     */       }
/* 113 */       QName faultCode = Constants.SOAP11_FAULT_CODE_CLIENT;
/* 114 */       throw new CommonSOAPFaultException(faultCode, ex.getMessage());
/*     */     }
/*     */ 
/* 117 */     return build(soapMessage, domEnv);
/*     */   }
/*     */ 
/*     */   public SOAPEnvelope build(SOAPMessage soapMessage, Element domEnv)
/*     */     throws SOAPException
/*     */   {
/* 123 */     SOAPPartImpl soapPart = (SOAPPartImpl)soapMessage.getSOAPPart();
/* 124 */     SOAPEnvelopeImpl soapEnv = new SOAPEnvelopeImpl(soapPart, this.soapFactory.createElement(domEnv, false), false);
/*     */ 
/* 126 */     DOMUtils.copyAttributes(soapEnv, domEnv);
/*     */ 
/* 128 */     NodeList envChildNodes = domEnv.getChildNodes();
/* 129 */     for (int i = 0; i < envChildNodes.getLength(); i++)
/*     */     {
/* 131 */       Node child = envChildNodes.item(i);
/* 132 */       short childType = child.getNodeType();
/* 133 */       if (childType != 1)
/*     */         continue;
/* 135 */       String elName = child.getLocalName();
/* 136 */       if ("Header".equals(elName))
/*     */       {
/* 138 */         buildSOAPHeader(soapEnv, (Element)child);
/*     */       }
/* 140 */       else if ("Body".equals(elName))
/*     */       {
/* 142 */         buildSOAPBody(soapEnv, (Element)child);
/*     */       }
/*     */       else
/*     */       {
/* 146 */         log.warn("Ignore envelope child: " + elName);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 151 */     return soapEnv;
/*     */   }
/*     */ 
/*     */   private SOAPHeader buildSOAPHeader(SOAPEnvelopeImpl soapEnv, Element domHeader) throws SOAPException
/*     */   {
/* 156 */     SOAPHeader soapHeader = soapEnv.getHeader();
/* 157 */     if (soapHeader == null) {
/* 158 */       soapHeader = soapEnv.addHeader();
/*     */     }
/* 160 */     DOMUtils.copyAttributes(soapHeader, domHeader);
/*     */ 
/* 162 */     NodeList headerChildNodes = domHeader.getChildNodes();
/* 163 */     for (int i = 0; i < headerChildNodes.getLength(); i++)
/*     */     {
/* 165 */       Node child = headerChildNodes.item(i);
/* 166 */       short childType = child.getNodeType();
/* 167 */       if (childType == 1)
/*     */       {
/* 169 */         Element srcElement = (Element)child;
/* 170 */         XMLFragment xmlFragment = new XMLFragment(new DOMSource(srcElement));
/*     */ 
/* 172 */         Name name = new NameImpl(srcElement.getLocalName(), srcElement.getPrefix(), srcElement.getNamespaceURI());
/* 173 */         SOAPContentElement destElement = new SOAPHeaderElementImpl(name);
/* 174 */         soapHeader.addChildElement(destElement);
/*     */ 
/* 176 */         DOMUtils.copyAttributes(destElement, srcElement);
/* 177 */         destElement.setXMLFragment(xmlFragment);
/*     */       }
/*     */       else
/*     */       {
/* 181 */         log.warn("Ignore child type: " + childType);
/*     */       }
/*     */     }
/*     */ 
/* 185 */     return soapHeader;
/*     */   }
/*     */ 
/*     */   private SOAPBody buildSOAPBody(SOAPEnvelopeImpl soapEnv, Element domBody) throws SOAPException
/*     */   {
/* 190 */     String envNS = soapEnv.getNamespaceURI();
/*     */ 
/* 192 */     SOAPBodyImpl soapBody = (SOAPBodyImpl)soapEnv.getBody();
/* 193 */     if (soapBody == null) {
/* 194 */       soapBody = (SOAPBodyImpl)soapEnv.addBody();
/*     */     }
/* 196 */     DOMUtils.copyAttributes(soapBody, domBody);
/*     */ 
/* 198 */     SOAPBodyElement soapBodyElement = null;
/* 199 */     boolean attachHRefElements = "http://schemas.xmlsoap.org/soap/encoding/".equals(soapEnv.getAttributeNS(envNS, "encodingStyle"));
/*     */ 
/* 201 */     NodeList bodyChildNodes = domBody.getChildNodes();
/* 202 */     for (int i = 0; i < bodyChildNodes.getLength(); i++)
/*     */     {
/* 204 */       Node child = bodyChildNodes.item(i);
/* 205 */       short childType = child.getNodeType();
/* 206 */       if (childType == 1)
/*     */       {
/* 208 */         if (soapBodyElement == null)
/*     */         {
/* 210 */           soapBodyElement = buildSOAPBodyElement(soapEnv, (Element)child);
/* 211 */           attachHRefElements = (attachHRefElements) || ("http://schemas.xmlsoap.org/soap/encoding/".equals(soapBody.getAttributeNS(envNS, "encodingStyle")));
/*     */         } else {
/* 213 */           if (!attachHRefElements) {
/*     */             continue;
/*     */           }
/* 216 */           soapBody.addChildElement(this.soapFactory.createElement((Element)child, true));
/*     */         }
/*     */       }
/* 219 */       else if (childType == 8)
/*     */       {
/* 221 */         appendCommentNode(soapBody, child);
/*     */       }
/* 223 */       else if (childType == 3)
/*     */       {
/* 225 */         appendTextNode(soapBody, child);
/*     */       }
/*     */       else
/*     */       {
/* 229 */         log.warn("Ignore child type: " + childType);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 234 */     if (attachHRefElements)
/*     */     {
/* 236 */       HRefInlineHandler inlineHandler = new HRefInlineHandler(soapBody);
/* 237 */       inlineHandler.processHRefs();
/*     */     }
/*     */ 
/* 240 */     return soapBody;
/*     */   }
/*     */ 
/*     */   private SOAPBodyElement buildSOAPBodyElement(SOAPEnvelopeImpl soapEnv, Element domBodyElement) throws SOAPException
/*     */   {
/* 245 */     String envNS = soapEnv.getNamespaceURI();
/* 246 */     String envPrefix = soapEnv.getPrefix();
/*     */ 
/* 248 */     SOAPBodyImpl soapBody = (SOAPBodyImpl)soapEnv.getBody();
/* 249 */     QName beName = DOMUtils.getElementQName(domBodyElement);
/*     */ 
/* 251 */     SOAPBodyElement soapBodyElement = null;
/*     */ 
/* 254 */     if (beName.equals(new QName(envNS, "Fault")))
/*     */     {
/* 256 */       SOAPFaultImpl soapFault = new SOAPFaultImpl(envPrefix, envNS);
/* 257 */       soapBody.addChildElement(soapFault);
/* 258 */       soapBodyElement = soapFault;
/*     */ 
/* 260 */       DOMUtils.copyAttributes(soapFault, domBodyElement);
/*     */ 
/* 263 */       XMLFragment xmlFragment = new XMLFragment(new DOMSource(domBodyElement));
/* 264 */       soapFault.setXMLFragment(xmlFragment);
/*     */     }
/* 270 */     else if (this.style == Style.DOCUMENT)
/*     */     {
/* 272 */       buildBodyElementDoc(soapBody, domBodyElement);
/*     */     }
/* 274 */     else if (this.style == Style.RPC)
/*     */     {
/* 276 */       soapBodyElement = buildBodyElementRpc(soapBody, domBodyElement);
/*     */     }
/* 278 */     else if (this.style == null)
/*     */     {
/* 280 */       buildBodyElementDefault(soapBody, domBodyElement);
/*     */     }
/*     */     else
/*     */     {
/* 284 */       throw new WSException("Unsupported message style: " + this.style);
/*     */     }
/*     */ 
/* 288 */     return soapBodyElement;
/*     */   }
/*     */ 
/*     */   public SOAPBodyElement buildBodyElementDoc(SOAPBodyImpl soapBody, Element domBodyElement) throws SOAPException
/*     */   {
/* 293 */     Element srcElement = domBodyElement;
/*     */ 
/* 295 */     QName beName = DOMUtils.getElementQName(domBodyElement);
/* 296 */     SOAPBodyElementDoc soapBodyElement = new SOAPBodyElementDoc(beName);
/* 297 */     SOAPContentElement contentElement = (SOAPContentElement)soapBody.addChildElement(soapBodyElement);
/*     */ 
/* 299 */     DOMUtils.copyAttributes(contentElement, srcElement);
/*     */ 
/* 301 */     XMLFragment xmlFragment = new XMLFragment(new DOMSource(srcElement));
/* 302 */     contentElement.setXMLFragment(xmlFragment);
/*     */ 
/* 304 */     return soapBodyElement;
/*     */   }
/*     */ 
/*     */   public SOAPBodyElement buildBodyElementRpc(SOAPBodyImpl soapBody, Element domBodyElement) throws SOAPException
/*     */   {
/* 309 */     QName beName = DOMUtils.getElementQName(domBodyElement);
/* 310 */     SOAPBodyElementRpc soapBodyElement = new SOAPBodyElementRpc(beName);
/* 311 */     soapBodyElement = (SOAPBodyElementRpc)soapBody.addChildElement(soapBodyElement);
/*     */ 
/* 313 */     DOMUtils.copyAttributes(soapBodyElement, domBodyElement);
/*     */ 
/* 315 */     NodeList nlist = domBodyElement.getChildNodes();
/* 316 */     for (int i = 0; i < nlist.getLength(); i++)
/*     */     {
/* 318 */       Node child = nlist.item(i);
/* 319 */       short childType = child.getNodeType();
/* 320 */       if (childType == 1)
/*     */       {
/* 322 */         Element srcElement = (Element)child;
/* 323 */         Name name = new NameImpl(srcElement.getLocalName(), srcElement.getPrefix(), srcElement.getNamespaceURI());
/* 324 */         SOAPContentElement destElement = new SOAPContentElement(name);
/* 325 */         destElement = (SOAPContentElement)soapBodyElement.addChildElement(destElement);
/*     */ 
/* 327 */         DOMUtils.copyAttributes(destElement, srcElement);
/*     */ 
/* 329 */         XMLFragment xmlFragment = new XMLFragment(new DOMSource(srcElement));
/* 330 */         destElement.setXMLFragment(xmlFragment);
/*     */       }
/* 332 */       else if (childType == 8)
/*     */       {
/* 334 */         appendCommentNode(soapBodyElement, child);
/*     */       }
/* 336 */       else if (childType == 3)
/*     */       {
/* 338 */         appendTextNode(soapBodyElement, child);
/*     */       }
/*     */       else
/*     */       {
/* 342 */         log.warn("Ignore child type: " + childType);
/*     */       }
/*     */     }
/*     */ 
/* 346 */     return soapBodyElement;
/*     */   }
/*     */ 
/*     */   public SOAPBodyElement buildBodyElementDefault(SOAPBodyImpl soapBody, Element domBodyElement) throws SOAPException
/*     */   {
/* 351 */     QName beName = DOMUtils.getElementQName(domBodyElement);
/* 352 */     SOAPBodyElement soapBodyElement = new SOAPBodyElementMessage(beName);
/* 353 */     soapBodyElement = (SOAPBodyElementMessage)soapBody.addChildElement(soapBodyElement);
/*     */ 
/* 355 */     DOMUtils.copyAttributes(soapBodyElement, domBodyElement);
/*     */ 
/* 357 */     NodeList nlist = domBodyElement.getChildNodes();
/* 358 */     for (int i = 0; i < nlist.getLength(); i++)
/*     */     {
/* 360 */       Node child = nlist.item(i);
/* 361 */       short childType = child.getNodeType();
/* 362 */       if (childType == 1)
/*     */       {
/* 364 */         SOAPElement soapElement = this.soapFactory.createElement((Element)child);
/* 365 */         soapBodyElement.addChildElement(soapElement);
/*     */       }
/* 367 */       else if (childType == 8)
/*     */       {
/* 369 */         appendCommentNode(soapBodyElement, child);
/*     */       }
/* 371 */       else if (childType == 3)
/*     */       {
/* 373 */         appendTextNode(soapBodyElement, child);
/*     */       }
/* 375 */       else if (childType == 4)
/*     */       {
/* 377 */         String nodeValue = child.getNodeValue();
/* 378 */         soapBodyElement.addTextNode(nodeValue);
/*     */       }
/*     */       else
/*     */       {
/* 382 */         log.warn("Ignore child type: " + childType);
/*     */       }
/*     */     }
/*     */ 
/* 386 */     return soapBodyElement;
/*     */   }
/*     */ 
/*     */   private void appendCommentNode(SOAPElement soapElement, Node child)
/*     */   {
/* 391 */     String nodeValue = child.getNodeValue();
/* 392 */     Document ownerDoc = soapElement.getOwnerDocument();
/* 393 */     Comment comment = ownerDoc.createComment(nodeValue);
/* 394 */     soapElement.appendChild(comment);
/*     */   }
/*     */ 
/*     */   private void appendTextNode(SOAPElement soapElement, Node child) throws SOAPException
/*     */   {
/* 399 */     String nodeValue = child.getNodeValue();
/* 400 */     soapElement.addTextNode(nodeValue);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.EnvelopeBuilderDOM
 * JD-Core Version:    0.6.0
 */