/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import com.ctc.wstx.stax.WstxInputFactory;
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.Name;
/*     */ import javax.xml.soap.SOAPBody;
/*     */ import javax.xml.soap.SOAPBodyElement;
/*     */ import javax.xml.soap.SOAPEnvelope;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPFault;
/*     */ import javax.xml.soap.SOAPHeader;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.stream.XMLInputFactory;
/*     */ import javax.xml.stream.XMLStreamException;
/*     */ import javax.xml.stream.XMLStreamReader;
/*     */ import javax.xml.transform.stream.StreamSource;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class EnvelopeBuilderStax
/*     */   implements EnvelopeBuilder
/*     */ {
/*     */   private static final String END_ELEMENT_BRACKET = "</";
/*     */   private static final String EMPTY_STRING = "";
/*     */   private static final String CLOSING_BRACKET = ">";
/*     */   private static final String START_ELEMENT_BRACKET = "<";
/*     */   private static final String HEADER_ELEMENT_NAME = "Header";
/*     */   private static final String BODY_ELEMENT_NAME = "Body";
/*     */   private static final String FAULT_ELEMENT_NAME = "Fault";
/*  72 */   private Part currentPart = Part.ENVELOPE;
/*  73 */   private Part previousPart = null;
/*     */   private SOAPPartImpl soapPart;
/*     */   private SOAPEnvelopeImpl soapEnv;
/*     */   private StringBuffer fragmentBuffer;
/*  80 */   private QName fragmentRootCursor = null;
/*  81 */   private QName currentRootElement = null;
/*     */   private XMLStreamReader reader;
/*     */   private static XMLInputFactory factory;
/*     */ 
/*     */   public EnvelopeBuilderStax()
/*     */   {
/*  88 */     resetFragmentBuffer();
/*     */   }
/*     */ 
/*     */   private void resetFragmentBuffer()
/*     */   {
/*  93 */     this.fragmentBuffer = new StringBuffer();
/*  94 */     this.fragmentBuffer.ensureCapacity(2048);
/*     */   }
/*     */ 
/*     */   public SOAPEnvelope build(SOAPMessage soapMessage, InputStream in, boolean ignoreParseError) throws IOException, SOAPException
/*     */   {
/*     */     try
/*     */     {
/* 101 */       this.reader = getFactoryInstance().createXMLStreamReader(in);
/*     */     }
/*     */     catch (XMLStreamException e)
/*     */     {
/* 105 */       throw new IOException("Failed to create stream reader:" + e.getMessage());
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 110 */       this.soapPart = ((SOAPPartImpl)soapMessage.getSOAPPart());
/*     */ 
/* 112 */       while (this.reader.hasNext())
/*     */       {
/* 115 */         if (this.reader.isStartElement())
/*     */         {
/* 117 */           processStartElement();
/*     */         }
/* 119 */         else if (this.reader.isCharacters())
/*     */         {
/* 121 */           processCharacters();
/*     */         }
/* 123 */         else if (this.reader.isEndElement())
/*     */         {
/* 125 */           processEndElement();
/*     */         }
/*     */ 
/* 128 */         this.reader.next();
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (XMLStreamException e)
/*     */     {
/* 134 */       if (!ignoreParseError)
/* 135 */         throw new IOException("Failed to parse stream: " + e.getMessage());
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/* 141 */         if (this.reader != null) {
/* 142 */           this.reader.close();
/*     */         }
/*     */       }
/*     */       catch (XMLStreamException e)
/*     */       {
/*     */       }
/*     */     }
/* 149 */     return this.soapEnv;
/*     */   }
/*     */ 
/*     */   private static synchronized XMLInputFactory getFactoryInstance()
/*     */   {
/* 154 */     if (null == factory)
/*     */     {
/* 156 */       System.setProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
/*     */ 
/* 158 */       factory = XMLInputFactory.newInstance();
/* 159 */       factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
/* 160 */       ((WstxInputFactory)factory).configureForSpeed();
/*     */     }
/* 162 */     return factory;
/*     */   }
/*     */ 
/*     */   private void processCharacters()
/*     */     throws SOAPException
/*     */   {
/* 168 */     if (this.fragmentRootCursor != null)
/* 169 */       consumeCharacters();
/*     */   }
/*     */ 
/*     */   private void consumeCharacters()
/*     */     throws SOAPException
/*     */   {
/* 175 */     String text = normalize(this.reader.getText());
/*     */ 
/* 177 */     if ((!atPartMargin()) && (!this.reader.isWhiteSpace()))
/*     */     {
/* 180 */       this.fragmentBuffer.append(text);
/*     */ 
/* 182 */       if (Part.FAULT == this.currentPart)
/*     */       {
/* 184 */         String localName = this.currentRootElement.getLocalPart();
/* 185 */         SOAPFault fault = this.soapEnv.getBody().getFault();
/* 186 */         if ("faultcode".equalsIgnoreCase(localName))
/* 187 */           fault.setFaultCode(text);
/* 188 */         else if ("faultactor".equalsIgnoreCase(localName))
/* 189 */           fault.setFaultActor(text);
/* 190 */         else if ("faultstring".equalsIgnoreCase(localName))
/* 191 */           fault.setFaultString(text);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void processEndElement() throws SOAPException
/*     */   {
/* 198 */     if (this.fragmentRootCursor != null)
/* 199 */       consumeEndElement();
/*     */   }
/*     */ 
/*     */   private void consumeEndElement()
/*     */     throws SOAPException
/*     */   {
/* 205 */     QName qName = this.reader.getName();
/*     */ 
/* 207 */     this.fragmentBuffer.append("</");
/* 208 */     this.fragmentBuffer.append(getFQElementName(qName));
/* 209 */     this.fragmentBuffer.append(">");
/*     */ 
/* 211 */     if ((this.fragmentRootCursor != null) && (this.fragmentRootCursor.equals(qName)))
/*     */     {
/* 213 */       flushBuffer();
/* 214 */       this.fragmentRootCursor = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   private void flushBuffer() throws SOAPException
/*     */   {
/* 220 */     if (Part.HEADER == this.currentPart)
/*     */     {
/* 222 */       SOAPHeader soapHeader = this.soapEnv.getHeader();
/* 223 */       SOAPContentElement lastHeaderElement = (SOAPContentElement)soapHeader.getChildNodes().item(soapHeader.getChildNodes().getLength() - 1);
/* 224 */       lastHeaderElement.setXMLFragment(bufferToFragment(this.fragmentBuffer));
/*     */     }
/* 226 */     else if (Part.BODY == this.currentPart)
/*     */     {
/* 228 */       SOAPBody soapBody = this.soapEnv.getBody();
/* 229 */       SOAPContentElement lastBodyElement = (SOAPContentElement)soapBody.getChildNodes().item(soapBody.getChildNodes().getLength() - 1);
/* 230 */       lastBodyElement.setXMLFragment(bufferToFragment(this.fragmentBuffer));
/*     */     }
/* 232 */     else if (Part.FAULT == this.currentPart)
/*     */     {
/* 234 */       SOAPBody soapBody = this.soapEnv.getBody();
/* 235 */       SOAPContentElement faultElement = (SOAPContentElement)soapBody.getFault();
/* 236 */       faultElement.setXMLFragment(bufferToFragment(this.fragmentBuffer));
/*     */     }
/*     */ 
/* 239 */     resetFragmentBuffer();
/*     */   }
/*     */ 
/*     */   private XMLFragment bufferToFragment(StringBuffer fragmentBuffer)
/*     */   {
/* 244 */     StreamSource source = new StreamSource(new ByteArrayInputStream(fragmentBuffer.toString().getBytes()));
/* 245 */     return new XMLFragment(source);
/*     */   }
/*     */ 
/*     */   private void processStartElement()
/*     */     throws SOAPException
/*     */   {
/* 251 */     QName qName = this.reader.getName();
/* 252 */     this.currentRootElement = qName;
/*     */ 
/* 255 */     togglePartMargin(qName);
/*     */ 
/* 258 */     Element destElement = null;
/* 259 */     if (Part.ENVELOPE == this.currentPart)
/*     */     {
/* 262 */       this.soapEnv = new SOAPEnvelopeImpl(this.soapPart, qName.getNamespaceURI(), false);
/* 263 */       destElement = this.soapEnv;
/*     */     }
/* 265 */     else if (Part.HEADER == this.currentPart)
/*     */     {
/* 267 */       if (atPartMargin())
/*     */       {
/* 270 */         SOAPHeader soapHeader = this.soapEnv.getHeader();
/* 271 */         destElement = soapHeader;
/* 272 */         this.previousPart = Part.HEADER;
/*     */       }
/*     */       else
/*     */       {
/* 277 */         if (this.fragmentRootCursor == null)
/*     */         {
/* 279 */           Name name = new NameImpl(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
/* 280 */           SOAPContentElement headerElement = new SOAPHeaderElementImpl(name);
/* 281 */           this.soapEnv.getHeader().addChildElement(headerElement);
/*     */ 
/* 283 */           destElement = headerElement;
/* 284 */           this.fragmentRootCursor = qName;
/*     */         }
/*     */ 
/* 287 */         consumeStartElement();
/*     */       }
/*     */     }
/* 290 */     else if (Part.BODY == this.currentPart)
/*     */     {
/* 293 */       SOAPBody soapBody = this.soapEnv.getBody();
/*     */ 
/* 295 */       if (atPartMargin())
/*     */       {
/* 298 */         destElement = soapBody;
/* 299 */         this.previousPart = Part.BODY;
/*     */       }
/*     */       else
/*     */       {
/* 304 */         Name bodyElementName = new NameImpl(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
/*     */ 
/* 306 */         if (this.fragmentRootCursor == null)
/*     */         {
/* 308 */           SOAPBodyElementDoc docBodyElement = new SOAPBodyElementDoc(bodyElementName);
/* 309 */           docBodyElement = (SOAPBodyElementDoc)soapBody.addChildElement(docBodyElement);
/*     */ 
/* 311 */           destElement = docBodyElement;
/* 312 */           this.fragmentRootCursor = qName;
/*     */         }
/*     */ 
/* 315 */         consumeStartElement();
/*     */       }
/*     */     }
/* 318 */     else if (Part.FAULT == this.currentPart)
/*     */     {
/* 321 */       if (atPartMargin())
/*     */       {
/* 323 */         SOAPBody soapBody = this.soapEnv.getBody();
/* 324 */         SOAPFaultImpl soapFault = new SOAPFaultImpl(this.soapEnv.getPrefix(), this.soapEnv.getNamespaceURI());
/* 325 */         soapBody.addChildElement(soapFault);
/* 326 */         destElement = soapFault;
/* 327 */         this.previousPart = Part.FAULT;
/*     */       }
/*     */ 
/* 330 */       if (this.fragmentRootCursor == null)
/*     */       {
/* 332 */         this.fragmentRootCursor = qName;
/*     */       }
/*     */ 
/* 335 */       consumeStartElement();
/*     */     }
/*     */ 
/* 338 */     if (this.fragmentRootCursor == null)
/*     */     {
/* 340 */       copyAttributes(destElement);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void togglePartMargin(QName qName)
/*     */   {
/* 347 */     if (qName.getLocalPart().equalsIgnoreCase("Header"))
/*     */     {
/* 349 */       this.previousPart = this.currentPart;
/* 350 */       this.currentPart = Part.HEADER;
/*     */     }
/* 352 */     else if (qName.getLocalPart().equalsIgnoreCase("Body"))
/*     */     {
/* 354 */       this.previousPart = this.currentPart;
/* 355 */       this.currentPart = Part.BODY;
/*     */     }
/* 357 */     else if (qName.getLocalPart().equalsIgnoreCase("Fault"))
/*     */     {
/* 359 */       this.previousPart = this.currentPart;
/* 360 */       this.currentPart = Part.FAULT;
/*     */     }
/*     */   }
/*     */ 
/*     */   private void consumeStartElement()
/*     */   {
/* 367 */     QName qName = this.reader.getName();
/*     */ 
/* 370 */     this.fragmentBuffer.append("<");
/* 371 */     this.fragmentBuffer.append(getFQElementName(qName));
/*     */ 
/* 374 */     for (int x = 0; x < this.reader.getNamespaceCount(); x++)
/*     */     {
/* 376 */       if (this.reader.getNamespacePrefix(x) != null)
/*     */       {
/* 378 */         this.fragmentBuffer.append(" xmlns:");
/* 379 */         this.fragmentBuffer.append(this.reader.getNamespacePrefix(x)).append("='");
/* 380 */         this.fragmentBuffer.append(this.reader.getNamespaceURI(x)).append("'");
/*     */       } else {
/* 382 */         if (this.reader.getNamespaceURI(x) == null)
/*     */           continue;
/* 384 */         this.fragmentBuffer.append(" xmlns='");
/* 385 */         this.fragmentBuffer.append(this.reader.getNamespaceURI(x)).append("'");
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 390 */     if (this.reader.getAttributeCount() > 0)
/*     */     {
/* 392 */       for (int i = 0; i < this.reader.getAttributeCount(); i++)
/*     */       {
/* 394 */         QName attQName = this.reader.getAttributeName(i);
/* 395 */         this.fragmentBuffer.append(" ").append(getFQElementName(attQName));
/* 396 */         this.fragmentBuffer.append("='").append(this.reader.getAttributeValue(i)).append("'");
/*     */       }
/*     */     }
/*     */ 
/* 400 */     this.fragmentBuffer.append(">");
/*     */   }
/*     */ 
/*     */   private String getFQElementName(QName qName)
/*     */   {
/* 405 */     return !qName.getPrefix().equals("") ? qName.getPrefix() + ":" + qName.getLocalPart() : qName.getLocalPart();
/*     */   }
/*     */ 
/*     */   private void copyAttributes(Element destElement)
/*     */   {
/* 411 */     if (this.reader.getAttributeCount() == 0) {
/* 412 */       return;
/*     */     }
/* 414 */     for (int i = 0; i < this.reader.getAttributeCount(); i++)
/*     */     {
/* 416 */       destElement.setAttributeNS(this.reader.getAttributeNamespace(i), this.reader.getAttributeLocalName(i), this.reader.getAttributeValue(i));
/*     */     }
/*     */   }
/*     */ 
/*     */   private boolean atPartMargin()
/*     */   {
/* 422 */     return this.previousPart != this.currentPart;
/*     */   }
/*     */ 
/*     */   private static String normalize(String valueStr)
/*     */   {
/* 429 */     boolean found = false;
/* 430 */     int i = 0;
/*     */ 
/* 432 */     for (; i < valueStr.length(); i++)
/*     */     {
/* 434 */       switch (valueStr.charAt(i))
/*     */       {
/*     */       case '"':
/*     */       case '&':
/*     */       case '<':
/*     */       case '>':
/* 440 */         found = true;
/* 441 */         break label71;
/*     */       }
/*     */     }
/*     */ 
/* 445 */     label71: if (!found) {
/* 446 */       return valueStr;
/*     */     }
/*     */ 
/* 449 */     StringBuilder builder = new StringBuilder();
/* 450 */     builder.append(valueStr.substring(0, i));
/* 451 */     for (; i < valueStr.length(); i++)
/*     */     {
/* 453 */       char c = valueStr.charAt(i);
/* 454 */       switch (c)
/*     */       {
/*     */       case '<':
/* 457 */         builder.append("&lt;");
/* 458 */         break;
/*     */       case '>':
/* 460 */         builder.append("&gt;");
/* 461 */         break;
/*     */       case '&':
/* 463 */         builder.append("&amp;");
/* 464 */         break;
/*     */       case '"':
/* 466 */         builder.append("&quot;");
/* 467 */         break;
/*     */       default:
/* 469 */         builder.append(c);
/*     */       }
/*     */     }
/*     */ 
/* 473 */     return builder.toString();
/*     */   }
/*     */ 
/*     */   public SOAPEnvelope build(SOAPMessage soapMessage, Reader reader, boolean ignoreParseError) throws IOException, SOAPException
/*     */   {
/* 478 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public SOAPEnvelope build(SOAPMessage soapMessage, Element domEnv) throws SOAPException
/*     */   {
/* 483 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public SOAPBodyElement buildBodyElementDoc(SOAPBodyImpl soapBody, Element domBodyElement) throws SOAPException
/*     */   {
/* 488 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public SOAPBodyElement buildBodyElementRpc(SOAPBodyImpl soapBody, Element domBodyElement) throws SOAPException
/*     */   {
/* 493 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public Style getStyle()
/*     */   {
/* 498 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public void setStyle(Style style)
/*     */   {
/* 503 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   private static enum Part
/*     */   {
/*  69 */     ENVELOPE, HEADER, BODY, FAULT, RPC_PAYLOAD, DOC_PAYLOAD, BARE_PAYLOAD;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.EnvelopeBuilderStax
 * JD-Core Version:    0.6.0
 */