/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.Name;
/*     */ import javax.xml.soap.Node;
/*     */ import javax.xml.soap.SOAPBody;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.soap.SOAPEnvelope;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPHeader;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import org.jboss.ws.Constants;
/*     */ import org.jboss.ws.core.CommonSOAPFaultException;
/*     */ import org.w3c.dom.Document;
/*     */ 
/*     */ public class SOAPEnvelopeImpl extends SOAPElementImpl
/*     */   implements SOAPEnvelope
/*     */ {
/*     */   private SOAPPartImpl soapPart;
/*     */ 
/*     */   public SOAPEnvelopeImpl(SOAPPartImpl soapPart, SOAPElement element, boolean addHeaderAndBody)
/*     */     throws SOAPException
/*     */   {
/*  60 */     super((SOAPElementImpl)element);
/*     */ 
/*  62 */     this.soapPart = soapPart;
/*  63 */     soapPart.setEnvelope(this);
/*     */ 
/*  65 */     String prefix = getPrefix();
/*  66 */     String namespaceURI = getNamespaceURI();
/*  67 */     String localName = getLocalName();
/*     */ 
/*  69 */     if (!"Envelope".equals(localName)) {
/*  70 */       throw new IllegalArgumentException("Cannot create SOAP envelope from: " + element.getElementQName());
/*     */     }
/*  72 */     assertEnvelopeNamespace(namespaceURI);
/*  73 */     addNamespaceDeclaration(prefix, namespaceURI);
/*     */ 
/*  75 */     if (addHeaderAndBody)
/*     */     {
/*  77 */       addHeader();
/*  78 */       addBody();
/*     */     }
/*     */   }
/*     */ 
/*     */   SOAPEnvelopeImpl(SOAPPartImpl soapPart, String namespace, boolean addHeaderAndBody)
/*     */     throws SOAPException
/*     */   {
/*  86 */     super("Envelope", "env", namespace);
/*     */ 
/*  88 */     this.soapPart = soapPart;
/*  89 */     soapPart.setEnvelope(this);
/*     */ 
/*  91 */     assertEnvelopeNamespace(namespace);
/*  92 */     addNamespaceDeclaration(getPrefix(), namespace);
/*     */ 
/*  94 */     if (addHeaderAndBody)
/*     */     {
/*  96 */       addHeader();
/*  97 */       addBody();
/*     */     }
/*     */   }
/*     */ 
/*     */   public SOAPMessage getSOAPMessage()
/*     */   {
/* 103 */     return this.soapPart.getSOAPMessage();
/*     */   }
/*     */ 
/*     */   public SOAPBody addBody() throws SOAPException
/*     */   {
/* 108 */     SOAPBody body = getBody();
/* 109 */     if (body != null) {
/* 110 */       throw new SOAPException("SOAPEnvelope already has a body element");
/*     */     }
/* 112 */     body = new SOAPBodyImpl(getPrefix(), getNamespaceURI());
/* 113 */     addChildElement(body);
/* 114 */     return body;
/*     */   }
/*     */ 
/*     */   public SOAPHeader addHeader() throws SOAPException
/*     */   {
/* 119 */     SOAPHeader header = getHeader();
/* 120 */     if (header != null) {
/* 121 */       throw new SOAPException("SOAPEnvelope already has a header element");
/*     */     }
/* 123 */     header = new SOAPHeaderImpl(getPrefix(), getNamespaceURI());
/* 124 */     return (SOAPHeader)addChildElement(header);
/*     */   }
/*     */ 
/*     */   public SOAPElement addAttribute(Name name, String value)
/*     */     throws SOAPException
/*     */   {
/* 130 */     String envNamespace = getNamespaceURI();
/* 131 */     if (("http://www.w3.org/2003/05/soap-envelope".equals(envNamespace)) && (name.equals(new NameImpl("encodingStyle", "env", envNamespace)))) {
/* 132 */       throw new SOAPException("Cannot set encodingStyle on: " + getElementQName());
/*     */     }
/* 134 */     return super.addAttribute(name, value);
/*     */   }
/*     */ 
/*     */   public SOAPElement addChildElement(SOAPElement child)
/*     */     throws SOAPException
/*     */   {
/* 140 */     String envNamespace = getNamespaceURI();
/* 141 */     if (("http://www.w3.org/2003/05/soap-envelope".equals(envNamespace)) && (!(child instanceof SOAPHeader)) && (!(child instanceof SOAPBody))) {
/* 142 */       throw new SOAPException("SOAPHeader or SOAPBody expected");
/*     */     }
/* 144 */     return super.addChildElement(child);
/*     */   }
/*     */ 
/*     */   public Name createName(String localName) throws SOAPException
/*     */   {
/* 149 */     return new NameImpl(localName);
/*     */   }
/*     */ 
/*     */   public Name createName(String localName, String prefix, String uri) throws SOAPException
/*     */   {
/* 154 */     return new NameImpl(localName, prefix, uri);
/*     */   }
/*     */ 
/*     */   public SOAPBody getBody() throws SOAPException
/*     */   {
/* 159 */     Iterator it = getChildElements();
/* 160 */     while (it.hasNext())
/*     */     {
/* 162 */       Node node = (Node)it.next();
/* 163 */       if ("Body".equals(node.getLocalName()))
/* 164 */         return (SOAPBody)node;
/*     */     }
/* 166 */     return null;
/*     */   }
/*     */ 
/*     */   public SOAPHeader getHeader() throws SOAPException
/*     */   {
/* 171 */     Iterator it = getChildElements();
/* 172 */     while (it.hasNext())
/*     */     {
/* 174 */       Node node = (Node)it.next();
/* 175 */       if ("Header".equals(node.getLocalName()))
/* 176 */         return (SOAPHeader)node;
/*     */     }
/* 178 */     return null;
/*     */   }
/*     */ 
/*     */   public SOAPElement addTextNode(String value)
/*     */     throws SOAPException
/*     */   {
/* 186 */     if (value.trim().length() > 0) {
/* 187 */       throw new SOAPException("Cannot add Text node to SOAPEnvelope");
/*     */     }
/* 189 */     return super.addTextNode(value);
/*     */   }
/*     */ 
/*     */   public Document getOwnerDocument()
/*     */   {
/* 194 */     return this.soapPart;
/*     */   }
/*     */ 
/*     */   private void assertEnvelopeNamespace(String namespaceURI)
/*     */   {
/* 199 */     if ((!"http://www.w3.org/2003/05/soap-envelope".equals(namespaceURI)) && (!"http://schemas.xmlsoap.org/soap/envelope/".equals(namespaceURI)))
/*     */     {
/* 201 */       QName faultCode = Constants.SOAP11_FAULT_CODE_VERSION_MISMATCH;
/* 202 */       String faultString = "Invalid SOAP envelope namespace: " + namespaceURI;
/* 203 */       throw new CommonSOAPFaultException(faultCode, faultString);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.SOAPEnvelopeImpl
 * JD-Core Version:    0.6.0
 */