/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStream;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import javax.mail.MessagingException;
/*     */ import javax.xml.soap.AttachmentPart;
/*     */ import javax.xml.soap.MimeHeader;
/*     */ import javax.xml.soap.MimeHeaders;
/*     */ import javax.xml.soap.SOAPBody;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.soap.SOAPEnvelope;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPFault;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.soap.SOAPPart;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.SOAPMessageAbstraction;
/*     */ import org.jboss.ws.core.soap.attachment.AttachmentPartImpl;
/*     */ import org.jboss.ws.core.soap.attachment.CIDGenerator;
/*     */ import org.jboss.ws.core.soap.attachment.MultipartRelatedEncoder;
/*     */ import org.jboss.ws.core.soap.attachment.MultipartRelatedSwAEncoder;
/*     */ import org.jboss.ws.core.soap.attachment.MultipartRelatedXOPEncoder;
/*     */ import org.jboss.ws.extensions.xop.XOPContext;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ 
/*     */ public class SOAPMessageImpl extends SOAPMessage
/*     */   implements SOAPMessageAbstraction
/*     */ {
/*  52 */   private boolean saveRequired = true;
/*  53 */   private MimeHeaders mimeHeaders = new MimeHeaders();
/*  54 */   private List<AttachmentPart> attachments = new LinkedList();
/*  55 */   private CIDGenerator cidGenerator = new CIDGenerator();
/*     */   private boolean isXOPMessage;
/*     */   private boolean isSWARefMessage;
/*     */   private SOAPPartImpl soapPart;
/*     */   private MultipartRelatedEncoder multipartRelatedEncoder;
/*     */   private OperationMetaData opMetaData;
/*     */ 
/*     */   SOAPMessageImpl()
/*     */     throws SOAPException
/*     */   {
/*  66 */     this.soapPart = new SOAPPartImpl(this);
/*  67 */     setProperty("javax.xml.soap.character-set-encoding", "UTF-8");
/*  68 */     setProperty("javax.xml.soap.write-xml-declaration", Boolean.valueOf(false));
/*     */   }
/*     */ 
/*     */   public CIDGenerator getCidGenerator()
/*     */   {
/*  73 */     return this.cidGenerator;
/*     */   }
/*     */ 
/*     */   public boolean isXOPMessage()
/*     */   {
/*  78 */     return this.isXOPMessage;
/*     */   }
/*     */ 
/*     */   public void setXOPMessage(boolean isXOPMessage)
/*     */   {
/*  83 */     this.isXOPMessage = isXOPMessage;
/*     */   }
/*     */ 
/*     */   public boolean isSWARefMessage()
/*     */   {
/*  88 */     return this.isSWARefMessage;
/*     */   }
/*     */ 
/*     */   public void setSWARefMessage(boolean isSWAMessage)
/*     */   {
/*  93 */     this.isSWARefMessage = isSWAMessage;
/*     */   }
/*     */ 
/*     */   public void setAttachments(Collection<AttachmentPart> parts) throws SOAPException
/*     */   {
/*  98 */     for (AttachmentPart part : parts)
/*     */     {
/* 100 */       this.attachments.add(part);
/*     */     }
/* 102 */     this.saveRequired = true;
/*     */   }
/*     */ 
/*     */   public void addAttachmentPart(AttachmentPart part)
/*     */   {
/* 107 */     if (part == null) {
/* 108 */       return;
/*     */     }
/* 110 */     this.attachments.add(part);
/* 111 */     this.saveRequired = true;
/*     */   }
/*     */ 
/*     */   public AttachmentPart getAttachmentByContentId(String cid) throws SOAPException
/*     */   {
/* 116 */     for (AttachmentPart part : this.attachments)
/*     */     {
/* 118 */       String contentId = part.getContentId();
/* 119 */       if (contentId.equals(cid))
/* 120 */         return part;
/*     */     }
/* 122 */     return null;
/*     */   }
/*     */ 
/*     */   public AttachmentPart removeAttachmentByContentId(String cid)
/*     */   {
/* 127 */     for (AttachmentPart part : this.attachments)
/*     */     {
/* 129 */       String contentId = part.getContentId();
/* 130 */       if (contentId.equals(cid))
/*     */       {
/* 132 */         this.attachments.remove(part);
/* 133 */         return part;
/*     */       }
/*     */     }
/*     */ 
/* 137 */     return null;
/*     */   }
/*     */ 
/*     */   public AttachmentPart getAttachmentByPartName(String partName)
/*     */   {
/* 142 */     for (AttachmentPart part : this.attachments)
/*     */     {
/* 144 */       String contentId = part.getContentId();
/* 145 */       if (contentId.startsWith("<" + partName + "="))
/* 146 */         return part;
/*     */     }
/* 148 */     return null;
/*     */   }
/*     */ 
/*     */   public AttachmentPart createAttachmentPart()
/*     */   {
/* 153 */     return new AttachmentPartImpl();
/*     */   }
/*     */ 
/*     */   public String getContentDescription()
/*     */   {
/* 158 */     String[] value = this.mimeHeaders.getHeader("Content-Description");
/*     */ 
/* 160 */     return value == null ? null : value[0];
/*     */   }
/*     */ 
/*     */   public void setContentDescription(String description)
/*     */   {
/* 165 */     this.mimeHeaders.setHeader("Content-Description", description);
/*     */   }
/*     */ 
/*     */   public MimeHeaders getMimeHeaders()
/*     */   {
/* 170 */     return this.mimeHeaders;
/*     */   }
/*     */ 
/*     */   public void setMimeHeaders(MimeHeaders headers)
/*     */   {
/* 175 */     if (headers == null)
/* 176 */       throw new IllegalArgumentException("MimeHeaders cannot be null");
/* 177 */     this.mimeHeaders = headers;
/*     */   }
/*     */ 
/*     */   public SOAPPart getSOAPPart()
/*     */   {
/* 182 */     return this.soapPart;
/*     */   }
/*     */ 
/*     */   public void removeAllAttachments()
/*     */   {
/* 187 */     this.attachments.clear();
/* 188 */     this.saveRequired = true;
/*     */   }
/*     */ 
/*     */   public int countAttachments()
/*     */   {
/* 193 */     return this.attachments.size();
/*     */   }
/*     */ 
/*     */   public Iterator getAttachments()
/*     */   {
/* 199 */     this.saveRequired = true;
/* 200 */     return this.attachments.iterator();
/*     */   }
/*     */ 
/*     */   public Iterator getAttachments(MimeHeaders headers)
/*     */   {
/* 205 */     if (headers == null) {
/* 206 */       throw new WSException("MimeHeaders can not be null");
/*     */     }
/* 208 */     return new MimeMatchingAttachmentsIterator(headers, this.attachments);
/*     */   }
/*     */ 
/*     */   public void saveChanges() throws SOAPException
/*     */   {
/* 213 */     if (this.saveRequired == true)
/*     */     {
/*     */       try
/*     */       {
/* 217 */         boolean hasAttachments = this.attachments.size() > 0;
/*     */ 
/* 219 */         if ((isXOPMessage()) && (!XOPContext.isMTOMEnabled()) && (hasAttachments)) {
/* 220 */           throw new IllegalStateException("XOP parameter not properly inlined");
/*     */         }
/*     */ 
/* 223 */         String contentType = "text/xml; charset=" + getCharSetEncoding();
/*     */ 
/* 225 */         if (hasAttachments)
/*     */         {
/* 227 */           if ((isXOPMessage()) && (XOPContext.isMTOMEnabled()))
/*     */           {
/* 229 */             this.multipartRelatedEncoder = new MultipartRelatedXOPEncoder(this);
/* 230 */             this.multipartRelatedEncoder.encodeMultipartRelatedMessage();
/* 231 */             contentType = this.multipartRelatedEncoder.getContentType();
/*     */           }
/*     */           else
/*     */           {
/* 235 */             this.multipartRelatedEncoder = new MultipartRelatedSwAEncoder(this);
/* 236 */             this.multipartRelatedEncoder.encodeMultipartRelatedMessage();
/* 237 */             contentType = this.multipartRelatedEncoder.getContentType();
/*     */           }
/*     */         }
/*     */ 
/* 241 */         this.mimeHeaders.setHeader("Content-Type", contentType);
/*     */       }
/*     */       catch (MessagingException ex)
/*     */       {
/* 245 */         throw new SOAPException(ex);
/*     */       }
/*     */ 
/* 259 */       this.saveRequired = false;
/*     */     }
/*     */ 
/* 262 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 263 */     if (msgContext != null) msgContext.setModified(true);
/*     */   }
/*     */ 
/*     */   public boolean saveRequired()
/*     */   {
/* 268 */     return this.saveRequired;
/*     */   }
/*     */ 
/*     */   public void writeTo(OutputStream outs)
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 276 */       saveChanges();
/*     */ 
/* 279 */       if (this.attachments.size() > 0)
/*     */       {
/* 281 */         this.multipartRelatedEncoder.writeTo(outs);
/*     */       }
/*     */       else
/*     */       {
/* 285 */         SOAPEnvelope soapEnv = getSOAPPart().getEnvelope();
/* 286 */         if (soapEnv != null)
/*     */         {
/* 288 */           boolean writeXML = isWriteXMLDeclaration();
/* 289 */           String charsetEncoding = getCharSetEncoding();
/* 290 */           SOAPElementWriter writer = new SOAPElementWriter(outs, charsetEncoding);
/* 291 */           writer.setWriteXMLDeclaration(writeXML).writeElement((SOAPEnvelopeImpl)soapEnv);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (SOAPException ex)
/*     */     {
/* 297 */       WSException.rethrow(ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getCharSetEncoding() throws SOAPException
/*     */   {
/* 303 */     String charsetName = (String)getProperty("javax.xml.soap.character-set-encoding");
/* 304 */     if (charsetName == null)
/* 305 */       charsetName = "UTF-8";
/* 306 */     return charsetName;
/*     */   }
/*     */ 
/*     */   public OperationMetaData getOperationMetaData(EndpointMetaData epMetaData)
/*     */     throws SOAPException
/*     */   {
/* 313 */     if (this.opMetaData == null)
/*     */     {
/* 315 */       SOAPMessageDispatcher dispatcher = new SOAPMessageDispatcher();
/* 316 */       this.opMetaData = dispatcher.getDispatchDestination(epMetaData, this);
/*     */     }
/* 318 */     return this.opMetaData;
/*     */   }
/*     */ 
/*     */   public boolean isFaultMessage()
/*     */   {
/* 323 */     SOAPFault soapFault = null;
/*     */     try
/*     */     {
/* 326 */       soapFault = getSOAPBody().getFault();
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/*     */     }
/* 331 */     return soapFault != null;
/*     */   }
/*     */ 
/*     */   private boolean isWriteXMLDeclaration() throws SOAPException
/*     */   {
/* 336 */     Boolean booleanValue = new Boolean(false);
/* 337 */     Object propValue = getProperty("javax.xml.soap.write-xml-declaration");
/* 338 */     if ((propValue instanceof Boolean))
/* 339 */       booleanValue = (Boolean)propValue;
/* 340 */     if ((propValue instanceof String))
/* 341 */       booleanValue = new Boolean((String)propValue);
/* 342 */     return booleanValue.booleanValue();
/*     */   }
/*     */ 
/*     */   public AttachmentPart getAttachment(SOAPElement element)
/*     */     throws SOAPException
/*     */   {
/* 428 */     String ref = element.getAttribute("href");
/*     */ 
/* 430 */     if (ref.length() == 0)
/*     */     {
/* 432 */       ref = element.getValue();
/* 433 */       if ((ref == null) || (ref.length() == 0)) {
/* 434 */         return null;
/*     */       }
/*     */     }
/* 437 */     return getAttachmentByRef(ref);
/*     */   }
/*     */ 
/*     */   private AttachmentPart getAttachmentByRef(String ref)
/*     */     throws SOAPException
/*     */   {
/*     */     AttachmentPart attachment;
/*     */     AttachmentPart attachment;
/* 443 */     if (ref.startsWith("cid:"))
/*     */     {
/* 451 */       String cid = '<' + ref.substring("cid:".length()) + '>';
/* 452 */       attachment = getAttachmentByContentId(cid);
/*     */     }
/*     */     else
/*     */     {
/* 459 */       attachment = getAttachmentByContentLocation(ref);
/*     */     }
/*     */ 
/* 462 */     if (attachment == null)
/*     */     {
/* 465 */       attachment = getAttachmentByPartName(ref);
/*     */     }
/*     */ 
/* 468 */     return attachment;
/*     */   }
/*     */ 
/*     */   private AttachmentPart getAttachmentByContentLocation(String location)
/*     */   {
/* 480 */     for (AttachmentPart attachment : this.attachments)
/*     */     {
/* 482 */       if (location.equals(attachment.getContentLocation()))
/* 483 */         return attachment;
/*     */     }
/* 485 */     return null;
/*     */   }
/*     */ 
/*     */   public void removeAttachments(MimeHeaders headers)
/*     */   {
/* 494 */     Iterator attachmentItr = new MimeMatchingAttachmentsIterator(headers, this.attachments);
/* 495 */     while (attachmentItr.next() != null)
/* 496 */       attachmentItr.remove();
/*     */   }
/*     */ 
/*     */   public static class MimeMatchingAttachmentsIterator
/*     */     implements Iterator
/*     */   {
/*     */     private Iterator iterator;
/* 349 */     private MimeHeaders headers = new MimeHeaders();
/*     */     private AttachmentPart lastMatch;
/*     */ 
/*     */     public MimeMatchingAttachmentsIterator(MimeHeaders headers, List attachments)
/*     */     {
/* 355 */       this.iterator = attachments.iterator();
/*     */ 
/* 357 */       if (headers != null)
/* 358 */         this.headers = headers;
/*     */     }
/*     */ 
/*     */     private boolean containsAllHeaders(Iterator headerIterator, AttachmentPart part)
/*     */     {
/* 363 */       while (headerIterator.hasNext())
/*     */       {
/* 365 */         MimeHeader header = (MimeHeader)headerIterator.next();
/* 366 */         String[] values = part.getMimeHeader(header.getName());
/* 367 */         if (values == null) {
/* 368 */           return false;
/*     */         }
/* 370 */         boolean match = false;
/* 371 */         for (int j = 0; j < values.length; j++)
/*     */         {
/* 373 */           if (!values[j].equalsIgnoreCase(header.getValue()))
/*     */             continue;
/* 375 */           match = true;
/* 376 */           break;
/*     */         }
/*     */ 
/* 380 */         if (!match) {
/* 381 */           return false;
/*     */         }
/*     */       }
/* 384 */       return true;
/*     */     }
/*     */ 
/*     */     private void nextMatch()
/*     */     {
/* 389 */       while (this.iterator.hasNext())
/*     */       {
/* 391 */         AttachmentPart part = (AttachmentPart)this.iterator.next();
/* 392 */         if (containsAllHeaders(this.headers.getAllHeaders(), part))
/*     */         {
/* 394 */           this.lastMatch = part;
/* 395 */           break;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     public boolean hasNext()
/*     */     {
/* 402 */       if (this.lastMatch == null) {
/* 403 */         nextMatch();
/*     */       }
/* 405 */       return this.lastMatch != null;
/*     */     }
/*     */ 
/*     */     public Object next()
/*     */     {
/* 410 */       if (!hasNext()) {
/* 411 */         return null;
/*     */       }
/* 413 */       Object retval = this.lastMatch;
/* 414 */       this.lastMatch = null;
/*     */ 
/* 416 */       return retval;
/*     */     }
/*     */ 
/*     */     public void remove()
/*     */     {
/* 421 */       this.iterator.remove();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.SOAPMessageImpl
 * JD-Core Version:    0.6.0
 */