/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.xml.soap.MimeHeaders;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.marshal.UnMarshaller;
/*     */ import org.jboss.ws.WSException;
/*     */ 
/*     */ public class SOAPMessageUnMarshaller
/*     */   implements UnMarshaller
/*     */ {
/*  50 */   private static Logger log = Logger.getLogger(SOAPMessageUnMarshaller.class);
/*     */ 
/*  52 */   private static List validResponseCodes = new ArrayList();
/*     */ 
/*     */   public Object read(InputStream inputStream, Map metadata)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  63 */     if (log.isTraceEnabled())
/*  64 */       log.trace("Read input stream with metadata=" + metadata);
/*     */     IOException e2;
/*     */     try {
/*  68 */       Integer resCode = (Integer)metadata.get("ResponseCode");
/*  69 */       if (resCode == null)
/*     */       {
/*  71 */         log.warn("No HTTP resonse code, assuming: SC_OK");
/*  72 */         resCode = Integer.valueOf(200);
/*     */       }
/*     */ 
/*  75 */       String resMessage = (String)metadata.get("ResponseCodeMessage");
/*  76 */       if (!validResponseCodes.contains(resCode)) {
/*  77 */         throw new WSException("Invalid HTTP server response [" + resCode + "] - " + resMessage);
/*     */       }
/*     */ 
/*  80 */       SOAPMessage soapMsg = null;
/*  81 */       if (resCode.intValue() != 204)
/*     */       {
/*  83 */         MimeHeaders mimeHeaders = getMimeHeaders(metadata);
/*  84 */         soapMsg = new MessageFactoryImpl().createMessage(mimeHeaders, inputStream, true);
/*     */       }
/*     */ 
/*  87 */       return soapMsg;
/*     */     }
/*     */     catch (SOAPException e)
/*     */     {
/*  91 */       log.error("Cannot unmarshall SOAPMessage", e);
/*  92 */       e2 = new IOException(e.toString());
/*  93 */       e2.initCause(e);
/*  94 */     }throw e2;
/*     */   }
/*     */ 
/*     */   public void setClassLoader(ClassLoader classloader)
/*     */   {
/*     */   }
/*     */ 
/*     */   public UnMarshaller cloneUnMarshaller()
/*     */     throws CloneNotSupportedException
/*     */   {
/* 113 */     return new SOAPMessageUnMarshaller();
/*     */   }
/*     */ 
/*     */   private MimeHeaders getMimeHeaders(Map metadata)
/*     */   {
/* 118 */     log.debug("getMimeHeaders from: " + metadata);
/*     */ 
/* 120 */     MimeHeaders headers = new MimeHeaders();
/* 121 */     Iterator i = metadata.keySet().iterator();
/*     */     String key;
/*     */     Iterator i$;
/* 122 */     while (i.hasNext())
/*     */     {
/* 124 */       key = (String)i.next();
/* 125 */       Object value = metadata.get(key);
/* 126 */       if ((key != null) && ((value instanceof List)))
/*     */       {
/* 128 */         for (i$ = ((List)value).iterator(); i$.hasNext(); ) { Object listValue = i$.next();
/*     */ 
/* 130 */           headers.addHeader(key, listValue.toString());
/*     */         }
/*     */       }
/*     */     }
/* 134 */     return headers;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  55 */     validResponseCodes.add(Integer.valueOf(200));
/*  56 */     validResponseCodes.add(Integer.valueOf(202));
/*  57 */     validResponseCodes.add(Integer.valueOf(204));
/*  58 */     validResponseCodes.add(Integer.valueOf(500));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.SOAPMessageUnMarshaller
 * JD-Core Version:    0.6.0
 */