/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.xml.soap.MimeHeaders;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.soap.SOAPEnvelope;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.soap.SOAPPart;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.transform.dom.DOMSource;
/*     */ import javax.xml.transform.stream.StreamSource;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.wsf.spi.util.ServiceLoader;
/*     */ import org.w3c.dom.Attr;
/*     */ import org.w3c.dom.CDATASection;
/*     */ import org.w3c.dom.Comment;
/*     */ import org.w3c.dom.DOMConfiguration;
/*     */ import org.w3c.dom.DOMException;
/*     */ import org.w3c.dom.DOMImplementation;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.DocumentFragment;
/*     */ import org.w3c.dom.DocumentType;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.EntityReference;
/*     */ import org.w3c.dom.NamedNodeMap;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ import org.w3c.dom.ProcessingInstruction;
/*     */ import org.w3c.dom.Text;
/*     */ import org.w3c.dom.UserDataHandler;
/*     */ 
/*     */ public class SOAPPartImpl extends SOAPPart
/*     */ {
/*  72 */   private static Logger log = Logger.getLogger(SOAPPartImpl.class);
/*     */   private SOAPMessage soapMessage;
/*     */   private SOAPEnvelope soapEnvelope;
/*  77 */   private SOAPDocument doc = new SOAPDocument();
/*     */ 
/*     */   SOAPPartImpl(SOAPMessage message)
/*     */   {
/*  81 */     this.soapMessage = message;
/*     */   }
/*     */ 
/*     */   public SOAPMessage getSOAPMessage()
/*     */   {
/*  86 */     return this.soapMessage;
/*     */   }
/*     */ 
/*     */   public SOAPEnvelope getEnvelope() throws SOAPException
/*     */   {
/*  91 */     return this.soapEnvelope;
/*     */   }
/*     */ 
/*     */   public void setEnvelope(SOAPEnvelope soapEnvelope)
/*     */   {
/*  96 */     this.soapEnvelope = soapEnvelope;
/*     */   }
/*     */ 
/*     */   public void removeMimeHeader(String s)
/*     */   {
/* 101 */     MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
/* 102 */     mimeHeaders.removeHeader(s);
/*     */   }
/*     */ 
/*     */   public void removeAllMimeHeaders()
/*     */   {
/* 107 */     MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
/* 108 */     mimeHeaders.removeAllHeaders();
/*     */   }
/*     */ 
/*     */   public String[] getMimeHeader(String name)
/*     */   {
/* 113 */     MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
/* 114 */     return mimeHeaders.getHeader(name);
/*     */   }
/*     */ 
/*     */   public void setMimeHeader(String name, String value)
/*     */   {
/* 119 */     MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
/* 120 */     mimeHeaders.setHeader(name, value);
/*     */   }
/*     */ 
/*     */   public void addMimeHeader(String name, String value)
/*     */   {
/* 125 */     MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
/* 126 */     mimeHeaders.addHeader(name, value);
/*     */   }
/*     */ 
/*     */   public Iterator getAllMimeHeaders()
/*     */   {
/* 131 */     MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
/* 132 */     return mimeHeaders.getAllHeaders();
/*     */   }
/*     */ 
/*     */   public Iterator getMatchingMimeHeaders(String[] names)
/*     */   {
/* 137 */     MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
/* 138 */     return mimeHeaders.getMatchingHeaders(names);
/*     */   }
/*     */ 
/*     */   public Iterator getNonMatchingMimeHeaders(String[] names)
/*     */   {
/* 143 */     MimeHeaders mimeHeaders = this.soapMessage.getMimeHeaders();
/* 144 */     return mimeHeaders.getNonMatchingHeaders(names);
/*     */   }
/*     */ 
/*     */   public void setContent(Source source)
/*     */     throws SOAPException
/*     */   {
/* 151 */     if (source == null)
/*     */     {
/* 153 */       if (log.isDebugEnabled()) log.debug("Setting content source to null removes the SOAPEnvelope");
/* 154 */       this.soapEnvelope = null;
/* 155 */       return;
/*     */     }
/*     */ 
/* 163 */     if ((source instanceof DOMSource))
/*     */     {
/* 166 */       DOMSource domSource = (DOMSource)source;
/* 167 */       Node node = domSource.getNode();
/*     */       Element domElement;
/* 168 */       if ((node instanceof Document)) {
/* 169 */         domElement = ((Document)node).getDocumentElement();
/*     */       }
/*     */       else
/*     */       {
/*     */         Element domElement;
/* 170 */         if ((node instanceof Element))
/* 171 */           domElement = (Element)node;
/*     */         else
/* 173 */           throw new SOAPException("Unsupported DOMSource node: " + node);
/*     */       }
/*     */       Element domElement;
/* 175 */       EnvelopeBuilder envBuilder = (EnvelopeBuilder)ServiceLoader.loadService(EnvelopeBuilder.class.getName(), EnvelopeBuilderDOM.class.getName());
/* 176 */       envBuilder.setStyle(Style.DOCUMENT);
/* 177 */       envBuilder.build(this.soapMessage, domElement);
/*     */     }
/* 179 */     else if ((source instanceof StreamSource))
/*     */     {
/*     */       try
/*     */       {
/* 183 */         StreamSource streamSource = (StreamSource)source;
/* 184 */         EnvelopeBuilder envBuilder = (EnvelopeBuilder)ServiceLoader.loadService(EnvelopeBuilder.class.getName(), EnvelopeBuilderDOM.class.getName());
/* 185 */         envBuilder.setStyle(Style.DOCUMENT);
/* 186 */         InputStream stream = streamSource.getInputStream();
/* 187 */         Reader reader = streamSource.getReader();
/* 188 */         if (stream != null)
/* 189 */           envBuilder.build(this.soapMessage, stream, false);
/* 190 */         else if (reader != null)
/* 191 */           envBuilder.build(this.soapMessage, reader, false);
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 195 */         throw new SOAPException("Cannot parse stream source", e);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 200 */       throw new SOAPException("Unsupported source parameter: " + source);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Source getContent() throws SOAPException
/*     */   {
/* 206 */     return new DOMSource(this.soapEnvelope);
/*     */   }
/*     */ 
/*     */   public DOMImplementation getImplementation()
/*     */   {
/* 213 */     return this.doc.getImplementation();
/*     */   }
/*     */ 
/*     */   public DocumentFragment createDocumentFragment()
/*     */   {
/* 218 */     return this.doc.createDocumentFragment();
/*     */   }
/*     */ 
/*     */   public DocumentType getDoctype()
/*     */   {
/* 223 */     return this.doc.getDoctype();
/*     */   }
/*     */ 
/*     */   public Element getDocumentElement()
/*     */   {
/* 228 */     return this.soapEnvelope;
/*     */   }
/*     */ 
/*     */   public Attr createAttribute(String name) throws DOMException
/*     */   {
/* 233 */     return this.doc.createAttribute(name);
/*     */   }
/*     */ 
/*     */   public CDATASection createCDATASection(String data) throws DOMException
/*     */   {
/* 238 */     return this.doc.createCDATASection(data);
/*     */   }
/*     */ 
/*     */   public Comment createComment(String data)
/*     */   {
/* 243 */     return this.doc.createComment(data);
/*     */   }
/*     */ 
/*     */   public Element createElement(String tagName) throws DOMException
/*     */   {
/* 248 */     return this.doc.createElement(tagName);
/*     */   }
/*     */ 
/*     */   public Element getElementById(String elementId)
/*     */   {
/* 253 */     return this.doc.getElementById(elementId);
/*     */   }
/*     */ 
/*     */   public EntityReference createEntityReference(String name) throws DOMException
/*     */   {
/* 258 */     return this.doc.createEntityReference(name);
/*     */   }
/*     */ 
/*     */   public Node importNode(Node importedNode, boolean deep) throws DOMException
/*     */   {
/* 263 */     return this.doc.importNode(importedNode, deep);
/*     */   }
/*     */ 
/*     */   public NodeList getElementsByTagName(String tagname)
/*     */   {
/* 268 */     return this.doc.getElementsByTagName(tagname);
/*     */   }
/*     */ 
/*     */   public Text createTextNode(String data)
/*     */   {
/* 273 */     return this.doc.createTextNode(data);
/*     */   }
/*     */ 
/*     */   public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException
/*     */   {
/* 278 */     return this.doc.createAttributeNS(namespaceURI, qualifiedName);
/*     */   }
/*     */ 
/*     */   public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException
/*     */   {
/* 283 */     return this.doc.createElementNS(namespaceURI, qualifiedName);
/*     */   }
/*     */ 
/*     */   public NodeList getElementsByTagNameNS(String namespaceURI, String localName)
/*     */   {
/* 288 */     return this.doc.getElementsByTagNameNS(namespaceURI, localName);
/*     */   }
/*     */ 
/*     */   public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException
/*     */   {
/* 293 */     return this.doc.createProcessingInstruction(target, data);
/*     */   }
/*     */ 
/*     */   public Node appendChild(Node node)
/*     */     throws DOMException
/*     */   {
/* 300 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public Node cloneNode(boolean b)
/*     */   {
/* 305 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public NamedNodeMap getAttributes()
/*     */   {
/* 310 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public NodeList getChildNodes()
/*     */   {
/* 315 */     List list = new ArrayList();
/* 316 */     if (this.soapEnvelope != null)
/*     */     {
/* 318 */       list.add((NodeImpl)this.soapEnvelope);
/*     */     }
/* 320 */     return new NodeListImpl(list);
/*     */   }
/*     */ 
/*     */   public Node getFirstChild()
/*     */   {
/* 325 */     return this.soapEnvelope;
/*     */   }
/*     */ 
/*     */   public Node getLastChild()
/*     */   {
/* 330 */     return this.soapEnvelope;
/*     */   }
/*     */ 
/*     */   public String getLocalName()
/*     */   {
/* 335 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public String getNamespaceURI()
/*     */   {
/* 340 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public Node getNextSibling()
/*     */   {
/* 345 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public String getNodeName()
/*     */   {
/* 350 */     return this.doc.getNodeName();
/*     */   }
/*     */ 
/*     */   public short getNodeType()
/*     */   {
/* 355 */     return this.doc.getNodeType();
/*     */   }
/*     */ 
/*     */   public String getNodeValue() throws DOMException
/*     */   {
/* 360 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public Document getOwnerDocument()
/*     */   {
/* 365 */     return this.doc;
/*     */   }
/*     */ 
/*     */   public Node getParentNode()
/*     */   {
/* 370 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public String getPrefix()
/*     */   {
/* 375 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public Node getPreviousSibling()
/*     */   {
/* 380 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public boolean hasAttributes()
/*     */   {
/* 385 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public boolean hasChildNodes()
/*     */   {
/* 390 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public Node insertBefore(Node node, Node node1) throws DOMException
/*     */   {
/* 395 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public boolean isSupported(String s, String s1)
/*     */   {
/* 400 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public void normalize()
/*     */   {
/* 405 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public Node removeChild(Node node) throws DOMException
/*     */   {
/* 410 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public Node replaceChild(Node node, Node node1) throws DOMException
/*     */   {
/* 415 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public void setNodeValue(String s) throws DOMException
/*     */   {
/* 420 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public void setPrefix(String s) throws DOMException
/*     */   {
/* 425 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public Node adoptNode(Node source) throws DOMException
/*     */   {
/* 430 */     throw new NotImplementedException("adoptNode");
/*     */   }
/*     */ 
/*     */   public String getDocumentURI()
/*     */   {
/* 435 */     throw new NotImplementedException("getDocumentURI");
/*     */   }
/*     */ 
/*     */   public DOMConfiguration getDomConfig()
/*     */   {
/* 440 */     throw new NotImplementedException("getDomConfig");
/*     */   }
/*     */ 
/*     */   public String getInputEncoding()
/*     */   {
/* 445 */     throw new NotImplementedException("getInputEncoding");
/*     */   }
/*     */ 
/*     */   public boolean getStrictErrorChecking()
/*     */   {
/* 450 */     throw new NotImplementedException("getStrictErrorChecking");
/*     */   }
/*     */ 
/*     */   public String getXmlEncoding()
/*     */   {
/* 455 */     throw new NotImplementedException("getXmlEncoding");
/*     */   }
/*     */ 
/*     */   public boolean getXmlStandalone()
/*     */   {
/* 460 */     throw new NotImplementedException("getXmlStandalone");
/*     */   }
/*     */ 
/*     */   public String getXmlVersion()
/*     */   {
/* 465 */     throw new NotImplementedException("getXmlVersion");
/*     */   }
/*     */ 
/*     */   public void normalizeDocument()
/*     */   {
/* 470 */     throw new NotImplementedException("normalizeDocument");
/*     */   }
/*     */ 
/*     */   public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException
/*     */   {
/* 475 */     throw new NotImplementedException("renameNode");
/*     */   }
/*     */ 
/*     */   public void setDocumentURI(String documentURI)
/*     */   {
/* 480 */     throw new NotImplementedException("setDocumentURI");
/*     */   }
/*     */ 
/*     */   public void setStrictErrorChecking(boolean strictErrorChecking)
/*     */   {
/* 485 */     throw new NotImplementedException("setStrictErrorChecking");
/*     */   }
/*     */ 
/*     */   public void setXmlStandalone(boolean xmlStandalone) throws DOMException
/*     */   {
/* 490 */     throw new NotImplementedException("setXmlStandalone");
/*     */   }
/*     */ 
/*     */   public void setXmlVersion(String xmlVersion) throws DOMException
/*     */   {
/* 495 */     throw new NotImplementedException("setXmlVersion");
/*     */   }
/*     */ 
/*     */   public short compareDocumentPosition(Node other) throws DOMException
/*     */   {
/* 500 */     throw new NotImplementedException("compareDocumentPosition");
/*     */   }
/*     */ 
/*     */   public String getBaseURI()
/*     */   {
/* 505 */     throw new NotImplementedException("getBaseURI");
/*     */   }
/*     */ 
/*     */   public Object getFeature(String feature, String version)
/*     */   {
/* 510 */     throw new NotImplementedException("getFeature");
/*     */   }
/*     */ 
/*     */   public String getTextContent() throws DOMException
/*     */   {
/* 515 */     throw new NotImplementedException("getTextContent");
/*     */   }
/*     */ 
/*     */   public Object getUserData(String key)
/*     */   {
/* 520 */     throw new NotImplementedException("getUserData");
/*     */   }
/*     */ 
/*     */   public boolean isDefaultNamespace(String namespaceURI)
/*     */   {
/* 525 */     throw new NotImplementedException("isDefaultNamespace");
/*     */   }
/*     */ 
/*     */   public boolean isEqualNode(Node arg)
/*     */   {
/* 530 */     throw new NotImplementedException("isEqualNode");
/*     */   }
/*     */ 
/*     */   public boolean isSameNode(Node other)
/*     */   {
/* 535 */     throw new NotImplementedException("isSameNode");
/*     */   }
/*     */ 
/*     */   public String lookupNamespaceURI(String prefix)
/*     */   {
/* 540 */     throw new NotImplementedException("lookupNamespaceURI");
/*     */   }
/*     */ 
/*     */   public String lookupPrefix(String namespaceURI)
/*     */   {
/* 545 */     throw new NotImplementedException("lookupPrefix");
/*     */   }
/*     */ 
/*     */   public void setTextContent(String textContent) throws DOMException
/*     */   {
/* 550 */     throw new NotImplementedException("setTextContent");
/*     */   }
/*     */ 
/*     */   public Object setUserData(String key, Object data, UserDataHandler handler)
/*     */   {
/* 555 */     throw new NotImplementedException("setUserData");
/*     */   }
/*     */ 
/*     */   public void detachNode()
/*     */   {
/* 561 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public SOAPElement getParentElement()
/*     */   {
/* 567 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public String getValue()
/*     */   {
/* 573 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public void recycleNode()
/*     */   {
/* 579 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public void setParentElement(SOAPElement parent)
/*     */     throws SOAPException
/*     */   {
/* 585 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public void setValue(String value)
/*     */   {
/* 591 */     throw new NotImplementedException();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.SOAPPartImpl
 * JD-Core Version:    0.6.0
 */