/*    */ package org.jboss.ws.core.soap;
/*    */ 
/*    */ public class Use
/*    */ {
/*    */   private String use;
/* 37 */   public static final Use LITERAL = new Use("literal");
/* 38 */   public static final Use ENCODED = new Use("encoded");
/*    */ 
/*    */   private Use(String use)
/*    */   {
/* 42 */     this.use = use;
/*    */   }
/*    */ 
/*    */   public static Use getDefaultUse()
/*    */   {
/* 47 */     return LITERAL;
/*    */   }
/*    */ 
/*    */   public static Use valueOf(String encodingStyle)
/*    */   {
/* 52 */     if (("".equals(encodingStyle)) || (LITERAL.use.equals(encodingStyle)))
/* 53 */       return LITERAL;
/* 54 */     if (("http://schemas.xmlsoap.org/soap/encoding/".equals(encodingStyle)) || (ENCODED.use.equals(encodingStyle))) {
/* 55 */       return ENCODED;
/*    */     }
/* 57 */     throw new IllegalArgumentException("Unsupported encoding style: " + encodingStyle);
/*    */   }
/*    */ 
/*    */   public String toURI()
/*    */   {
/* 62 */     String encURI = null;
/* 63 */     if (this == LITERAL)
/* 64 */       encURI = "";
/* 65 */     else if (this == ENCODED)
/* 66 */       encURI = "http://schemas.xmlsoap.org/soap/encoding/";
/* 67 */     return encURI;
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 72 */     return this.use;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.Use
 * JD-Core Version:    0.6.0
 */