/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.lang.reflect.Array;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.List;
/*     */ import javax.activation.DataHandler;
/*     */ import javax.activation.DataSource;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.transform.Source;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.Constants;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.binding.AbstractDeserializerFactory;
/*     */ import org.jboss.ws.core.binding.BindingException;
/*     */ import org.jboss.ws.core.binding.DeserializerSupport;
/*     */ import org.jboss.ws.core.binding.SerializationContext;
/*     */ import org.jboss.ws.core.binding.TypeMappingImpl;
/*     */ import org.jboss.ws.core.soap.attachment.SwapableMemoryDataSource;
/*     */ import org.jboss.ws.core.utils.MimeUtils;
/*     */ import org.jboss.ws.extensions.xop.XOPContext;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ import org.w3c.dom.Comment;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ class XMLContent extends SOAPContent
/*     */ {
/*  72 */   private static final Logger log = Logger.getLogger(XMLContent.class);
/*     */   private XMLFragment xmlFragment;
/*     */ 
/*     */   protected XMLContent(SOAPContentElement container)
/*     */   {
/*  79 */     super(container);
/*     */   }
/*     */ 
/*     */   SOAPContent.State getState()
/*     */   {
/*  84 */     return SOAPContent.State.XML_VALID;
/*     */   }
/*     */ 
/*     */   SOAPContent transitionTo(SOAPContent.State nextState)
/*     */   {
/*     */     SOAPContent next;
/*  91 */     if (nextState == SOAPContent.State.XML_VALID)
/*     */     {
/*  93 */       next = this;
/*     */     }
/*     */     else
/*     */     {
/*     */       SOAPContent next;
/*  95 */       if (nextState == SOAPContent.State.OBJECT_VALID)
/*     */       {
/*  97 */         Object obj = unmarshallObjectContents();
/*  98 */         SOAPContent objectValid = new ObjectContent(this.container);
/*  99 */         objectValid.setObjectValue(obj);
/* 100 */         next = objectValid;
/*     */       }
/*     */       else
/*     */       {
/*     */         SOAPContent next;
/* 102 */         if (nextState == SOAPContent.State.DOM_VALID)
/*     */         {
/*     */           try
/*     */           {
/* 106 */             expandContainerChildren();
/*     */           }
/*     */           catch (SOAPException ex)
/*     */           {
/* 110 */             throw new WSException("Cannot expand container children", ex);
/*     */           }
/* 112 */           next = new DOMContent(this.container);
/*     */         }
/*     */         else
/*     */         {
/* 116 */           throw new IllegalArgumentException("Illegal state requested: " + nextState);
/*     */         }
/*     */       }
/*     */     }
/*     */     SOAPContent next;
/* 119 */     return next;
/*     */   }
/*     */ 
/*     */   public Source getPayload()
/*     */   {
/* 124 */     return this.xmlFragment.getSource();
/*     */   }
/*     */ 
/*     */   public void setPayload(Source source)
/*     */   {
/* 129 */     this.xmlFragment = new XMLFragment(source);
/*     */   }
/*     */ 
/*     */   public XMLFragment getXMLFragment()
/*     */   {
/* 134 */     return this.xmlFragment;
/*     */   }
/*     */ 
/*     */   public void setXMLFragment(XMLFragment xmlFragment)
/*     */   {
/* 139 */     this.xmlFragment = xmlFragment;
/*     */   }
/*     */ 
/*     */   public Object getObjectValue()
/*     */   {
/* 144 */     throw new IllegalStateException("Object value not available");
/*     */   }
/*     */ 
/*     */   public void setObjectValue(Object objValue)
/*     */   {
/* 149 */     throw new IllegalStateException("Object value not available");
/*     */   }
/*     */ 
/*     */   private Object unmarshallObjectContents()
/*     */   {
/* 156 */     QName xmlType = this.container.getXmlType();
/* 157 */     Class javaType = this.container.getJavaType();
/*     */ 
/* 159 */     log.debug("getObjectValue [xmlType=" + xmlType + ",javaType=" + javaType + "]");
/*     */ 
/* 161 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 162 */     if (msgContext == null) {
/* 163 */       throw new WSException("MessageContext not available"); } SerializationContext serContext = msgContext.getSerializationContext();
/* 166 */     ParameterMetaData pmd = this.container.getParamMetaData();
/* 167 */     OperationMetaData opMetaData = pmd.getOperationMetaData();
/* 168 */     serContext.setProperty(ParameterMetaData.class.getName(), pmd);
/* 169 */     serContext.setJavaType(javaType);
/* 170 */     List registeredTypes = opMetaData.getEndpointMetaData().getRegisteredTypes();
/* 171 */     serContext.setProperty("org.jboss.ws.jaxb.context.types", registeredTypes.toArray(new Class[0]));
/*     */     Object obj;
/*     */     try { TypeMappingImpl typeMapping = serContext.getTypeMapping();
/* 177 */       AbstractDeserializerFactory deserializerFactory = getDeserializerFactory(typeMapping, javaType, xmlType);
/* 178 */       DeserializerSupport des = deserializerFactory.getDeserializer();
/*     */ 
/* 180 */       obj = des.deserialize(this.container, serContext);
/* 181 */       if (obj != null)
/*     */       {
/* 183 */         Class objType = obj.getClass();
/* 184 */         boolean isAssignable = JavaUtils.isAssignableFrom(javaType, objType);
/* 185 */         if ((!isAssignable) && (javaType.isArray()))
/*     */         {
/*     */           try
/*     */           {
/* 189 */             Method toArrayMethod = objType.getMethod("toArray", new Class[0]);
/* 190 */             Class returnType = toArrayMethod.getReturnType();
/* 191 */             if (JavaUtils.isAssignableFrom(javaType, returnType))
/*     */             {
/* 193 */               Method getValueMethod = objType.getMethod("getValue", new Class[0]);
/* 194 */               Object value = getValueMethod.invoke(obj, new Object[0]);
/* 195 */               if (value != null)
/*     */               {
/* 198 */                 obj = toArrayMethod.invoke(obj, new Object[0]);
/*     */               }
/*     */               else
/*     */               {
/* 204 */                 Class componentType = javaType.getComponentType();
/* 205 */                 obj = Array.newInstance(componentType, 0);
/*     */               }
/* 207 */               isAssignable = true;
/*     */             }
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 216 */         if (!isAssignable)
/*     */         {
/*     */           try
/*     */           {
/* 221 */             String contentType = MimeUtils.resolveMimeType(javaType);
/* 222 */             log.debug("Adopt DataHandler to " + javaType + ", contentType " + contentType);
/*     */ 
/* 224 */             DataSource ds = new SwapableMemoryDataSource(((DataHandler)obj).getInputStream(), contentType);
/* 225 */             DataHandler dh = new DataHandler(ds);
/* 226 */             obj = dh.getContent();
/*     */ 
/* 229 */             if ((obj instanceof InputStream))
/*     */             {
/* 231 */               ByteArrayOutputStream bout = new ByteArrayOutputStream();
/* 232 */               dh.writeTo(bout);
/* 233 */               obj = bout.toByteArray();
/*     */             }
/*     */           }
/*     */           catch (IOException e)
/*     */           {
/* 238 */             throw new WSException("Failed to adopt XOP content type", e);
/*     */           }
/*     */ 
/* 241 */           if (!JavaUtils.isAssignableFrom(javaType, obj.getClass()))
/*     */           {
/* 243 */             throw new WSException("Java type '" + javaType + "' is not assignable from: " + objType.getName());
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (BindingException e)
/*     */     {
/* 250 */       throw new WSException(e);
/*     */     }
/*     */ 
/* 253 */     log.debug("objectValue: " + (obj != null ? obj.getClass().getName() : null));
/*     */ 
/* 255 */     return obj;
/*     */   }
/*     */ 
/*     */   private static AbstractDeserializerFactory getDeserializerFactory(TypeMappingImpl typeMapping, Class javaType, QName xmlType)
/*     */   {
/* 261 */     AbstractDeserializerFactory deserializerFactory = (AbstractDeserializerFactory)typeMapping.getDeserializer(javaType, xmlType);
/*     */ 
/* 264 */     if ((deserializerFactory == null) && (javaType.isArray()))
/*     */     {
/* 266 */       Class arrayWrapperType = typeMapping.getJavaType(xmlType);
/* 267 */       if (arrayWrapperType != null)
/*     */       {
/*     */         try
/*     */         {
/* 271 */           Method toArrayMethod = arrayWrapperType.getMethod("toArray", new Class[0]);
/* 272 */           Class returnType = toArrayMethod.getReturnType();
/* 273 */           if (JavaUtils.isAssignableFrom(javaType, returnType))
/*     */           {
/* 275 */             deserializerFactory = (AbstractDeserializerFactory)typeMapping.getDeserializer(arrayWrapperType, xmlType);
/*     */           }
/*     */         }
/*     */         catch (NoSuchMethodException e)
/*     */         {
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 285 */     if (deserializerFactory == null) {
/* 286 */       throw new WSException("Cannot obtain deserializer factory for: [xmlType=" + xmlType + ",javaType=" + javaType + "]");
/*     */     }
/* 288 */     return deserializerFactory;
/*     */   }
/*     */ 
/*     */   private void expandContainerChildren()
/*     */     throws SOAPException
/*     */   {
/* 298 */     Element domElement = this.xmlFragment.toElement();
/* 299 */     if (domElement == this.container) {
/* 300 */       return;
/*     */     }
/*     */ 
/* 303 */     QName qname = this.container.getElementQName();
/* 304 */     QName contentRootName = DOMUtils.getElementQName(domElement);
/* 305 */     boolean artificalElement = (SOAPContentElement.GENERIC_PARAM_NAME.equals(qname)) || (SOAPContentElement.GENERIC_RETURN_NAME.equals(qname));
/*     */ 
/* 307 */     if ((!artificalElement) && (!contentRootName.equals(qname))) {
/* 308 */       throw new WSException("Content root name does not match element name: " + contentRootName + " != " + qname);
/*     */     }
/*     */ 
/* 311 */     this.container.removeContents();
/*     */ 
/* 315 */     if (artificalElement)
/*     */     {
/* 317 */       this.container.setElementQNameInternal(contentRootName);
/*     */     }
/*     */ 
/* 320 */     Document ownerDoc = this.container.getOwnerDocument();
/* 321 */     DOMUtils.copyAttributes(this.container, domElement);
/*     */ 
/* 323 */     SOAPFactoryImpl soapFactory = new SOAPFactoryImpl();
/*     */ 
/* 325 */     NodeList nlist = domElement.getChildNodes();
/* 326 */     for (int i = 0; i < nlist.getLength(); i++)
/*     */     {
/* 328 */       Node child = nlist.item(i);
/* 329 */       short childType = child.getNodeType();
/* 330 */       if (childType == 1)
/*     */       {
/* 332 */         SOAPElement soapElement = soapFactory.createElement((Element)child);
/* 333 */         this.container.addChildElement(soapElement);
/* 334 */         if ((Constants.NAME_XOP_INCLUDE.equals(qname)) || (this.container.isXOPParameter()))
/* 335 */           XOPContext.inlineXOPData(soapElement);
/*     */       }
/* 337 */       else if (childType == 3)
/*     */       {
/* 339 */         String nodeValue = child.getNodeValue();
/* 340 */         this.container.addTextNode(nodeValue);
/*     */       }
/* 342 */       else if (childType == 8)
/*     */       {
/* 344 */         String nodeValue = child.getNodeValue();
/* 345 */         Comment comment = ownerDoc.createComment(nodeValue);
/* 346 */         this.container.appendChild(comment);
/*     */       }
/* 348 */       else if (childType == 4)
/*     */       {
/* 350 */         String nodeValue = child.getNodeValue();
/* 351 */         this.container.addTextNode(nodeValue);
/*     */       }
/*     */       else
/*     */       {
/* 355 */         log.trace("Ignore child type: " + childType);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.XMLContent
 * JD-Core Version:    0.6.0
 */