/*    */ package org.jboss.ws.core.soap.attachment;
/*    */ 
/*    */ import com.sun.mail.handlers.multipart_mixed;
/*    */ import com.sun.mail.handlers.text_html;
/*    */ import com.sun.mail.handlers.text_plain;
/*    */ import java.awt.datatransfer.DataFlavor;
/*    */ import java.util.HashSet;
/*    */ import java.util.Iterator;
/*    */ import javax.activation.CommandMap;
/*    */ import javax.activation.DataContentHandler;
/*    */ import javax.activation.MailcapCommandMap;
/*    */ 
/*    */ public class ContentHandlerRegistry
/*    */ {
/*    */   private static final String JAF_CONTENT_HANDLER = "x-java-content-handler";
/* 46 */   private static HashSet handlerRegistry = new HashSet();
/*    */ 
/*    */   private static void addRegistryEntry(Class contentHandler)
/*    */   {
/* 60 */     handlerRegistry.add(contentHandler);
/*    */   }
/*    */ 
/*    */   private static void registerContentHandler(Class contentHandler)
/*    */   {
/*    */     MailcapCommandMap mailcap;
/*    */     DataContentHandler handler;
/*    */     try {
/* 70 */       mailcap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
/* 71 */       handler = (DataContentHandler)contentHandler.newInstance();
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 75 */       throw new RuntimeException("Can not register content handler:" + e.getMessage());
/*    */     }
/*    */ 
/* 78 */     DataFlavor[] flavors = handler.getTransferDataFlavors();
/* 79 */     if (flavors == null) {
/* 80 */       return;
/*    */     }
/* 82 */     for (int i = 0; i < flavors.length; i++)
/*    */     {
/* 84 */       DataFlavor flavor = flavors[i];
/* 85 */       String entry = flavor.getMimeType() + ";;" + "x-java-content-handler" + "=" + contentHandler.getName();
/* 86 */       mailcap.addMailcap(entry);
/*    */     }
/*    */   }
/*    */ 
/*    */   public static void register()
/*    */   {
/* 95 */     Iterator i = handlerRegistry.iterator();
/* 96 */     while (i.hasNext())
/* 97 */       registerContentHandler((Class)i.next());
/*    */   }
/*    */ 
/*    */   static
/*    */   {
/* 50 */     addRegistryEntry(XmlDataContentHandler.class);
/* 51 */     addRegistryEntry(ImageDataContentHandler.class);
/* 52 */     addRegistryEntry(ByteArrayContentHandler.class);
/* 53 */     addRegistryEntry(text_plain.class);
/* 54 */     addRegistryEntry(text_html.class);
/* 55 */     addRegistryEntry(multipart_mixed.class);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.attachment.ContentHandlerRegistry
 * JD-Core Version:    0.6.0
 */