/*     */ package org.jboss.ws.core.utils;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.xml.JBossEntityResolver;
/*     */ import org.xml.sax.InputSource;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public class JBossWSEntityResolver extends JBossEntityResolver
/*     */ {
/*  45 */   private static final Logger log = Logger.getLogger(JBossWSEntityResolver.class);
/*     */ 
/*     */   public JBossWSEntityResolver()
/*     */   {
/*  49 */     registerEntity("urn:jboss:jaxrpc-config:2.0", "schema/jaxrpc-config_2_0.xsd");
/*  50 */     registerEntity("urn:jboss:jaxws-config:2.0", "schema/jaxws-config_2_0.xsd");
/*  51 */     registerEntity("http://java.sun.com/xml/ns/javaee", "schema/javaee_web_services_1_2.xsd");
/*  52 */     registerEntity("http://www.w3.org/2005/08/addressing", "schema/ws-addr.xsd");
/*  53 */     registerEntity("http://schemas.xmlsoap.org/ws/2004/08/eventing", "eventing.xsd");
/*  54 */     registerEntity("http://www.w3.org/2002/06/soap-encoding", "soap-encoding_200206.xsd");
/*  55 */     registerEntity("http://schemas.xmlsoap.org/soap/encoding/", "soap-encoding_1_1.xsd");
/*  56 */     registerEntity("http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", "j2ee_web_services_client_1_1.xsd");
/*  57 */     registerEntity("http://www.ibm.com/webservices/xsd/j2ee_web_services_1_1.xsd", "j2ee_web_services_1_1.xsd");
/*  58 */     registerEntity("http://www.ibm.com/webservices/xsd/j2ee_jaxrpc_mapping_1_1.xsd", "j2ee_jaxrpc_mapping_1_1.xsd");
/*  59 */     registerEntity("http://ws-i.org/profiles/basic/1.1/swaref.xsd", "schema/swaref.xsd");
/*     */   }
/*     */ 
/*     */   public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException
/*     */   {
/*  64 */     if (log.isDebugEnabled()) log.debug("resolveEntity: [pub=" + publicId + ",sysid=" + systemId + "]");
/*  65 */     InputSource inputSource = super.resolveEntity(publicId, systemId);
/*     */ 
/*  67 */     if (inputSource == null) {
/*  68 */       inputSource = resolveSystemIDAsURL(systemId, log.isTraceEnabled());
/*     */     }
/*  70 */     if (inputSource == null) {
/*  71 */       log.debug("Cannot resolve entity: [pub=" + publicId + ",sysid=" + systemId + "]");
/*     */     }
/*  73 */     return inputSource;
/*     */   }
/*     */ 
/*     */   protected InputSource resolveSystemIDAsURL(String id, boolean trace)
/*     */   {
/*  80 */     if (id == null) {
/*  81 */       return null;
/*     */     }
/*  83 */     if (trace) {
/*  84 */       log.trace("resolveIDAsResourceURL, id=" + id);
/*     */     }
/*  86 */     InputSource inputSource = null;
/*     */     try
/*     */     {
/*  91 */       if (trace) {
/*  92 */         log.trace("Trying to resolve id as a URL");
/*     */       }
/*  94 */       URL url = new URL(id);
/*  95 */       if (!url.getProtocol().equalsIgnoreCase("file")) {
/*  96 */         log.warn("Trying to resolve id as a non-file URL: " + id);
/*     */       }
/*  98 */       InputStream ins = new ResourceURL(url).openStream();
/*  99 */       if (ins != null)
/*     */       {
/* 101 */         inputSource = new InputSource(ins);
/* 102 */         inputSource.setSystemId(id);
/*     */       }
/*     */       else
/*     */       {
/* 106 */         log.warn("Cannot load id as URL: " + id);
/*     */       }
/*     */ 
/* 109 */       if (trace)
/* 110 */         log.trace("Resolved id as a URL");
/*     */     }
/*     */     catch (MalformedURLException ignored)
/*     */     {
/* 114 */       if (trace)
/* 115 */         log.trace("id is not a url: " + id, ignored);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 119 */       if (trace)
/* 120 */         log.trace("Failed to obtain URL.InputStream from id: " + id, e);
/*     */     }
/* 122 */     return inputSource;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.utils.JBossWSEntityResolver
 * JD-Core Version:    0.6.0
 */