/*     */ package org.jboss.ws.core.utils;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.net.JarURLConnection;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.net.URLDecoder;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import java.util.StringTokenizer;
/*     */ import java.util.jar.JarEntry;
/*     */ import java.util.jar.JarFile;
/*     */ import java.util.jar.JarInputStream;
/*     */ 
/*     */ public class JarUrlConnection extends JarURLConnection
/*     */ {
/*     */   private URL baseResource;
/*     */   private String[] segments;
/*     */   private InputStream in;
/*     */ 
/*     */   public JarUrlConnection(URL url)
/*     */     throws IOException
/*     */   {
/*  97 */     super(url = normaliseURL(url));
/*     */ 
/*  99 */     String baseText = url.getPath();
/*     */ 
/* 101 */     int bangLoc = baseText.indexOf("!");
/*     */ 
/* 103 */     String baseResourceText = baseText.substring(0, bangLoc);
/*     */ 
/* 105 */     String extraText = "";
/*     */ 
/* 107 */     if ((bangLoc <= baseText.length() - 2) && (baseText.charAt(bangLoc + 1) == '/'))
/*     */     {
/* 109 */       if (bangLoc + 2 == baseText.length())
/*     */       {
/* 111 */         extraText = "";
/*     */       }
/*     */       else
/*     */       {
/* 115 */         extraText = baseText.substring(bangLoc + 1);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 120 */       throw new MalformedURLException("No !/ in url: " + url.toExternalForm());
/*     */     }
/*     */ 
/* 123 */     List segments = new ArrayList();
/*     */ 
/* 125 */     StringTokenizer tokens = new StringTokenizer(extraText, "!");
/*     */ 
/* 127 */     while (tokens.hasMoreTokens())
/*     */     {
/* 129 */       segments.add(tokens.nextToken());
/*     */     }
/*     */ 
/* 132 */     this.segments = ((String[])(String[])segments.toArray(new String[segments.size()]));
/*     */ 
/* 134 */     this.baseResource = new URL(baseResourceText);
/*     */   }
/*     */ 
/*     */   protected static URL normaliseURL(URL url) throws MalformedURLException
/*     */   {
/* 139 */     String text = normalizeUrlPath(url.toString());
/*     */ 
/* 141 */     if (!text.startsWith("jar:"))
/*     */     {
/* 143 */       text = "jar:" + text;
/*     */     }
/*     */ 
/* 146 */     if (text.indexOf('!') < 0)
/*     */     {
/* 148 */       text = text + "!/";
/*     */     }
/*     */ 
/* 151 */     return new URL(text);
/*     */   }
/*     */ 
/*     */   protected String[] getSegments()
/*     */   {
/* 164 */     return this.segments;
/*     */   }
/*     */ 
/*     */   protected URL getBaseResource()
/*     */   {
/* 173 */     return this.baseResource;
/*     */   }
/*     */ 
/*     */   public void connect()
/*     */     throws IOException
/*     */   {
/* 180 */     if (this.segments.length == 0)
/*     */     {
/* 182 */       setupBaseResourceInputStream();
/*     */     }
/*     */     else
/*     */     {
/* 186 */       setupPathedInputStream();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void setupBaseResourceInputStream()
/*     */     throws IOException
/*     */   {
/* 196 */     this.in = getBaseResource().openStream();
/*     */   }
/*     */ 
/*     */   protected void setupPathedInputStream()
/*     */     throws IOException
/*     */   {
/* 205 */     InputStream curIn = getBaseResource().openStream();
/*     */ 
/* 207 */     for (int i = 0; i < this.segments.length; i++)
/*     */     {
/* 209 */       curIn = getSegmentInputStream(curIn, this.segments[i]);
/*     */     }
/*     */ 
/* 212 */     this.in = curIn;
/*     */   }
/*     */ 
/*     */   protected InputStream getSegmentInputStream(InputStream baseIn, String segment)
/*     */     throws IOException
/*     */   {
/* 227 */     JarInputStream jarIn = new JarInputStream(baseIn);
/* 228 */     JarEntry entry = null;
/*     */ 
/* 230 */     while (jarIn.available() != 0)
/*     */     {
/* 232 */       entry = jarIn.getNextJarEntry();
/*     */ 
/* 234 */       if (entry == null)
/*     */       {
/*     */         break;
/*     */       }
/*     */ 
/* 239 */       if (("/" + entry.getName()).equals(segment))
/*     */       {
/* 241 */         return jarIn;
/*     */       }
/*     */     }
/*     */ 
/* 245 */     throw new IOException("unable to locate segment: " + segment);
/*     */   }
/*     */ 
/*     */   public InputStream getInputStream()
/*     */     throws IOException
/*     */   {
/* 252 */     if (this.in == null)
/*     */     {
/* 254 */       connect();
/*     */     }
/* 256 */     return this.in;
/*     */   }
/*     */ 
/*     */   public JarFile getJarFile()
/*     */     throws IOException
/*     */   {
/* 266 */     String url = this.baseResource.toExternalForm();
/*     */ 
/* 268 */     if (url.startsWith("file:/"))
/*     */     {
/* 270 */       url = url.substring(6);
/*     */     }
/*     */ 
/* 273 */     return new JarFile(URLDecoder.decode(url, "UTF-8"));
/*     */   }
/*     */ 
/*     */   private static String normalizeUrlPath(String name)
/*     */   {
/* 278 */     if (name.startsWith("/"))
/*     */     {
/* 280 */       name = name.substring(1);
/*     */ 
/* 282 */       System.out.println("1 name = " + name);
/*     */     }
/*     */ 
/* 289 */     int i = name.indexOf("/..");
/*     */ 
/* 293 */     if (i > 0)
/*     */     {
/* 295 */       int j = name.lastIndexOf("/", i - 1);
/*     */ 
/* 297 */       name = name.substring(0, j) + name.substring(i + 3);
/*     */ 
/* 299 */       System.out.println("2 name = " + name);
/*     */     }
/*     */ 
/* 302 */     return name;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.utils.JarUrlConnection
 * JD-Core Version:    0.6.0
 */