/*     */ package org.jboss.ws.extensions.addressing.jaxrpc;
/*     */ 
/*     */ import java.net.URISyntaxException;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.handler.GenericHandler;
/*     */ import javax.xml.rpc.handler.HandlerInfo;
/*     */ import javax.xml.rpc.handler.MessageContext;
/*     */ import javax.xml.rpc.handler.soap.SOAPMessageContext;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.ws.addressing.AddressingBuilder;
/*     */ import javax.xml.ws.addressing.soap.SOAPAddressingBuilder;
/*     */ import javax.xml.ws.addressing.soap.SOAPAddressingProperties;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.jaxrpc.handler.SOAPMessageContextJAXRPC;
/*     */ import org.jboss.ws.extensions.addressing.AddressingConstantsImpl;
/*     */ import org.jboss.ws.extensions.addressing.metadata.AddressingOpMetaExt;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ 
/*     */ public class WSAddressingServerHandler extends GenericHandler
/*     */ {
/*  55 */   private static Logger log = Logger.getLogger(WSAddressingServerHandler.class);
/*     */   private static AddressingBuilder ADDR_BUILDER;
/*     */   private static AddressingConstantsImpl ADDR_CONSTANTS;
/*  59 */   private static QName[] HEADERS = new QName[2];
/*     */ 
/*     */   public QName[] getHeaders()
/*     */   {
/*  72 */     return HEADERS;
/*     */   }
/*     */ 
/*     */   public void init(HandlerInfo handlerInfo)
/*     */   {
/*  77 */     super.init(handlerInfo);
/*     */   }
/*     */ 
/*     */   public boolean handleRequest(MessageContext msgContext)
/*     */   {
/*  86 */     if (log.isDebugEnabled()) log.debug("handleRequest");
/*     */ 
/*  88 */     SOAPAddressingProperties addrProps = (SOAPAddressingProperties)ADDR_BUILDER.newAddressingProperties();
/*  89 */     SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
/*  90 */     addrProps.readHeaders(soapMessage);
/*  91 */     msgContext.setProperty("javax.xml.ws.addressing.context.inbound", addrProps);
/*  92 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean handleResponse(MessageContext msgContext)
/*     */   {
/* 101 */     if (log.isDebugEnabled()) log.debug("handleResponse");
/* 102 */     handleResponseOrFault(msgContext, false);
/* 103 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean handleFault(MessageContext msgContext)
/*     */   {
/* 112 */     if (log.isDebugEnabled()) log.debug("handleFault");
/* 113 */     handleResponseOrFault(msgContext, true);
/* 114 */     return true;
/*     */   }
/*     */ 
/*     */   private void handleResponseOrFault(MessageContext msgContext, boolean isFault)
/*     */   {
/* 119 */     SOAPAddressingBuilder builder = (SOAPAddressingBuilder)SOAPAddressingBuilder.getAddressingBuilder();
/* 120 */     SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
/*     */ 
/* 122 */     SOAPAddressingProperties inProps = (SOAPAddressingProperties)msgContext.getProperty("javax.xml.ws.addressing.context.inbound");
/* 123 */     SOAPAddressingProperties outProps = (SOAPAddressingProperties)msgContext.getProperty("javax.xml.ws.addressing.context.outbound");
/*     */ 
/* 125 */     if (outProps == null)
/*     */     {
/* 128 */       outProps = (SOAPAddressingProperties)builder.newAddressingProperties();
/* 129 */       msgContext.setProperty("javax.xml.ws.addressing.context.outbound", outProps);
/*     */     }
/*     */ 
/* 132 */     outProps.initializeAsReply(inProps, isFault);
/*     */     try
/*     */     {
/* 138 */       OperationMetaData opMetaData = ((SOAPMessageContextJAXRPC)msgContext).getOperationMetaData();
/*     */ 
/* 140 */       if ((!isFault) && (!opMetaData.isOneWay()))
/*     */       {
/* 143 */         AddressingOpMetaExt addrExt = (AddressingOpMetaExt)opMetaData.getExtension(ADDR_CONSTANTS.getNamespaceURI());
/* 144 */         if (addrExt != null)
/*     */         {
/* 146 */           outProps.setAction(ADDR_BUILDER.newURI(addrExt.getOutboundAction()));
/*     */         }
/*     */         else
/*     */         {
/* 150 */           log.warn("Unable to resolve replyAction for " + opMetaData.getQName());
/*     */         }
/*     */ 
/*     */       }
/* 154 */       else if (isFault)
/*     */       {
/* 156 */         outProps.setAction(ADDR_BUILDER.newURI(ADDR_CONSTANTS.getDefaultFaultAction()));
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (URISyntaxException e)
/*     */     {
/* 162 */       log.error("Error setting response action", e);
/*     */     }
/*     */ 
/* 165 */     outProps.writeHeaders(soapMessage);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  63 */     ADDR_CONSTANTS = new AddressingConstantsImpl();
/*  64 */     ADDR_BUILDER = AddressingBuilder.getAddressingBuilder();
/*     */ 
/*  66 */     HEADERS[0] = ADDR_CONSTANTS.getActionQName();
/*  67 */     HEADERS[1] = ADDR_CONSTANTS.getToQName();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.addressing.jaxrpc.WSAddressingServerHandler
 * JD-Core Version:    0.6.0
 */