/*     */ package org.jboss.ws.extensions.eventing;
/*     */ 
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import javax.xml.ws.addressing.AddressingBuilder;
/*     */ import javax.xml.ws.addressing.AddressingConstants;
/*     */ import org.jboss.ws.WSException;
/*     */ 
/*     */ public class EventingConstants
/*     */ {
/*  40 */   private static AddressingBuilder WSA_BUILDER = AddressingBuilder.getAddressingBuilder();
/*  41 */   private static AddressingConstants WSA_CONSTANTS = WSA_BUILDER.newAddressingConstants();
/*     */   public static final String NS_EVENTING = "http://schemas.xmlsoap.org/ws/2004/08/eventing";
/*     */   public static final String PREFIX_EVENTING = "wse";
/*  47 */   public static final String NS_ADDRESSING = WSA_CONSTANTS.getNamespaceURI();
/*     */   public static final String SUBSCRIBE_ACTION = "http://schemas.xmlsoap.org/ws/2004/08/eventing/Subscribe";
/*     */   public static final String SUBSCRIBE_RESPONSE_ACTION = "http://schemas.xmlsoap.org/ws/2004/08/eventing/SubscribeResponse";
/*     */   public static final String UNSUBSCRIBE_ACTION = "http://schemas.xmlsoap.org/ws/2004/08/eventing/Unsubscribe";
/*     */   public static final String UNSUBSCRIBE_RESPONSE_ACTION = "http://schemas.xmlsoap.org/ws/2004/08/eventing/UnsubscribeResponse";
/*     */   public static final String GET_STATUS_ACTION = "http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatus";
/*     */   public static final String GET_STATUS_RESPONSE_ACTION = "http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatusResponse";
/*     */   public static final String RENEW_ACTION = "http://schemas.xmlsoap.org/ws/2004/08/eventing/Renew";
/*     */   public static final String RENEW_RESPONSE_ACTION = "http://schemas.xmlsoap.org/ws/2004/08/eventing/RenewResponse";
/*     */   public static final String SUBSCRIPTION_END_ACTION = "http://schemas.xmlsoap.org/ws/2004/08/eventing/SubscriptionEnd";
/*     */   public static final String WSA_FAULT_ACTION = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault";
/*  62 */   public static final String WSA_ANONYMOUS_URI = WSA_CONSTANTS.getAnonymousURI();
/*     */   public static final String DELIVERY_FAILURE = "http://schemas.xmlsoap.org/ws/2004/08/eventing/DeliveryFailure";
/*     */   public static final String SOURCE_SHUTTING_DOWN = "http://schemas.xmlsoap.org/ws/2004/08/eventing/SourceShuttingDown";
/*     */   public static final String SOURCE_CANCELING = "http://schemas.xmlsoap.org/ws/2004/08/eventing/SourceCanceling";
/*     */   public static final String CODE_UNABLE_TO_PROCESS = "EventSourceUnableToProcess";
/*     */   public static final String CODE_FILTER_NOT_SUPPORTED = "FilteringNotSupported";
/*     */   public static final String CODE_REQUESTED_FILTER_UNAVAILABLE = "FilteringRequestedUnavailable";
/*     */   public static final String CODE_INVALID_EXPIRATION_TIME = "InvalidExpirationTime";
/*     */   public static final String CODE_UNABLE_TO_RENEW = "UnableToRenew";
/*     */   public static final String CODE_INVALID_MESSAGE = "InvalidMessage";
/*     */   public static final String DISPATCHER_JNDI_NAME = "EventDispatcher";
/*     */   public static final long MAX_LEASE_TIME = 600000L;
/*     */   public static final long DEFAULT_LEASE = 300000L;
/*  83 */   private static URI DELIVERY_PUSH_URI = null;
/*  84 */   private static URI DIALECT_XPATH_URI = null;
/*     */ 
/*  86 */   private static URI SUBSCRIBE_ACTION_URI = null;
/*     */ 
/*     */   public static final URI buildURI(String uri)
/*     */   {
/*     */     try
/*     */     {
/*  92 */       return new URI(uri);
/*     */     }
/*     */     catch (URISyntaxException e) {
/*     */     }
/*  96 */     throw new IllegalArgumentException(e.getMessage());
/*     */   }
/*     */ 
/*     */   public static final URI getDefaultFilterDialect()
/*     */   {
/*     */     try
/*     */     {
/* 104 */       return new URI("http://www.w3.org/TR/1999/REC-xpath-19991116");
/*     */     }
/*     */     catch (URISyntaxException e) {
/*     */     }
/* 108 */     throw new WSException(e.getMessage());
/*     */   }
/*     */ 
/*     */   public static final URI getDeliveryPush()
/*     */   {
/* 114 */     if (null == DELIVERY_PUSH_URI)
/*     */     {
/*     */       try
/*     */       {
/* 118 */         DELIVERY_PUSH_URI = new URI("http://schemas.xmlsoap.org/ws/2004/08/eventing/DeliveryModes/Push");
/*     */       }
/*     */       catch (URISyntaxException e)
/*     */       {
/*     */       }
/*     */     }
/*     */ 
/* 125 */     return DELIVERY_PUSH_URI;
/*     */   }
/*     */ 
/*     */   public static URI getDialectXPath()
/*     */   {
/* 130 */     if (null == DIALECT_XPATH_URI)
/*     */     {
/*     */       try
/*     */       {
/* 134 */         DIALECT_XPATH_URI = new URI("http://www.w3.org/TR/1999/REC-xpath-19991116");
/*     */       }
/*     */       catch (URISyntaxException e)
/*     */       {
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 142 */     return DIALECT_XPATH_URI;
/*     */   }
/*     */ 
/*     */   public static URI getSubscribeAction()
/*     */   {
/* 147 */     if (null == SUBSCRIBE_ACTION_URI)
/*     */     {
/*     */       try
/*     */       {
/* 151 */         SUBSCRIBE_ACTION_URI = new URI("http://schemas.xmlsoap.org/ws/2004/08/eventing/Subscribe");
/*     */       }
/*     */       catch (URISyntaxException e)
/*     */       {
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 159 */     return SUBSCRIBE_ACTION_URI;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.eventing.EventingConstants
 * JD-Core Version:    0.6.0
 */