/*     */ package org.jboss.ws.extensions.eventing.mgmt;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import java.util.Date;
/*     */ import java.util.List;
/*     */ import javax.xml.bind.JAXBElement;
/*     */ import javax.xml.soap.MessageFactory;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.transform.TransformerException;
/*     */ import org.apache.xpath.XPathAPI;
/*     */ import org.apache.xpath.objects.XObject;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.soap.SOAPConnectionImpl;
/*     */ import org.jboss.ws.extensions.eventing.EventingConstants;
/*     */ import org.jboss.ws.extensions.eventing.jaxws.AttributedURIType;
/*     */ import org.jboss.ws.extensions.eventing.jaxws.EndpointReferenceType;
/*     */ import org.jboss.ws.extensions.eventing.jaxws.ReferenceParametersType;
/*     */ import org.jboss.wsf.common.DOMWriter;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ class Subscription
/*     */ {
/*  56 */   private static final Logger log = Logger.getLogger(Subscription.class);
/*     */   private final EndpointReferenceType notifyTo;
/*     */   private final EndpointReferenceType endTo;
/*     */   private Date expires;
/*     */   private final Filter filter;
/*     */   private final EndpointReferenceType endpointReference;
/*     */   private final URI eventSourceNS;
/*  65 */   private SubscriptionManagerFactory factory = SubscriptionManagerFactory.getInstance();
/*     */ 
/*     */   public Subscription(URI eventSourceNS, EndpointReferenceType epr, EndpointReferenceType notifyTo, EndpointReferenceType endTo, Date expires, Filter filter)
/*     */   {
/*  69 */     this.eventSourceNS = eventSourceNS;
/*  70 */     this.notifyTo = notifyTo;
/*  71 */     this.endTo = endTo;
/*  72 */     this.expires = expires;
/*  73 */     this.filter = filter;
/*  74 */     this.endpointReference = epr;
/*     */   }
/*     */ 
/*     */   public void notify(Element event)
/*     */   {
/*  79 */     if (log.isDebugEnabled()) log.debug(getIdentifier() + " dispatching " + event);
/*     */ 
/*     */     try
/*     */     {
/*  83 */       String eventXML = DOMWriter.printNode(event, false);
/*  84 */       MessageFactory msgFactory = MessageFactory.newInstance();
/*     */ 
/*  87 */       StringBuilder sb = new StringBuilder();
/*  88 */       sb.append("<env:Envelope xmlns:env='http://schemas.xmlsoap.org/soap/envelope/' ");
/*  89 */       sb.append("xmlns:wse='").append("http://schemas.xmlsoap.org/ws/2004/08/eventing").append("' ");
/*  90 */       sb.append("xmlns:wsa='").append(EventingConstants.NS_ADDRESSING).append("'>");
/*  91 */       sb.append("<env:Header>");
/*  92 */       sb.append("<wsa:Action>").append(getNotificationAction()).append("</wsa:Action>");
/*     */ 
/*  94 */       sb.append("<wsa:To>").append(this.notifyTo.getAddress().toString()).append("</wsa:To>");
/*  95 */       sb.append("</env:Header>");
/*  96 */       sb.append("<env:Body>");
/*  97 */       sb.append(eventXML);
/*  98 */       sb.append("</env:Body>");
/*  99 */       sb.append("</env:Envelope>");
/*     */ 
/* 101 */       SOAPMessage reqMsg = msgFactory.createMessage(null, new ByteArrayInputStream(sb.toString().getBytes()));
/* 102 */       URL epURL = new URL(this.notifyTo.getAddress().getValue());
/* 103 */       new SOAPConnectionImpl().callOneWay(reqMsg, epURL);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 107 */       SubscriptionManagerMBean manager = this.factory.getSubscriptionManager();
/* 108 */       AttributedURIType address = this.endTo.getAddress();
/* 109 */       NotificationFailure failure = new NotificationFailure(address.getValue(), event, e);
/* 110 */       manager.addNotificationFailure(failure);
/* 111 */       log.error("Failed to send notification message", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean accepts(Element event)
/*     */   {
/* 118 */     boolean b = true;
/* 119 */     if (this.filter != null)
/*     */     {
/*     */       try
/*     */       {
/* 124 */         XObject o = XPathAPI.eval(event, this.filter.getExpression());
/* 125 */         b = o.bool();
/*     */       }
/*     */       catch (TransformerException e)
/*     */       {
/* 129 */         log.error("Failed to evalute xpath expression", e);
/*     */       }
/*     */     }
/*     */ 
/* 133 */     return b;
/*     */   }
/*     */ 
/*     */   public void end(String status)
/*     */   {
/* 138 */     if (null == this.endTo) {
/* 139 */       return;
/*     */     }
/* 141 */     if (log.isDebugEnabled()) log.debug("Ending subscription " + getIdentifier());
/*     */ 
/* 143 */     StringBuffer sb = new StringBuffer();
/* 144 */     sb.append("<env:Envelope xmlns:env='http://www.w3.org/2003/05/soap-envelope' ");
/* 145 */     sb.append("xmlns:wse='").append("http://schemas.xmlsoap.org/ws/2004/08/eventing").append("' ");
/* 146 */     sb.append("xmlns:wsa='").append(EventingConstants.NS_ADDRESSING).append("'>");
/* 147 */     sb.append("<env:Header>");
/* 148 */     sb.append("<wsa:Action>").append("http://schemas.xmlsoap.org/ws/2004/08/eventing/SubscriptionEnd").append("</wsa:Action>");
/* 149 */     sb.append("<wsa:To>").append(this.endTo.getAddress().toString()).append("</wsa:To>");
/* 150 */     sb.append("</env:Header>");
/* 151 */     sb.append("<env:Body>");
/*     */ 
/* 153 */     sb.append("<wse:SubscriptionEnd>");
/* 154 */     sb.append("<wse:SubscriptionManager>");
/* 155 */     sb.append("<wsa:Address>");
/* 156 */     sb.append(this.endpointReference.getAddress().toString());
/* 157 */     sb.append("</wsa:Address>");
/* 158 */     sb.append("<wsa:ReferenceParameters>");
/* 159 */     sb.append("<wse:Identifier>");
/* 160 */     sb.append(getIdentifier().toString());
/* 161 */     sb.append("</wse:Identifier>");
/* 162 */     sb.append("</wsa:ReferenceParameters>");
/* 163 */     sb.append("</wse:SubscriptionManager>");
/*     */ 
/* 165 */     sb.append("<wse:Status>").append(status).append("</wse:Status>");
/* 166 */     sb.append("<wse:Reason/>");
/* 167 */     sb.append("</wse:SubscriptionEnd>");
/*     */ 
/* 169 */     sb.append("</env:Body>");
/* 170 */     sb.append("</env:Envelope>");
/*     */     try
/*     */     {
/* 174 */       MessageFactory msgFactory = MessageFactory.newInstance();
/* 175 */       SOAPMessage reqMsg = msgFactory.createMessage(null, new ByteArrayInputStream(sb.toString().getBytes()));
/* 176 */       URL epURL = new URL(this.endTo.getAddress().getValue());
/* 177 */       new SOAPConnectionImpl().callOneWay(reqMsg, epURL);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 181 */       log.warn("Failed to send subscription end message to: " + this.endTo + "(" + e.getMessage() + ")");
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getNotificationAction()
/*     */   {
/* 188 */     return this.eventSourceNS.toString() + "/Notification";
/*     */   }
/*     */ 
/*     */   public boolean isExpired()
/*     */   {
/* 193 */     return System.currentTimeMillis() > this.expires.getTime();
/*     */   }
/*     */ 
/*     */   public EndpointReferenceType getNotifyTo()
/*     */   {
/* 198 */     return this.notifyTo;
/*     */   }
/*     */ 
/*     */   public EndpointReferenceType getEndTo()
/*     */   {
/* 203 */     return this.endTo;
/*     */   }
/*     */ 
/*     */   public Date getExpires()
/*     */   {
/* 208 */     return this.expires;
/*     */   }
/*     */ 
/*     */   public Filter getFilter()
/*     */   {
/* 213 */     return this.filter;
/*     */   }
/*     */ 
/*     */   public EndpointReferenceType getEndpointReferenceType()
/*     */   {
/* 218 */     return this.endpointReference;
/*     */   }
/*     */ 
/*     */   public URI getIdentifier()
/*     */   {
/*     */     try {
/* 224 */       JAXBElement jaxbElement = (JAXBElement)this.endpointReference.getReferenceParameters().getAny().get(0);
/* 225 */       return new URI((String)jaxbElement.getValue()); } catch (URISyntaxException e) {
/*     */     }
/* 227 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public void setExpires(Date expires)
/*     */   {
/* 233 */     this.expires = expires;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.eventing.mgmt.Subscription
 * JD-Core Version:    0.6.0
 */