/*     */ package org.jboss.ws.extensions.policy;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.wsf.common.DOMWriter;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class PolicyAlternative
/*     */ {
/*  59 */   private Collection<PolicyAssertion> assertions = new ArrayList();
/*     */ 
/*     */   static PolicyAlternative parse(Element elAll)
/*     */   {
/*  69 */     elAll = (Element)elAll.cloneNode(true);
/*     */ 
/*  71 */     PolicyAlternative all = new PolicyAlternative();
/*  72 */     Iterator it = DOMUtils.getChildElements(elAll);
/*  73 */     while (it.hasNext())
/*     */     {
/*  75 */       Element el = (Element)it.next();
/*  76 */       all.addPolicyAssertion(new PolicyAssertion(el));
/*     */     }
/*  78 */     return all;
/*     */   }
/*     */ 
/*     */   public void addPolicyAssertion(PolicyAssertion polAssertion)
/*     */   {
/*  83 */     this.assertions.add(polAssertion);
/*     */   }
/*     */ 
/*     */   public Collection<PolicyAssertion> getPolicyAssertions()
/*     */   {
/*  88 */     return new ArrayList(this.assertions);
/*     */   }
/*     */ 
/*     */   public Element toElement()
/*     */   {
/*  93 */     String xmlString = toXMLString(false);
/*     */     try
/*     */     {
/*  96 */       return DOMUtils.parse(xmlString);
/*     */     }
/*     */     catch (IOException ex) {
/*     */     }
/* 100 */     throw new WSException("Cannot parse: " + xmlString, ex);
/*     */   }
/*     */ 
/*     */   public String toXMLString(boolean pretty)
/*     */   {
/* 106 */     if (pretty)
/*     */     {
/* 108 */       Element elAll = toElement();
/* 109 */       return DOMWriter.printNode(elAll, true);
/*     */     }
/*     */ 
/* 112 */     StringBuilder xmlBuffer = new StringBuilder("<wsp:All>");
/* 113 */     for (PolicyAssertion assertion : this.assertions)
/*     */     {
/* 115 */       xmlBuffer.append(assertion.toXMLString(false));
/*     */     }
/* 117 */     xmlBuffer.append("</wsp:All>");
/* 118 */     return xmlBuffer.toString();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 123 */     return toXMLString(true);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.policy.PolicyAlternative
 * JD-Core Version:    0.6.0
 */