/*     */ package org.jboss.ws.extensions.policy;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.Iterator;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.xb.binding.NamespaceRegistry;
/*     */ import org.w3c.dom.Attr;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.NamedNodeMap;
/*     */ 
/*     */ public class PolicyFactory
/*     */ {
/*  46 */   private static PolicyFactory factory = new PolicyFactory();
/*     */ 
/*     */   public static PolicyFactory newInstance()
/*     */   {
/*  55 */     return factory;
/*     */   }
/*     */ 
/*     */   public Policy createPolicy(String strPolicy)
/*     */   {
/*     */     try
/*     */     {
/*  62 */       return createPolicy(DOMUtils.parse(strPolicy));
/*     */     }
/*     */     catch (IOException ex) {
/*     */     }
/*  66 */     throw new IllegalArgumentException("Cannot parse: " + strPolicy, ex);
/*     */   }
/*     */ 
/*     */   public Policy createPolicy(Element elPolicy)
/*     */   {
/*  73 */     elPolicy = (Element)elPolicy.cloneNode(true);
/*     */ 
/*  75 */     Policy policy = new Policy();
/*  76 */     policy.setTargetNamespace(DOMUtils.getAttributeValue(elPolicy, "TargetNamespace"));
/*  77 */     policy.setBaseURI(DOMUtils.getAttributeValue(elPolicy, "xml:base"));
/*  78 */     policy.setID(DOMUtils.getAttributeValue(elPolicy, new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id")));
/*     */ 
/*  81 */     NamedNodeMap attribs = elPolicy.getAttributes();
/*  82 */     for (int i = 0; i < attribs.getLength(); i++)
/*     */     {
/*  84 */       Attr attr = (Attr)attribs.item(i);
/*  85 */       String attrName = attr.getName();
/*  86 */       String attrValue = attr.getValue();
/*  87 */       if (!attrName.startsWith("xmlns:"))
/*     */         continue;
/*  89 */       String prefix = attrName.substring(6);
/*  90 */       policy.getNamespaceRegistry().registerURI(attrValue, prefix);
/*     */     }
/*     */ 
/*  95 */     QName oneQName = new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "ExactlyOne");
/*  96 */     Element elExactlyOne = DOMUtils.getFirstChildElement(elPolicy, oneQName);
/*  97 */     if (elExactlyOne == null) {
/*  98 */       throw new WSException("Cannot find child element: " + oneQName);
/*     */     }
/*     */ 
/* 101 */     QName allQName = new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "All");
/* 102 */     Element elAll = DOMUtils.getFirstChildElement(elExactlyOne, allQName);
/* 103 */     if (elAll == null) {
/* 104 */       throw new WSException("Cannot find child element: " + allQName);
/*     */     }
/* 106 */     Iterator it = DOMUtils.getChildElements(elExactlyOne, allQName);
/* 107 */     while (it.hasNext())
/*     */     {
/* 109 */       elAll = (Element)it.next();
/* 110 */       PolicyAlternative all = PolicyAlternative.parse(elAll);
/* 111 */       policy.addPolicyAlternative(all);
/*     */     }
/*     */ 
/* 114 */     return policy;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.policy.PolicyFactory
 * JD-Core Version:    0.6.0
 */