/*     */ package org.jboss.ws.extensions.security;
/*     */ 
/*     */ import java.security.NoSuchAlgorithmException;
/*     */ import java.security.cert.X509Certificate;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import javax.crypto.KeyGenerator;
/*     */ import javax.crypto.SecretKey;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.apache.xml.security.encryption.EncryptedData;
/*     */ import org.apache.xml.security.encryption.XMLCipher;
/*     */ import org.apache.xml.security.exceptions.XMLSecurityException;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.extensions.security.element.EncryptedKey;
/*     */ import org.jboss.ws.extensions.security.element.ReferenceList;
/*     */ import org.jboss.ws.extensions.security.element.SecurityHeader;
/*     */ import org.jboss.ws.extensions.security.element.X509Token;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class EncryptionOperation
/*     */   implements EncodingOperation
/*     */ {
/*     */   private SecurityHeader header;
/*     */   private SecurityStore store;
/*  70 */   private static HashMap<String, Algorithm> algorithms = new HashMap(4);
/*     */   private static final String DEFAULT_ALGORITHM = "aes-128";
/*     */ 
/*     */   public EncryptionOperation(SecurityHeader header, SecurityStore store)
/*     */     throws WSSecurityException
/*     */   {
/*  79 */     this.header = header;
/*  80 */     this.store = store;
/*     */   }
/*     */ 
/*     */   private void processTarget(XMLCipher cipher, Document message, Target target, ReferenceList list, SecretKey key) throws WSSecurityException
/*     */   {
/*  85 */     if (!(target instanceof QNameTarget)) {
/*  86 */       throw new NotImplementedException();
/*     */     }
/*  88 */     QName name = ((QNameTarget)target).getName();
/*     */ 
/*  90 */     Element element = Util.findElement(message.getDocumentElement(), name);
/*  91 */     if (element == null) {
/*  92 */       throw new RuntimeException("Could not find element");
/*     */     }
/*     */ 
/*  95 */     Util.assignWsuId(element);
/*     */     try
/*     */     {
/*  99 */       cipher.init(1, key);
/* 100 */       EncryptedData encrypted = cipher.getEncryptedData();
/* 101 */       String id = Util.generateId("encrypted");
/* 102 */       encrypted.setId(id);
/* 103 */       list.add(id);
/* 104 */       cipher.doFinal(message, element, target.isContent());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 108 */       throw new WSSecurityException("Error encrypting target: " + name, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public SecretKey getSecretKey(String algorithm) throws WSSecurityException
/*     */   {
/* 114 */     Algorithm alg = (Algorithm)algorithms.get(algorithm);
/*     */     try
/*     */     {
/* 118 */       KeyGenerator kgen = KeyGenerator.getInstance(alg.jceName);
/* 119 */       kgen.init(alg.size);
/* 120 */       return kgen.generateKey();
/*     */     }
/*     */     catch (NoSuchAlgorithmException e) {
/*     */     }
/* 124 */     throw new WSSecurityException(e.getMessage());
/*     */   }
/*     */ 
/*     */   public void process(Document message, List<Target> targets, String alias, String credential, String algorithm)
/*     */     throws WSSecurityException
/*     */   {
/* 130 */     if (!algorithms.containsKey(algorithm)) {
/* 131 */       algorithm = "aes-128";
/* 133 */     }SecretKey secretKey = getSecretKey(algorithm);
/*     */     XMLCipher cipher;
/*     */     try {
/* 137 */       cipher = XMLCipher.getInstance(((Algorithm)algorithms.get(algorithm)).xmlName);
/* 138 */       cipher.init(1, secretKey);
/*     */     }
/*     */     catch (XMLSecurityException e)
/*     */     {
/* 142 */       throw new WSSecurityException("Error initializing xml cipher" + e.getMessage(), e);
/*     */     }
/*     */ 
/* 145 */     ReferenceList list = new ReferenceList();
/*     */ 
/* 147 */     if ((targets == null) || (targets.size() == 0))
/*     */     {
/* 150 */       String namespace = message.getDocumentElement().getNamespaceURI();
/* 151 */       processTarget(cipher, message, new QNameTarget(new QName(namespace, "Body"), true), list, secretKey);
/*     */     }
/*     */     else
/*     */     {
/* 155 */       for (Target target : targets) {
/* 156 */         processTarget(cipher, message, target, list, secretKey);
/*     */       }
/*     */     }
/* 159 */     X509Certificate cert = this.store.getCertificate(alias);
/* 160 */     X509Token token = (X509Token)this.header.getSharedToken(cert);
/*     */ 
/* 163 */     if (token == null)
/*     */     {
/* 165 */       token = new X509Token(cert, message);
/* 166 */       this.header.addToken(token);
/*     */     }
/*     */ 
/* 169 */     EncryptedKey eKey = new EncryptedKey(message, secretKey, token, list);
/* 170 */     this.header.addSecurityProcess(eKey);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  71 */     algorithms.put("aes-128", new Algorithm("AES", "http://www.w3.org/2001/04/xmlenc#aes128-cbc", 128));
/*  72 */     algorithms.put("aes-192", new Algorithm("AES", "http://www.w3.org/2001/04/xmlenc#aes192-cbc", 192));
/*  73 */     algorithms.put("aes-256", new Algorithm("AES", "http://www.w3.org/2001/04/xmlenc#aes256-cbc", 256));
/*  74 */     algorithms.put("tripledes", new Algorithm("TripleDes", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc", 168));
/*     */   }
/*     */ 
/*     */   private static class Algorithm
/*     */   {
/*     */     public String jceName;
/*     */     public String xmlName;
/*     */     public int size;
/*     */ 
/*     */     Algorithm(String jceName, String xmlName, int size)
/*     */     {
/*  54 */       this.jceName = jceName;
/*  55 */       this.xmlName = xmlName;
/*  56 */       this.size = size;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.EncryptionOperation
 * JD-Core Version:    0.6.0
 */