/*    */ package org.jboss.ws.extensions.security;
/*    */ 
/*    */ import org.jboss.ws.extensions.security.element.SecurityHeader;
/*    */ import org.jboss.ws.extensions.security.element.Token;
/*    */ import org.jboss.ws.extensions.security.element.UsernameToken;
/*    */ import org.jboss.wsf.spi.SPIProvider;
/*    */ import org.jboss.wsf.spi.SPIProviderResolver;
/*    */ import org.jboss.wsf.spi.invocation.SecurityAdaptor;
/*    */ import org.jboss.wsf.spi.invocation.SecurityAdaptorFactory;
/*    */ import org.w3c.dom.Document;
/*    */ 
/*    */ public class ReceiveUsernameOperation
/*    */   implements TokenOperation
/*    */ {
/*    */   private SecurityHeader header;
/*    */   private SecurityStore store;
/*    */   private SecurityAdaptorFactory secAdapterfactory;
/*    */ 
/*    */   public ReceiveUsernameOperation(SecurityHeader header, SecurityStore store)
/*    */   {
/* 44 */     this.header = header;
/* 45 */     this.store = store;
/*    */ 
/* 47 */     SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
/* 48 */     this.secAdapterfactory = ((SecurityAdaptorFactory)spiProvider.getSPI(SecurityAdaptorFactory.class));
/*    */   }
/*    */ 
/*    */   public void process(Document message, Token token) throws WSSecurityException
/*    */   {
/* 53 */     UsernameToken user = (UsernameToken)token;
/* 54 */     SecurityAdaptor securityAdaptor = this.secAdapterfactory.newSecurityAdapter();
/* 55 */     securityAdaptor.setPrincipal(new SimplePrincipal(user.getUsername()));
/* 56 */     securityAdaptor.setCredential(user.getPassword());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.ReceiveUsernameOperation
 * JD-Core Version:    0.6.0
 */