/*     */ package org.jboss.ws.extensions.security;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import javax.xml.parsers.ParserConfigurationException;
/*     */ import org.apache.xml.security.c14n.CanonicalizationException;
/*     */ import org.apache.xml.security.c14n.Canonicalizer;
/*     */ import org.apache.xml.security.c14n.InvalidCanonicalizerException;
/*     */ import org.apache.xml.security.signature.XMLSignatureInput;
/*     */ import org.apache.xml.security.transforms.Transform;
/*     */ import org.apache.xml.security.transforms.TransformSpi;
/*     */ import org.apache.xml.security.transforms.TransformationException;
/*     */ import org.apache.xml.security.utils.XMLUtils;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.utils.ThreadLocalAssociation;
/*     */ import org.jboss.ws.extensions.security.element.BinarySecurityToken;
/*     */ import org.jboss.ws.extensions.security.element.SecurityTokenReference;
/*     */ import org.w3c.dom.Element;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public class STRTransform extends TransformSpi
/*     */ {
/*     */   public static final String STR_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform";
/*     */ 
/*     */   private String canonicalize(Element element, Element method)
/*     */     throws TransformationException, InvalidCanonicalizerException, CanonicalizationException
/*     */   {
/*  74 */     if ((method == null) || (!method.getLocalName().equals("CanonicalizationMethod"))) {
/*  75 */       throw new TransformationException("CanonicalizationMethod expected!");
/*     */     }
/*  77 */     String algorithm = method.getAttribute("Algorithm");
/*  78 */     if ((algorithm == null) || (algorithm.length() == 0)) {
/*  79 */       throw new TransformationException("CanonicalizationMethod missing algorithm!");
/*     */     }
/*  81 */     Canonicalizer canon = Canonicalizer.getInstance(algorithm);
/*     */ 
/*  83 */     return new String(canon.canonicalizeSubtree(element, "#default"));
/*     */   }
/*     */ 
/*     */   protected String engineGetURI()
/*     */   {
/*  89 */     return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform";
/*     */   }
/*     */ 
/*     */   protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input)
/*     */     throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException, ParserConfigurationException, SAXException
/*     */   {
/*  98 */     SecurityStore store = (SecurityStore)ThreadLocalAssociation.localStrTransformAssoc().get();
/*     */ 
/* 100 */     if (store == null) {
/* 101 */       throw new WSException("SecurityStore Thread Local not initialized before call!");
/*     */     }
/*     */     try
/*     */     {
/* 105 */       if (!input.isElement()) {
/* 106 */         throw new NotImplementedException("Only element input is supported");
/*     */       }
/*     */ 
/* 109 */       Element element = (Element)input.getSubNode();
/* 110 */       SecurityTokenReference ref = new SecurityTokenReference(element);
/* 111 */       KeyResolver resolver = new KeyResolver(store);
/* 112 */       BinarySecurityToken token = resolver.resolve(ref);
/*     */ 
/* 115 */       element = token.getSTRTransformElement();
/*     */ 
/* 118 */       Element parameters = XMLUtils.selectNode(this._transformObject.getElement().getFirstChild(), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "TransformationParameters", 0);
/*     */ 
/* 120 */       if (parameters == null) {
/* 121 */         throw new TransformationException("wsse:TransformationParameters expected!");
/*     */       }
/* 123 */       Element method = Util.getFirstChildElement(parameters);
/* 124 */       String transformed = canonicalize(element, method);
/*     */ 
/* 128 */       int startTag = transformed.indexOf('<');
/* 129 */       int endTag = transformed.indexOf('>', startTag + 1);
/* 130 */       String within = transformed.substring(startTag + 1, endTag);
/* 131 */       if (!within.contains("xmlns="))
/*     */       {
/* 133 */         insPos = within.indexOf(" ") + startTag + 1;
/* 134 */         transformed = new StringBuilder(transformed).insert(insPos, " xmlns=\"\"").toString();
/*     */       }
/*     */ 
/* 137 */       int insPos = new XMLSignatureInput(transformed.getBytes());
/*     */       return insPos;
/*     */     }
/*     */     catch (WSSecurityException e)
/*     */     {
/* 141 */       throw new TransformationException(e.getMessage(), e);
/*     */     }
/*     */     finally
/*     */     {
/* 145 */       ThreadLocalAssociation.localStrTransformAssoc().set(null); } throw localObject;
/*     */   }
/*     */ 
/*     */   public static void setSecurityStore(SecurityStore store)
/*     */   {
/* 151 */     ThreadLocalAssociation.localStrTransformAssoc().set(store);
/*     */   }
/*     */ 
/*     */   public boolean wantsOctetStream()
/*     */   {
/* 156 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean wantsNodeSet()
/*     */   {
/* 161 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean returnsOctetStream()
/*     */   {
/* 166 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean returnsNodeSet()
/*     */   {
/* 171 */     return false;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  64 */       Transform.register("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", STRTransform.class.getName());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.STRTransform
 * JD-Core Version:    0.6.0
 */