/*    */ package org.jboss.ws.extensions.security;
/*    */ 
/*    */ import java.lang.reflect.Constructor;
/*    */ import java.util.List;
/*    */ import org.apache.xml.security.Init;
/*    */ import org.jboss.ws.extensions.security.element.SecurityHeader;
/*    */ import org.w3c.dom.Document;
/*    */ import org.w3c.dom.Element;
/*    */ 
/*    */ public class SecurityEncoder
/*    */ {
/*    */   private List<OperationDescription<EncodingOperation>> operations;
/*    */   private SecurityStore store;
/*    */ 
/*    */   public SecurityEncoder(List<OperationDescription<EncodingOperation>> operations, SecurityStore store)
/*    */   {
/* 47 */     Init.init();
/* 48 */     this.operations = operations;
/* 49 */     this.store = store;
/*    */   }
/*    */ 
/*    */   private void attachHeader(SecurityHeader header, Document message)
/*    */   {
/* 54 */     Element soapHeader = Util.findOrCreateSoapHeader(message.getDocumentElement());
/*    */     try
/*    */     {
/* 57 */       Element wsse = header.getElement();
/* 58 */       wsse.setAttributeNS(soapHeader.getNamespaceURI(), soapHeader.getPrefix() + ":mustUnderstand", "1");
/* 59 */       soapHeader.insertBefore(wsse, soapHeader.getFirstChild());
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/*    */     }
/*    */   }
/*    */ 
/*    */   public void encode(Document message) throws WSSecurityException {
/* 67 */     SecurityHeader header = new SecurityHeader(message);
/* 68 */     for (OperationDescription op : this.operations)
/*    */     {
/*    */       EncodingOperation operation;
/*    */       try
/*    */       {
/* 74 */         Constructor constructor = op.getOperation().getConstructor(new Class[] { SecurityHeader.class, SecurityStore.class });
/* 75 */         operation = (EncodingOperation)constructor.newInstance(new Object[] { header, this.store });
/*    */       }
/*    */       catch (Exception e)
/*    */       {
/* 79 */         throw new WSSecurityException("Error constructing operation: " + op.getOperation());
/*    */       }
/*    */ 
/* 82 */       operation.process(message, op.getTargets(), op.getCertificateAlias(), op.getCredential(), op.getAlgorithm());
/*    */     }
/* 84 */     attachHeader(header, message);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.SecurityEncoder
 * JD-Core Version:    0.6.0
 */