/*    */ package org.jboss.ws.extensions.security;
/*    */ 
/*    */ import java.util.Calendar;
/*    */ import org.jboss.ws.extensions.security.element.Timestamp;
/*    */ import org.w3c.dom.Document;
/*    */ 
/*    */ public class TimestampVerificationOperation
/*    */ {
/* 32 */   private Calendar now = null;
/*    */ 
/*    */   public TimestampVerificationOperation()
/*    */   {
/*    */   }
/*    */ 
/*    */   public TimestampVerificationOperation(Calendar now)
/*    */   {
/* 46 */     this.now = now;
/*    */   }
/*    */ 
/*    */   public void process(Document message, Timestamp timestamp) throws WSSecurityException
/*    */   {
/* 51 */     Calendar expired = timestamp.getExpires();
/* 52 */     Calendar created = timestamp.getCreated();
/* 53 */     Calendar now = this.now == null ? Calendar.getInstance() : this.now;
/*    */ 
/* 55 */     if (created.after(now)) {
/* 56 */       throw new WSSecurityException("Invalid timestamp, message claimed to be created after now");
/*    */     }
/* 58 */     if ((expired != null) && (!now.before(expired)))
/* 59 */       throw new FailedCheckException("Expired message.");
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.TimestampVerificationOperation
 * JD-Core Version:    0.6.0
 */