/*     */ package org.jboss.ws.extensions.security;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ 
/*     */ public class Util
/*     */ {
/*  38 */   public static int count = 0;
/*     */ 
/*     */   public static String assignWsuId(Element element)
/*     */   {
/*  42 */     String id = element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
/*     */ 
/*  44 */     if ((id == null) || (id.length() < 1))
/*     */     {
/*  46 */       id = generateId();
/*  47 */       element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", id);
/*  48 */       addNamespace(element, "wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
/*     */     }
/*     */ 
/*  51 */     return id;
/*     */   }
/*     */ 
/*     */   public static Element getFirstChildElement(Node node)
/*     */   {
/*  56 */     Node child = node.getFirstChild();
/*  57 */     while ((child != null) && (child.getNodeType() != 1)) {
/*  58 */       child = child.getNextSibling();
/*     */     }
/*  60 */     return (Element)child;
/*     */   }
/*     */ 
/*     */   public static Element getNextSiblingElement(Element element)
/*     */   {
/*  65 */     Node sibling = element.getNextSibling();
/*  66 */     while ((sibling != null) && (sibling.getNodeType() != 1)) {
/*  67 */       sibling = sibling.getNextSibling();
/*     */     }
/*  69 */     return (Element)sibling;
/*     */   }
/*     */ 
/*     */   public static Element getPreviousSiblingElement(Element element)
/*     */   {
/*  74 */     Node sibling = element.getPreviousSibling();
/*  75 */     while ((sibling != null) && (sibling.getNodeType() != 1)) {
/*  76 */       sibling = sibling.getPreviousSibling();
/*     */     }
/*  78 */     return (Element)sibling;
/*     */   }
/*     */ 
/*     */   public static Element findElement(Element root, String localName, String namespace)
/*     */   {
/*  83 */     return findElement(root, new QName(namespace, localName));
/*     */   }
/*     */ 
/*     */   public static Element findElement(Element root, QName name)
/*     */   {
/*  89 */     if (matchNode(root, name)) {
/*  90 */       return root;
/*     */     }
/*     */ 
/*  93 */     for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling())
/*     */     {
/*  95 */       if (child.getNodeType() != 1) {
/*     */         continue;
/*     */       }
/*  98 */       Node possibleMatch = findElement((Element)child, name);
/*  99 */       if (possibleMatch != null) {
/* 100 */         return (Element)possibleMatch;
/*     */       }
/*     */     }
/* 103 */     return null;
/*     */   }
/*     */ 
/*     */   public static List<Node> findAllElements(Element root, QName name, boolean local)
/*     */   {
/* 108 */     List list = new ArrayList();
/* 109 */     if (matchNode(root, name, local)) {
/* 110 */       list.add(root);
/*     */     }
/* 112 */     for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling())
/*     */     {
/* 114 */       if (child.getNodeType() != 1) {
/*     */         continue;
/*     */       }
/* 117 */       list.addAll(findAllElements((Element)child, name, local));
/*     */     }
/*     */ 
/* 120 */     return list;
/*     */   }
/*     */ 
/*     */   public static Element findElementByWsuId(Element root, String id)
/*     */   {
/* 126 */     if (id.equals(getWsuId(root))) {
/* 127 */       return root;
/*     */     }
/*     */ 
/* 130 */     for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling())
/*     */     {
/* 132 */       if (child.getNodeType() != 1) {
/*     */         continue;
/*     */       }
/* 135 */       Node possibleMatch = findElementByWsuId((Element)child, id);
/* 136 */       if (possibleMatch != null) {
/* 137 */         return (Element)possibleMatch;
/*     */       }
/*     */     }
/* 140 */     return null;
/*     */   }
/*     */ 
/*     */   public static Element findOrCreateSoapHeader(Element envelope)
/*     */   {
/* 145 */     String prefix = envelope.getPrefix();
/* 146 */     String uri = envelope.getNamespaceURI();
/* 147 */     QName name = new QName(uri, "Header");
/* 148 */     Element header = findElement(envelope, name);
/* 149 */     if (header == null)
/*     */     {
/* 151 */       header = envelope.getOwnerDocument().createElementNS(uri, prefix + ":Header");
/* 152 */       envelope.insertBefore(header, envelope.getFirstChild());
/*     */     }
/*     */ 
/* 155 */     return header;
/*     */   }
/*     */ 
/*     */   public static String getWsuId(Element element)
/*     */   {
/* 160 */     if (element.hasAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id")) {
/* 161 */       return element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
/*     */     }
/* 163 */     if (element.hasAttribute("Id"))
/*     */     {
/* 165 */       String ns = element.getNamespaceURI();
/* 166 */       if (("http://www.w3.org/2000/09/xmldsig#".equals(ns)) || ("http://www.w3.org/2001/04/xmlenc#".equals(ns))) {
/* 167 */         return element.getAttribute("Id");
/*     */       }
/*     */     }
/* 170 */     return null;
/*     */   }
/*     */ 
/*     */   public static boolean equalStrings(String string1, String string2)
/*     */   {
/* 175 */     if ((string1 == null) && (string2 == null)) {
/* 176 */       return true;
/*     */     }
/* 178 */     return (string1 != null) && (string1.equals(string2));
/*     */   }
/*     */ 
/*     */   public static boolean matchNode(Node node, QName name)
/*     */   {
/* 183 */     return matchNode(node, name, false);
/*     */   }
/*     */ 
/*     */   public static boolean matchNode(Node node, QName name, boolean local)
/*     */   {
/* 188 */     return (equalStrings(node.getLocalName(), name.getLocalPart())) && ((local) || (equalStrings(node.getNamespaceURI(), name.getNamespaceURI())));
/*     */   }
/*     */ 
/*     */   public static String generateId()
/*     */   {
/* 194 */     return generateId("element");
/*     */   }
/*     */ 
/*     */   public static void addNamespace(Element element, String prefix, String uri)
/*     */   {
/* 199 */     element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
/*     */   }
/*     */ 
/*     */   public static String generateId(String prefix)
/*     */   {
/* 204 */     StringBuilder id = new StringBuilder();
/* 205 */     long time = System.currentTimeMillis();
/*     */ 
/* 208 */     synchronized (Util.class)
/*     */     {
/* 210 */       count += 1;
/*     */     }
/*     */ 
/* 213 */     id.append(prefix).append("-").append(count).append("-").append(time).append("-").append(id.hashCode());
/*     */ 
/* 215 */     return id.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.Util
 * JD-Core Version:    0.6.0
 */