/*     */ package org.jboss.ws.extensions.security.element;
/*     */ 
/*     */ import org.jboss.ws.extensions.security.WSSecurityException;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class DirectReference extends Reference
/*     */ {
/*     */   private Document doc;
/*     */   private String uri;
/*     */   private String valueType;
/*     */   private Element cachedElement;
/*     */ 
/*     */   public DirectReference(Document doc)
/*     */   {
/*  54 */     this.doc = doc;
/*     */   }
/*     */ 
/*     */   public DirectReference(Document doc, BinarySecurityToken token)
/*     */   {
/*  59 */     this.doc = doc;
/*  60 */     referenceToken(token);
/*     */   }
/*     */ 
/*     */   public DirectReference(Element element) throws WSSecurityException
/*     */   {
/*  65 */     this.doc = element.getOwnerDocument();
/*     */ 
/*  67 */     if (!"Reference".equals(element.getLocalName())) {
/*  68 */       throw new WSSecurityException("Invalid message, invalid local name on a DirectReference");
/*     */     }
/*  70 */     String uri = element.getAttribute("URI");
/*  71 */     if ((uri == null) || (uri.length() == 0)) {
/*  72 */       throw new WSSecurityException("Inavliad message, Reference element is missing a URI");
/*     */     }
/*  74 */     setUri(uri);
/*     */ 
/*  76 */     String valueType = element.getAttribute("ValueType");
/*  77 */     if ((valueType == null) || (valueType.length() == 0)) {
/*  78 */       throw new WSSecurityException("Inavliad message, Reference element is missing a ValueType");
/*     */     }
/*  80 */     setValueType(valueType);
/*     */   }
/*     */ 
/*     */   public String getUri()
/*     */   {
/*  85 */     return this.uri;
/*     */   }
/*     */ 
/*     */   public void referenceToken(BinarySecurityToken token)
/*     */   {
/*  90 */     setUri("#" + token.getId());
/*  91 */     setValueType(token.getValueType());
/*     */   }
/*     */ 
/*     */   public void setUri(String uri)
/*     */   {
/*  96 */     this.uri = uri;
/*     */   }
/*     */ 
/*     */   public String getValueType()
/*     */   {
/* 101 */     return this.valueType;
/*     */   }
/*     */ 
/*     */   public void setValueType(String valueType)
/*     */   {
/* 106 */     this.valueType = valueType;
/*     */   }
/*     */ 
/*     */   public Element getElement()
/*     */   {
/* 111 */     if (this.cachedElement != null) {
/* 112 */       return this.cachedElement;
/*     */     }
/* 114 */     Element element = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Reference");
/* 115 */     element.setAttribute("ValueType", getValueType());
/* 116 */     element.setAttribute("URI", getUri());
/*     */ 
/* 118 */     this.cachedElement = element;
/* 119 */     return this.cachedElement;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.element.DirectReference
 * JD-Core Version:    0.6.0
 */