/*     */ package org.jboss.ws.extensions.security.element;
/*     */ 
/*     */ import java.math.BigInteger;
/*     */ import java.security.cert.X509Certificate;
/*     */ import org.apache.xml.security.utils.XMLUtils;
/*     */ import org.jboss.ws.extensions.security.InvalidSecurityHeaderException;
/*     */ import org.jboss.ws.extensions.security.Util;
/*     */ import org.jboss.ws.extensions.security.WSSecurityException;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class X509IssuerSerial extends Reference
/*     */ {
/*     */   private Document doc;
/*     */   private String issuer;
/*     */   private String serial;
/*     */   private Element cachedElement;
/*     */ 
/*     */   public X509IssuerSerial(Document doc, BinarySecurityToken token)
/*     */     throws WSSecurityException
/*     */   {
/*  57 */     this.doc = doc;
/*  58 */     referenceToken(token);
/*     */   }
/*     */ 
/*     */   public X509IssuerSerial(Element element) throws WSSecurityException
/*     */   {
/*  63 */     this.doc = element.getOwnerDocument();
/*     */ 
/*  65 */     if (!"X509Data".equals(element.getLocalName())) {
/*  66 */       throw new InvalidSecurityHeaderException("Invalid message, invalid local name on a X509Data element");
/*     */     }
/*  68 */     element = Util.getFirstChildElement(element);
/*  69 */     if (element == null) {
/*  70 */       throw new InvalidSecurityHeaderException("X509DataElement empty");
/*     */     }
/*  72 */     if (!element.getLocalName().equals("X509IssuerSerial")) {
/*  73 */       throw new InvalidSecurityHeaderException("Only X509IssuerSerial is supported for an X509Data element");
/*     */     }
/*  75 */     element = Util.getFirstChildElement(element);
/*  76 */     if (element == null) {
/*  77 */       throw new InvalidSecurityHeaderException("X509IssuerSerial empty");
/*     */     }
/*     */ 
/*  80 */     while (element != null)
/*     */     {
/*  82 */       String name = element.getLocalName();
/*  83 */       if (name.equals("X509IssuerName"))
/*  84 */         this.issuer = XMLUtils.getFullTextChildrenFromElement(element);
/*  85 */       else if (name.equals("X509SerialNumber")) {
/*  86 */         this.serial = XMLUtils.getFullTextChildrenFromElement(element);
/*     */       }
/*  88 */       element = Util.getNextSiblingElement(element);
/*     */     }
/*     */ 
/*  91 */     if (this.serial == null) {
/*  92 */       throw new InvalidSecurityHeaderException("X509SerialNumber missing from X509IssuerSerial");
/*     */     }
/*  94 */     if (this.issuer == null)
/*  95 */       throw new InvalidSecurityHeaderException("X509IssuerName missing from X509IssuerSerial");
/*     */   }
/*     */ 
/*     */   public void referenceToken(BinarySecurityToken token) throws WSSecurityException
/*     */   {
/* 100 */     if (!(token instanceof X509Token)) {
/* 101 */       throw new WSSecurityException("X509IssuerSerial tried to reference something besides an X509 token");
/*     */     }
/* 103 */     X509Token x509 = (X509Token)token;
/* 104 */     X509Certificate cert = x509.getCert();
/*     */ 
/* 106 */     this.issuer = cert.getIssuerDN().toString();
/* 107 */     this.serial = cert.getSerialNumber().toString();
/*     */   }
/*     */ 
/*     */   public String getIssuer()
/*     */   {
/* 112 */     return this.issuer;
/*     */   }
/*     */ 
/*     */   public String getSerial()
/*     */   {
/* 117 */     return this.serial;
/*     */   }
/*     */ 
/*     */   public Document getDocument()
/*     */   {
/* 122 */     return this.doc;
/*     */   }
/*     */ 
/*     */   public Element getElement()
/*     */   {
/* 127 */     if (this.cachedElement != null) {
/* 128 */       return this.cachedElement;
/*     */     }
/* 130 */     Element element = this.doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509Data");
/* 131 */     Element issuerSerial = this.doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509IssuerSerial");
/* 132 */     element.appendChild(issuerSerial);
/*     */ 
/* 134 */     element = this.doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509IssuerName");
/* 135 */     element.appendChild(this.doc.createTextNode(this.issuer));
/* 136 */     issuerSerial.appendChild(element);
/*     */ 
/* 138 */     element = this.doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509SerialNumber");
/* 139 */     element.appendChild(this.doc.createTextNode(this.serial));
/* 140 */     issuerSerial.appendChild(element);
/*     */ 
/* 142 */     this.cachedElement = element;
/* 143 */     return this.cachedElement;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.security.element.X509IssuerSerial
 * JD-Core Version:    0.6.0
 */