/*     */ package org.jboss.ws.extensions.xop.jaxrpc;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import javax.activation.DataHandler;
/*     */ import javax.activation.DataSource;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.soap.attachment.ContentHandlerRegistry;
/*     */ import org.jboss.ws.core.soap.attachment.SwapableMemoryDataSource;
/*     */ import org.jboss.ws.core.utils.MimeUtils;
/*     */ import org.jboss.ws.extensions.xop.XOPContext;
/*     */ import org.jboss.wsf.common.IOUtils;
/*     */ import org.jboss.xb.binding.Constants;
/*     */ import org.jboss.xb.binding.sunday.marshalling.MarshallingContext;
/*     */ import org.jboss.xb.binding.sunday.marshalling.TermBeforeMarshallingCallback;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.TermBeforeSetParentCallback;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.UnmarshallingContext;
/*     */ 
/*     */ public class JBossXBContentAdapter
/*     */   implements TermBeforeMarshallingCallback, TermBeforeSetParentCallback
/*     */ {
/*  62 */   private static final Logger log = Logger.getLogger(JBossXBContentAdapter.class);
/*  63 */   private static final QName XMIME_BASE_64 = new QName("http://www.w3.org/2005/05/xmlmime", "base64Binary");
/*  64 */   private static final QName XOP_INCLUDE = new QName("http://www.w3.org/2004/08/xop/include", "Include");
/*     */ 
/*     */   public Object beforeMarshalling(Object object, MarshallingContext marshallingContext)
/*     */   {
/*  78 */     boolean mtomDisabled = !XOPContext.isMTOMEnabled();
/*  79 */     boolean convertableType = (object != null) && (!(object instanceof byte[]));
/*     */ 
/*  81 */     if ((mtomDisabled) && (convertableType))
/*     */     {
/*  83 */       String contentType = MimeUtils.resolveMimeType(object);
/*  84 */       if (log.isDebugEnabled()) log.debug("Adopt " + object.getClass() + " to byte[], contentType " + contentType);
/*     */ 
/*  86 */       DataHandler dh = new DataHandler(object, contentType);
/*  87 */       ByteArrayOutputStream bout = new ByteArrayOutputStream();
/*     */       try
/*     */       {
/*  90 */         IOUtils.copyStream(bout, dh.getInputStream());
/*  91 */         object = bout.toByteArray();
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/*  95 */         throw new WSException("Failed to adopt XOP content type", e);
/*     */       }
/*     */     }
/*     */ 
/*  99 */     return object;
/*     */   }
/*     */ 
/*     */   public Object beforeSetParent(Object object, UnmarshallingContext ctx)
/*     */   {
/* 108 */     if (null == object) {
/* 109 */       return object;
/*     */     }
/*     */ 
/* 112 */     Class targetClass = ctx.resolvePropertyType();
/*     */ 
/* 114 */     if (null == targetClass) {
/* 115 */       throw new WSException("Failed to resolve target property type on " + ctx.getParticle());
/*     */     }
/*     */ 
/* 118 */     boolean isRegularMessage = !XOPContext.isXOPMessage();
/* 119 */     boolean isSimpleType = object instanceof byte[];
/* 120 */     boolean doTypesMatch = targetClass.equals(object.getClass());
/*     */ 
/* 125 */     if ((isRegularMessage) && (isSimpleType) && (!doTypesMatch))
/*     */     {
/* 127 */       String contentType = MimeUtils.resolveMimeType(targetClass);
/* 128 */       if (log.isDebugEnabled()) log.debug("Adopt byte[] to " + targetClass + ", contentType " + contentType);
/*     */ 
/*     */       try
/*     */       {
/* 132 */         DataHandler dh = new DataHandler(wrapAsDataSource(object, contentType));
/*     */ 
/* 136 */         if (targetClass.equals(DataHandler.class))
/* 137 */           object = dh;
/*     */         else
/* 139 */           object = dh.getContent();
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 143 */         throw new WSException("Failed to adopt XOP content type", e);
/*     */       }
/*     */ 
/*     */     }
/* 152 */     else if ((XOPContext.isXOPMessage()) && ((object instanceof DataHandler)) && (!doTypesMatch))
/*     */     {
/*     */       try
/*     */       {
/* 156 */         String contentType = MimeUtils.resolveMimeType(targetClass);
/* 157 */         if (log.isDebugEnabled()) log.debug("Adopt DataHandler to " + targetClass + ", contentType " + contentType);
/*     */ 
/* 159 */         DataHandler dh = new DataHandler(wrapAsDataSource(object, contentType));
/*     */ 
/* 162 */         object = dh.getContent();
/*     */ 
/* 165 */         if ((object instanceof InputStream))
/*     */         {
/* 167 */           ByteArrayOutputStream bout = new ByteArrayOutputStream();
/* 168 */           dh.writeTo(bout);
/* 169 */           object = bout.toByteArray();
/*     */         }
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 174 */         throw new WSException("Failed to adopt XOP content type", e);
/*     */       }
/*     */     }
/*     */ 
/* 178 */     return object;
/*     */   }
/*     */ 
/*     */   private DataSource wrapAsDataSource(Object object, String contentType)
/*     */     throws IOException
/*     */   {
/*     */     DataSource ds;
/* 185 */     if ((object instanceof byte[]))
/*     */     {
/* 187 */       ds = new SwapableMemoryDataSource(new ByteArrayInputStream((byte[])(byte[])object), contentType);
/*     */     }
/*     */     else
/*     */     {
/*     */       DataSource ds;
/* 189 */       if ((object instanceof DataHandler))
/*     */       {
/* 191 */         ds = new SwapableMemoryDataSource(((DataHandler)object).getInputStream(), contentType);
/*     */       }
/*     */       else
/*     */       {
/* 195 */         throw new IllegalArgumentException("Failed to wrap as data source: " + object.getClass());
/*     */       }
/*     */     }
/*     */     DataSource ds;
/* 198 */     return ds;
/*     */   }
/*     */ 
/*     */   public static void register(SchemaBinding schemaBinding)
/*     */   {
/* 208 */     JBossXBContentAdapter contentAdapter = new JBossXBContentAdapter();
/*     */ 
/* 211 */     TypeBinding base64Type = schemaBinding.getType(Constants.QNAME_BASE64BINARY);
/* 212 */     base64Type.setBeforeMarshallingCallback(contentAdapter);
/* 213 */     base64Type.setBeforeSetParentCallback(contentAdapter);
/*     */ 
/* 216 */     TypeBinding xmimeBase64Type = schemaBinding.getType(XMIME_BASE_64);
/* 217 */     if (xmimeBase64Type != null)
/*     */     {
/* 219 */       xmimeBase64Type.setBeforeMarshallingCallback(contentAdapter);
/* 220 */       xmimeBase64Type.setBeforeSetParentCallback(contentAdapter);
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  69 */     ContentHandlerRegistry.register();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.xop.jaxrpc.JBossXBContentAdapter
 * JD-Core Version:    0.6.0
 */