/*     */ package org.jboss.ws.extensions.xop.jaxws;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import javax.activation.DataHandler;
/*     */ import javax.xml.bind.attachment.AttachmentUnmarshaller;
/*     */ import javax.xml.soap.AttachmentPart;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.soap.attachment.ContentHandlerRegistry;
/*     */ import org.jboss.ws.extensions.xop.XOPContext;
/*     */ 
/*     */ public class AttachmentUnmarshallerImpl extends AttachmentUnmarshaller
/*     */ {
/*     */   public boolean isXOPPackage()
/*     */   {
/*  76 */     return XOPContext.isXOPMessage();
/*     */   }
/*     */ 
/*     */   public DataHandler getAttachmentAsDataHandler(String cid)
/*     */   {
/*     */     try
/*     */     {
/*  83 */       AttachmentPart part = XOPContext.getAttachmentByCID(cid);
/*  84 */       return part.getDataHandler();
/*     */     }
/*     */     catch (SOAPException e) {
/*     */     }
/*  88 */     throw new WSException("Failed to access attachment part", e);
/*     */   }
/*     */ 
/*     */   public byte[] getAttachmentAsByteArray(String cid)
/*     */   {
/*     */     try
/*     */     {
/*  96 */       AttachmentPart part = XOPContext.getAttachmentByCID(cid);
/*  97 */       DataHandler dh = part.getDataHandler();
/*  98 */       ByteArrayOutputStream bout = new ByteArrayOutputStream();
/*  99 */       dh.writeTo(bout);
/*     */ 
/* 101 */       return bout.toByteArray();
/*     */     }
/*     */     catch (SOAPException ex)
/*     */     {
/* 105 */       throw new WSException(ex);
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 109 */     throw new WSException(e);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  66 */     ContentHandlerRegistry.register();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.extensions.xop.jaxws.AttachmentUnmarshallerImpl
 * JD-Core Version:    0.6.0
 */