/*     */ package org.jboss.ws.metadata.builder.jaxws;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Properties;
/*     */ import javax.jws.soap.SOAPBinding;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.ws.BindingType;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.annotation.EndpointConfig;
/*     */ import org.jboss.ws.core.jaxws.client.ServiceObjectFactoryJAXWS;
/*     */ import org.jboss.ws.core.soap.Style;
/*     */ import org.jboss.ws.extensions.policy.metadata.PolicyMetaDataBuilder;
/*     */ import org.jboss.ws.metadata.umdm.ClientEndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData.Type;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.TypesMetaData;
/*     */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBinding;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterface;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLService;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*     */ import org.jboss.wsf.common.ResourceLoaderAdapter;
/*     */ import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedCallPropertyMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;
/*     */ 
/*     */ public class JAXWSClientMetaDataBuilder extends JAXWSMetaDataBuilder
/*     */ {
/*     */   public ServiceMetaData buildMetaData(QName serviceName, URL wsdlURL, UnifiedVirtualFile vfsRoot)
/*     */   {
/*  73 */     if (wsdlURL == null) {
/*  74 */       throw new IllegalArgumentException("Invalid wsdlURL: " + wsdlURL);
/*     */     }
/*  76 */     log.debug("START buildMetaData: [service=" + serviceName + "]");
/*     */     try
/*     */     {
/*  79 */       UnifiedMetaData wsMetaData = new UnifiedMetaData(vfsRoot);
/*     */ 
/*  81 */       ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, serviceName);
/*  82 */       wsMetaData.addService(serviceMetaData);
/*     */ 
/*  84 */       serviceMetaData.setWsdlLocation(wsdlURL);
/*  85 */       WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
/*     */ 
/*  87 */       buildMetaDataInternal(serviceMetaData, wsdlDefinitions);
/*     */ 
/*  90 */       for (EndpointMetaData epMetaData : serviceMetaData.getEndpoints())
/*     */       {
/*  92 */         PolicyMetaDataBuilder policyBuilder = PolicyMetaDataBuilder.getClientSidePolicyMetaDataBuilder();
/*  93 */         policyBuilder.processPolicyExtensions(epMetaData, wsdlDefinitions);
/*     */       }
/*     */ 
/*  98 */       JBossXSModel schemaModel = WSDLUtils.getSchemaModel(wsdlDefinitions.getWsdlTypes());
/*  99 */       serviceMetaData.getTypesMetaData().setSchemaModel(schemaModel);
/*     */ 
/* 101 */       log.debug("END buildMetaData: " + wsMetaData);
/* 102 */       return serviceMetaData;
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 106 */       throw rte;
/*     */     }
/*     */     catch (Exception ex) {
/*     */     }
/* 110 */     throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
/*     */   }
/*     */ 
/*     */   public ServiceMetaData buildMetaData(QName serviceName, URL wsdlURL)
/*     */   {
/* 118 */     return buildMetaData(serviceName, wsdlURL, new ResourceLoaderAdapter());
/*     */   }
/*     */ 
/*     */   private void buildMetaDataInternal(ServiceMetaData serviceMetaData, WSDLDefinitions wsdlDefinitions) throws IOException
/*     */   {
/* 123 */     QName serviceName = serviceMetaData.getServiceName();
/*     */ 
/* 126 */     WSDLService wsdlService = null;
/* 127 */     if (serviceName == null)
/*     */     {
/* 129 */       if (wsdlDefinitions.getServices().length != 1) {
/* 130 */         throw new IllegalArgumentException("Expected a single service element");
/*     */       }
/* 132 */       wsdlService = wsdlDefinitions.getServices()[0];
/* 133 */       serviceMetaData.setServiceName(wsdlService.getName());
/*     */     }
/*     */     else
/*     */     {
/* 137 */       wsdlService = wsdlDefinitions.getService(serviceName);
/*     */     }
/* 139 */     if (wsdlService == null)
/*     */     {
/* 141 */       List serviceNames = new ArrayList();
/* 142 */       for (WSDLService wsdls : wsdlDefinitions.getServices()) {
/* 143 */         serviceNames.add(wsdls.getName());
/*     */       }
/* 145 */       throw new IllegalArgumentException("Cannot obtain wsdl service: " + serviceName + " we have " + serviceNames);
/*     */     }
/*     */ 
/* 150 */     for (WSDLEndpoint wsdlEndpoint : wsdlService.getEndpoints())
/*     */     {
/* 152 */       QName bindingName = wsdlEndpoint.getBinding();
/* 153 */       WSDLBinding wsdlBinding = wsdlEndpoint.getWsdlService().getWsdlDefinitions().getBinding(bindingName);
/* 154 */       String bindingType = wsdlBinding.getType();
/* 155 */       if ((!"http://schemas.xmlsoap.org/wsdl/soap/".equals(bindingType)) && (!"http://schemas.xmlsoap.org/wsdl/soap12/".equals(bindingType)))
/*     */         continue;
/* 157 */       QName portName = wsdlEndpoint.getName();
/* 158 */       QName interfaceQName = wsdlEndpoint.getInterface().getName();
/* 159 */       ClientEndpointMetaData epMetaData = new ClientEndpointMetaData(serviceMetaData, portName, interfaceQName, EndpointMetaData.Type.JAXWS);
/* 160 */       epMetaData.setEndpointAddress(wsdlEndpoint.getAddress());
/* 161 */       serviceMetaData.addEndpoint(epMetaData);
/*     */ 
/* 164 */       initEndpointBinding(wsdlEndpoint, epMetaData);
/*     */ 
/* 167 */       initEndpointEncodingStyle(epMetaData);
/*     */ 
/* 169 */       setupOperationsFromWSDL(epMetaData, wsdlEndpoint);
/*     */ 
/* 172 */       bufferServiceRefContributions(epMetaData);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void bufferServiceRefContributions(EndpointMetaData epMetaData)
/*     */   {
/* 184 */     UnifiedServiceRefMetaData serviceRefMetaData = ServiceObjectFactoryJAXWS.getServiceRefAssociation();
/*     */ 
/* 186 */     if (serviceRefMetaData != null)
/*     */     {
/* 188 */       for (UnifiedPortComponentRefMetaData portComp : serviceRefMetaData.getPortComponentRefs())
/*     */       {
/* 190 */         epMetaData.getServiceRefContrib().add(portComp);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void processServiceRefContributions(EndpointMetaData epMetaData)
/*     */   {
/* 202 */     Iterator it = epMetaData.getServiceRefContrib().iterator();
/*     */ 
/* 204 */     while (it.hasNext())
/*     */     {
/* 206 */       UnifiedPortComponentRefMetaData portComp = (UnifiedPortComponentRefMetaData)it.next();
/*     */ 
/* 208 */       if (epMetaData.matches(portComp))
/*     */       {
/* 210 */         log.debug("Processing service-ref contribution on portType: " + epMetaData.getPortTypeName());
/*     */ 
/* 213 */         if (portComp.getEnableMTOM().booleanValue())
/*     */         {
/* 215 */           String bindingId = epMetaData.getBindingId();
/* 216 */           if (bindingId.equals("http://schemas.xmlsoap.org/wsdl/soap/http"))
/* 217 */             epMetaData.setBindingId("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
/* 218 */           else if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
/* 219 */             epMetaData.setBindingId("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
/*     */           }
/*     */         }
/*     */ 
/* 223 */         for (UnifiedStubPropertyMetaData stubProp : portComp.getStubProperties())
/*     */         {
/* 225 */           epMetaData.getProperties().put(stubProp.getPropName(), stubProp.getPropValue());
/*     */         }
/*     */ 
/* 229 */         for (UnifiedCallPropertyMetaData callProp : portComp.getCallProperties())
/*     */         {
/* 231 */           epMetaData.getProperties().put(callProp.getPropName(), callProp.getPropValue());
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void setupOperationsFromWSDL(EndpointMetaData epMetaData, WSDLEndpoint wsdlEndpoint)
/*     */   {
/* 242 */     WSDLDefinitions wsdlDefinitions = wsdlEndpoint.getInterface().getWsdlDefinitions();
/*     */ 
/* 245 */     WSDLInterface wsdlInterface = wsdlEndpoint.getInterface();
/* 246 */     for (WSDLInterfaceOperation wsdlOperation : wsdlInterface.getOperations())
/*     */     {
/* 248 */       String opName = wsdlOperation.getName().toString();
/* 249 */       QName opQName = wsdlOperation.getName();
/*     */ 
/* 252 */       String javaName = opName.substring(0, 1).toLowerCase() + opName.substring(1);
/*     */ 
/* 254 */       OperationMetaData opMetaData = new OperationMetaData(epMetaData, opQName, javaName);
/* 255 */       epMetaData.addOperation(opMetaData);
/*     */ 
/* 258 */       String style = wsdlOperation.getStyle();
/* 259 */       epMetaData.setStyle("http://www.w3.org/2004/03/wsdl/style/iri".equals(style) ? Style.DOCUMENT : Style.RPC);
/*     */ 
/* 262 */       if ("http://www.w3.org/2004/08/wsdl/in-only".equals(wsdlOperation.getPattern())) {
/* 263 */         opMetaData.setOneWay(true);
/*     */       }
/*     */ 
/* 266 */       WSDLBinding wsdlBinding = wsdlDefinitions.getBindingByInterfaceName(wsdlInterface.getName());
/* 267 */       WSDLBindingOperation wsdlBindingOperation = wsdlBinding.getOperationByRef(opQName);
/* 268 */       if (wsdlBindingOperation != null)
/* 269 */         opMetaData.setSOAPAction(wsdlBindingOperation.getSOAPAction());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void rebuildEndpointMetaData(EndpointMetaData epMetaData, Class<?> wsClass)
/*     */   {
/* 275 */     if (log.isDebugEnabled()) log.debug("START: rebuildMetaData");
/*     */ 
/* 278 */     resetMetaDataBuilder(epMetaData.getClassLoader());
/*     */ 
/* 281 */     epMetaData.setParameterStyle(null);
/*     */ 
/* 284 */     if (wsClass.isAnnotationPresent(BindingType.class)) {
/* 285 */       processBindingType(epMetaData, wsClass);
/*     */     }
/*     */ 
/* 288 */     if (wsClass.isAnnotationPresent(SOAPBinding.class)) {
/* 289 */       processSOAPBinding(epMetaData, wsClass);
/*     */     }
/*     */ 
/* 292 */     processEndpointConfig(epMetaData, wsClass);
/* 293 */     epMetaData.initEndpointConfig();
/*     */ 
/* 296 */     processHandlerChain(epMetaData, wsClass);
/*     */ 
/* 299 */     processWebMethods(epMetaData, wsClass);
/*     */ 
/* 302 */     createJAXBContext(epMetaData);
/* 303 */     populateXmlTypes(epMetaData);
/*     */ 
/* 306 */     epMetaData.setServiceEndpointInterfaceName(wsClass.getName());
/*     */ 
/* 309 */     processServiceRefContributions(epMetaData);
/*     */ 
/* 313 */     epMetaData.eagerInitialize();
/*     */ 
/* 315 */     if (log.isDebugEnabled()) log.debug("END: rebuildMetaData\n" + epMetaData.getServiceMetaData());
/*     */   }
/*     */ 
/*     */   private void processEndpointConfig(EndpointMetaData epMetaData, Class<?> wsClass)
/*     */   {
/* 325 */     if (wsClass.isAnnotationPresent(EndpointConfig.class))
/*     */     {
/* 327 */       EndpointConfig anConfig = (EndpointConfig)wsClass.getAnnotation(EndpointConfig.class);
/* 328 */       epMetaData.setConfigName(anConfig.configName(), anConfig.configFile());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.builder.jaxws.JAXWSClientMetaDataBuilder
 * JD-Core Version:    0.6.0
 */