/*     */ package org.jboss.ws.metadata.builder.jaxws;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.io.Writer;
/*     */ import java.net.URL;
/*     */ import javax.jws.HandlerChain;
/*     */ import javax.jws.WebService;
/*     */ import javax.jws.soap.SOAPMessageHandlers;
/*     */ import javax.management.ObjectName;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.extensions.policy.annotation.PolicyAttachment;
/*     */ import org.jboss.ws.extensions.policy.metadata.PolicyMetaDataBuilder;
/*     */ import org.jboss.ws.metadata.builder.MetaDataBuilder;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData.Type;
/*     */ import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXWS;
/*     */ import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.TypesMetaData;
/*     */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLTypes;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*     */ import org.jboss.ws.metadata.wsse.WSSecurityConfigFactory;
/*     */ import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
/*     */ import org.jboss.ws.metadata.wsse.WSSecurityOMFactory;
/*     */ import org.jboss.ws.tools.ToolsUtils;
/*     */ import org.jboss.ws.tools.wsdl.JAXBWSDLGenerator;
/*     */ import org.jboss.ws.tools.wsdl.WSDLDefinitionsFactory;
/*     */ import org.jboss.ws.tools.wsdl.WSDLGenerator;
/*     */ import org.jboss.ws.tools.wsdl.WSDLWriter;
/*     */ import org.jboss.ws.tools.wsdl.WSDLWriterResolver;
/*     */ import org.jboss.wsf.common.IOUtils;
/*     */ import org.jboss.wsf.spi.deployment.ArchiveDeployment;
/*     */ import org.jboss.wsf.spi.deployment.Deployment;
/*     */ import org.jboss.wsf.spi.deployment.Endpoint;
/*     */ import org.jboss.wsf.spi.deployment.Service;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
/*     */ import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;
/*     */ import org.jboss.wsf.spi.metadata.webservices.WebservicesFactory;
/*     */ import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;
/*     */ 
/*     */ public class JAXWSWebServiceMetaDataBuilder extends JAXWSServerMetaDataBuilder
/*     */ {
/*     */   private boolean generateWsdl;
/*     */   private boolean toolMode;
/*     */   private File wsdlDirectory;
/*     */   private PrintStream messageStream;
/*     */ 
/*     */   public JAXWSWebServiceMetaDataBuilder()
/*     */   {
/*  85 */     this.generateWsdl = true;
/*  86 */     this.toolMode = false;
/*  87 */     this.wsdlDirectory = null;
/*  88 */     this.messageStream = null;
/*     */   }
/*     */ 
/*     */   public void setGenerateWsdl(boolean generateWsdl)
/*     */   {
/* 101 */     this.generateWsdl = generateWsdl;
/*     */   }
/*     */ 
/*     */   public ServerEndpointMetaData buildWebServiceMetaData(Deployment dep, UnifiedMetaData wsMetaData, Class<?> sepClass, String linkName)
/*     */   {
/*     */     try
/*     */     {
/* 108 */       EndpointResult result = processWebService(dep, wsMetaData, sepClass, linkName);
/*     */ 
/* 111 */       ClassLoader runtimeClassLoader = dep.getRuntimeClassLoader();
/* 112 */       if (null == runtimeClassLoader)
/* 113 */         throw new IllegalArgumentException("Runtime loader cannot be null");
/* 114 */       resetMetaDataBuilder(runtimeClassLoader);
/*     */ 
/* 116 */       ServerEndpointMetaData sepMetaData = result.sepMetaData;
/* 117 */       ServiceMetaData serviceMetaData = result.serviceMetaData;
/* 118 */       serviceMetaData.setWsdlLocation(result.wsdlLocation);
/* 119 */       Class seiClass = result.epClass;
/*     */ 
/* 121 */       sepMetaData.setLinkName(linkName);
/* 122 */       sepMetaData.setServiceEndpointImplName(sepClass.getName());
/* 123 */       sepMetaData.setServiceEndpointInterfaceName(seiClass.getName());
/*     */ 
/* 126 */       WSSecurityConfigFactory wsseConfFactory = WSSecurityConfigFactory.newInstance();
/* 127 */       WSSecurityConfiguration securityConfiguration = wsseConfFactory.createConfiguration(wsMetaData.getRootFile(), WSSecurityOMFactory.SERVER_RESOURCE_NAME);
/* 128 */       serviceMetaData.setSecurityConfiguration(securityConfiguration);
/*     */ 
/* 131 */       processSOAPBinding(sepMetaData, seiClass);
/*     */ 
/* 134 */       processBindingType(sepMetaData, seiClass);
/*     */ 
/* 137 */       processEndpointConfig(dep, sepMetaData, sepClass, linkName);
/*     */ 
/* 140 */       processWebMethods(sepMetaData, seiClass);
/*     */ 
/* 143 */       initTransportGuaranteeJSE(dep, sepMetaData, linkName);
/*     */ 
/* 146 */       createJAXBContext(sepMetaData);
/* 147 */       populateXmlTypes(sepMetaData);
/*     */ 
/* 150 */       if (sepClass.isAnnotationPresent(PolicyAttachment.class))
/*     */       {
/* 152 */         PolicyMetaDataBuilder policyBuilder = PolicyMetaDataBuilder.getServerSidePolicyMetaDataBuilder(this.toolMode);
/* 153 */         policyBuilder.processPolicyAnnotations(sepMetaData, sepClass);
/*     */       }
/*     */ 
/* 157 */       if ((this.generateWsdl) || (!this.toolMode)) {
/* 158 */         processOrGenerateWSDL(seiClass, serviceMetaData, result.wsdlLocation, sepMetaData);
/*     */       }
/*     */ 
/* 161 */       if (this.toolMode) {
/* 162 */         return sepMetaData;
/*     */       }
/*     */ 
/* 166 */       WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
/* 167 */       JBossXSModel schemaModel = WSDLUtils.getSchemaModel(wsdlDefinitions.getWsdlTypes());
/* 168 */       serviceMetaData.getTypesMetaData().setSchemaModel(schemaModel);
/*     */ 
/* 171 */       processWebContext(dep, sepClass, linkName, sepMetaData);
/*     */ 
/* 174 */       sepMetaData.initEndpointConfig();
/*     */ 
/* 177 */       if (sepClass.isAnnotationPresent(HandlerChain.class))
/* 178 */         processHandlerChain(sepMetaData, sepClass);
/* 179 */       else if (seiClass.isAnnotationPresent(HandlerChain.class)) {
/* 180 */         processHandlerChain(sepMetaData, seiClass);
/*     */       }
/*     */ 
/* 183 */       processWSDDContribution(sepMetaData);
/*     */ 
/* 186 */       initEndpointAddress(dep, sepMetaData);
/*     */ 
/* 189 */       if ((sepClass.isAnnotationPresent(SOAPMessageHandlers.class)) || (seiClass.isAnnotationPresent(SOAPMessageHandlers.class))) {
/* 190 */         log.warn("@SOAPMessageHandlers is deprecated as of JAX-WS 2.0 with no replacement.");
/*     */       }
/* 192 */       MetaDataBuilder.replaceAddressLocation(sepMetaData);
/* 193 */       processEndpointMetaDataExtensions(sepMetaData, wsdlDefinitions);
/*     */ 
/* 196 */       ObjectName sepID = MetaDataBuilder.createServiceEndpointID(dep, sepMetaData);
/* 197 */       sepMetaData.setServiceEndpointID(sepID);
/*     */ 
/* 199 */       return sepMetaData;
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 203 */       throw rte;
/*     */     }
/*     */     catch (Exception ex) {
/*     */     }
/* 207 */     throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
/*     */   }
/*     */ 
/*     */   private void processWSDDContribution(ServerEndpointMetaData sepMetaData)
/*     */   {
/* 219 */     WebservicesMetaData webservices = WebservicesFactory.loadFromVFSRoot(sepMetaData.getRootFile());
/* 220 */     if (webservices != null)
/*     */     {
/* 222 */       for (WebserviceDescriptionMetaData wsDesc : webservices.getWebserviceDescriptions())
/*     */       {
/* 224 */         for (PortComponentMetaData portComp : wsDesc.getPortComponents())
/*     */         {
/* 228 */           String portCompSEI = portComp.getServiceEndpointInterface();
/* 229 */           boolean doesMatch = portCompSEI != null ? portCompSEI.equals(sepMetaData.getServiceEndpointInterfaceName()) : false;
/* 230 */           if (!doesMatch)
/*     */           {
/* 232 */             doesMatch = portComp.getWsdlPort().equals(sepMetaData.getPortName());
/*     */           }
/*     */ 
/* 235 */           if (!doesMatch) {
/*     */             continue;
/*     */           }
/* 238 */           log.debug("Processing 'webservices.xml' contributions on EndpointMetaData");
/*     */ 
/* 241 */           if (portComp.getWsdlPort() != null)
/*     */           {
/* 243 */             log.debug("Override EndpointMetaData portName " + sepMetaData.getPortName() + " with " + portComp.getWsdlPort());
/* 244 */             sepMetaData.setPortName(portComp.getWsdlPort());
/*     */           }
/*     */ 
/* 248 */           UnifiedHandlerChainsMetaData chainWrapper = portComp.getHandlerChains();
/* 249 */           if (chainWrapper != null)
/*     */           {
/* 251 */             for (UnifiedHandlerChainMetaData handlerChain : chainWrapper.getHandlerChains())
/*     */             {
/* 253 */               for (UnifiedHandlerMetaData uhmd : handlerChain.getHandlers())
/*     */               {
/* 255 */                 log.debug("Contribute handler from webservices.xml: " + uhmd.getHandlerName());
/* 256 */                 HandlerMetaDataJAXWS hmd = HandlerMetaDataJAXWS.newInstance(uhmd, UnifiedHandlerMetaData.HandlerType.ENDPOINT);
/* 257 */                 sepMetaData.addHandler(hmd);
/*     */               }
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/* 263 */           if (!portComp.isEnableMtom())
/*     */             continue;
/* 265 */           log.debug("Enabling MTOM");
/*     */ 
/* 267 */           String bindingId = sepMetaData.getBindingId();
/* 268 */           if (bindingId.equals("http://schemas.xmlsoap.org/wsdl/soap/http"))
/* 269 */             sepMetaData.setBindingId("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
/* 270 */           else if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/"))
/* 271 */             sepMetaData.setBindingId("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private EndpointResult processWebService(Deployment dep, UnifiedMetaData wsMetaData, Class<?> sepClass, String linkName)
/*     */     throws ClassNotFoundException, IOException
/*     */   {
/* 284 */     WebService anWebService = (WebService)sepClass.getAnnotation(WebService.class);
/* 285 */     if (anWebService == null) {
/* 286 */       throw new WSException("Cannot obtain @WebService annotation from: " + sepClass.getName());
/*     */     }
/* 288 */     Endpoint ep = dep.getService().getEndpointByName(linkName);
/*     */ 
/* 290 */     Class seiClass = null;
/*     */ 
/* 292 */     WSDLUtils wsdlUtils = WSDLUtils.getInstance();
/*     */ 
/* 294 */     String name = anWebService.name();
/* 295 */     if (name.length() == 0) {
/* 296 */       name = WSDLUtils.getJustClassName(sepClass);
/*     */     }
/* 298 */     String serviceName = anWebService.serviceName();
/* 299 */     if (serviceName.length() == 0) {
/* 300 */       serviceName = WSDLUtils.getJustClassName(sepClass) + "Service";
/*     */     }
/* 302 */     String serviceNS = anWebService.targetNamespace();
/* 303 */     if (serviceNS.length() == 0) {
/* 304 */       serviceNS = WSDLUtils.getTypeNamespace(sepClass);
/*     */     }
/* 306 */     String portName = anWebService.portName();
/* 307 */     if (portName.length() == 0) {
/* 308 */       portName = name + "Port";
/*     */     }
/* 310 */     String wsdlLocation = anWebService.wsdlLocation();
/* 311 */     String interfaceNS = serviceNS;
/*     */ 
/* 313 */     if (anWebService.endpointInterface().length() > 0)
/*     */     {
/* 315 */       String seiName = anWebService.endpointInterface();
/* 316 */       ClassLoader runtimeClassLoader = dep.getRuntimeClassLoader();
/* 317 */       if (null == runtimeClassLoader)
/* 318 */         throw new IllegalArgumentException("Runtime loader cannot be null");
/* 319 */       seiClass = runtimeClassLoader.loadClass(seiName);
/* 320 */       WebService seiAnnotation = (WebService)seiClass.getAnnotation(WebService.class);
/*     */ 
/* 322 */       if (seiAnnotation == null) {
/* 323 */         throw new WSException("Interface does not have a @WebService annotation: " + seiName);
/*     */       }
/* 325 */       if ((seiAnnotation.portName().length() > 0) || (seiAnnotation.serviceName().length() > 0) || (seiAnnotation.endpointInterface().length() > 0)) {
/* 326 */         throw new WSException("@WebService[portName,serviceName,endpointInterface] MUST NOT be defined on: " + seiName);
/*     */       }
/*     */ 
/* 329 */       name = seiAnnotation.name();
/* 330 */       if (name.length() == 0) {
/* 331 */         name = WSDLUtils.getJustClassName(seiClass);
/*     */       }
/* 333 */       interfaceNS = seiAnnotation.targetNamespace();
/* 334 */       if (interfaceNS.length() == 0) {
/* 335 */         interfaceNS = WSDLUtils.getTypeNamespace(seiClass);
/*     */       }
/*     */ 
/* 341 */       if (wsdlLocation.length() == 0) {
/* 342 */         wsdlLocation = seiAnnotation.wsdlLocation();
/*     */       }
/*     */     }
/*     */ 
/* 346 */     QName portQName = new QName(serviceNS, portName);
/* 347 */     QName portTypeQName = new QName(interfaceNS, name);
/*     */ 
/* 349 */     EndpointResult result = new EndpointResult(null);
/* 350 */     EndpointResult.access$102(result, new ServiceMetaData(wsMetaData, new QName(serviceNS, serviceName)));
/* 351 */     EndpointResult.access$002(result, new ServerEndpointMetaData(result.serviceMetaData, ep, portQName, portTypeQName, EndpointMetaData.Type.JAXWS));
/* 352 */     EndpointResult.access$302(result, seiClass != null ? seiClass : sepClass);
/* 353 */     result.serviceMetaData.addEndpoint(result.sepMetaData);
/* 354 */     wsMetaData.addService(result.serviceMetaData);
/*     */ 
/* 356 */     if ((dep instanceof ArchiveDeployment)) {
/* 357 */       EndpointResult.access$202(result, ((ArchiveDeployment)dep).getMetaDataFileURL(wsdlLocation));
/*     */     }
/* 359 */     return result;
/*     */   }
/*     */ 
/*     */   private void processOrGenerateWSDL(Class wsClass, ServiceMetaData serviceMetaData, URL wsdlLocation, EndpointMetaData epMetaData)
/*     */   {
/* 364 */     PolicyMetaDataBuilder policyBuilder = PolicyMetaDataBuilder.getServerSidePolicyMetaDataBuilder(this.toolMode);
/*     */     try
/*     */     {
/* 367 */       WSDLGenerator generator = new JAXBWSDLGenerator(this.jaxbCtx);
/* 368 */       WSDLDefinitionsFactory factory = WSDLDefinitionsFactory.newInstance();
/* 369 */       if (wsdlLocation != null)
/*     */       {
/* 373 */         WSDLDefinitions wsdlDefinitions = factory.parse(wsdlLocation);
/* 374 */         policyBuilder.processPolicyExtensions(epMetaData, wsdlDefinitions);
/*     */ 
/* 377 */         serviceMetaData.setWsdlLocation(wsdlLocation);
/*     */       }
/*     */       else
/*     */       {
/* 381 */         WSDLDefinitions wsdlDefinitions = generator.generate(serviceMetaData);
/* 382 */         writeWsdl(serviceMetaData, wsdlDefinitions, epMetaData);
/*     */       }
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 387 */       throw rte;
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 391 */       throw new WSException("Cannot write generated wsdl", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void writeWsdl(ServiceMetaData serviceMetaData, WSDLDefinitions wsdlDefinitions, EndpointMetaData epMetaData)
/*     */     throws IOException
/*     */   {
/* 398 */     String wsdlName = ToolsUtils.firstLetterUpperCase(serviceMetaData.getServiceName().getLocalPart());
/*     */ 
/* 400 */     wsdlDefinitions.getWsdlTypes().setNamespace(epMetaData.getPortTypeName().getNamespaceURI());
/*     */     File wsdlFile;
/*     */     File dir;
/*     */     File wsdlFile;
/* 404 */     if (this.wsdlDirectory != null)
/*     */     {
/* 406 */       File dir = this.wsdlDirectory;
/* 407 */       wsdlFile = new File(dir, wsdlName + ".wsdl");
/*     */     }
/*     */     else
/*     */     {
/* 411 */       dir = IOUtils.createTempDirectory();
/* 412 */       wsdlFile = File.createTempFile(wsdlName, ".wsdl", dir);
/* 413 */       wsdlFile.deleteOnExit();
/*     */     }
/*     */ 
/* 416 */     message(wsdlFile.getName());
/* 417 */     Writer writer = IOUtils.getCharsetFileWriter(wsdlFile, "UTF-8");
/* 418 */     new WSDLWriter(wsdlDefinitions).write(writer, "UTF-8", new WSDLWriterResolver(dir)
/*     */     {
/*     */       public WSDLWriterResolver resolve(String suggestedFile)
/*     */         throws IOException
/*     */       {
/*     */         File file;
/*     */         File file;
/* 422 */         if (JAXWSWebServiceMetaDataBuilder.this.wsdlDirectory != null)
/*     */         {
/* 424 */           file = new File(this.val$dir, suggestedFile + ".wsdl");
/*     */         }
/*     */         else
/*     */         {
/* 428 */           file = File.createTempFile(suggestedFile, ".wsdl", this.val$dir);
/* 429 */           file.deleteOnExit();
/*     */         }
/* 431 */         this.actualFile = file.getName();
/* 432 */         JAXWSWebServiceMetaDataBuilder.this.message(this.actualFile);
/* 433 */         this.charset = "UTF-8";
/* 434 */         this.writer = IOUtils.getCharsetFileWriter(file, "UTF-8");
/* 435 */         return this;
/*     */       }
/*     */     });
/* 438 */     writer.close();
/*     */ 
/* 440 */     serviceMetaData.setWsdlLocation(wsdlFile.toURL());
/*     */   }
/*     */ 
/*     */   private void message(String msg)
/*     */   {
/* 445 */     if (this.messageStream != null)
/* 446 */       this.messageStream.println(msg);
/*     */   }
/*     */ 
/*     */   public void setToolMode(boolean toolMode)
/*     */   {
/* 451 */     this.toolMode = toolMode;
/*     */   }
/*     */ 
/*     */   public void setWsdlDirectory(File wsdlDirectory)
/*     */   {
/* 456 */     this.wsdlDirectory = wsdlDirectory;
/*     */   }
/*     */ 
/*     */   public void setMessageStream(PrintStream messageStream)
/*     */   {
/* 461 */     this.messageStream = messageStream;
/*     */   }
/*     */ 
/*     */   private static class EndpointResult
/*     */   {
/*     */     private Class<?> epClass;
/*     */     private ServerEndpointMetaData sepMetaData;
/*     */     private ServiceMetaData serviceMetaData;
/*     */     private URL wsdlLocation;
/*     */     private URL policyLocation;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.builder.jaxws.JAXWSWebServiceMetaDataBuilder
 * JD-Core Version:    0.6.0
 */