/*     */ package org.jboss.ws.metadata.config;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.URL;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.metadata.config.binding.OMFactoryJAXRPC;
/*     */ import org.jboss.ws.metadata.config.binding.OMFactoryJAXWS;
/*     */ import org.jboss.ws.metadata.config.jaxrpc.ConfigRootJAXRPC;
/*     */ import org.jboss.ws.metadata.config.jaxws.ConfigRootJAXWS;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.wsf.common.ResourceLoaderAdapter;
/*     */ import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
/*     */ import org.jboss.xb.binding.JBossXBException;
/*     */ import org.jboss.xb.binding.Unmarshaller;
/*     */ import org.jboss.xb.binding.UnmarshallerFactory;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class JBossWSConfigFactory
/*     */ {
/*  52 */   private final Logger log = Logger.getLogger(JBossWSConfigFactory.class);
/*     */ 
/*  54 */   private static String URN_JAXRPC_CONFIG = "urn:jboss:jaxrpc-config:2.0";
/*  55 */   private static String URN_JAXWS_CONFIG = "urn:jboss:jaxws-config:2.0";
/*     */ 
/*     */   public static JBossWSConfigFactory newInstance()
/*     */   {
/*  66 */     return new JBossWSConfigFactory();
/*     */   }
/*     */ 
/*     */   public Object parse(URL configURL)
/*     */   {
/*  71 */     if (this.log.isDebugEnabled()) this.log.debug("parse: " + configURL);
/*     */     Object wsConfig;
/*     */     try
/*     */     {
/*  76 */       Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
/*  77 */       unmarshaller.setValidation(true);
/*  78 */       unmarshaller.setSchemaValidation(true);
/*     */ 
/*  80 */       String nsURI = getNamespaceURI(configURL);
/*     */       Object wsConfig;
/*  81 */       if (URN_JAXRPC_CONFIG.equals(nsURI))
/*     */       {
/*  83 */         wsConfig = unmarshaller.unmarshal(configURL.openStream(), new OMFactoryJAXRPC(), null);
/*     */       }
/*     */       else
/*     */       {
/*     */         Object wsConfig;
/*  85 */         if (URN_JAXWS_CONFIG.equals(nsURI))
/*     */         {
/*  87 */           wsConfig = unmarshaller.unmarshal(configURL.openStream(), new OMFactoryJAXWS(), null);
/*     */         }
/*     */         else
/*     */         {
/*  91 */           throw new WSException("Invalid config namespace: " + nsURI);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (JBossXBException e)
/*     */     {
/*  97 */       throw new WSException("Error while parsing configuration", e);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 101 */       throw new WSException("Failed to read config file: " + configURL, e);
/*     */     }
/*     */ 
/* 104 */     return wsConfig;
/*     */   }
/*     */ 
/*     */   private String getNamespaceURI(URL configURL)
/*     */   {
/*     */     try
/*     */     {
/* 111 */       Element root = DOMUtils.parse(configURL.openStream());
/* 112 */       return root.getNamespaceURI();
/*     */     }
/*     */     catch (IOException ex) {
/*     */     }
/* 116 */     throw new WSException(ex);
/*     */   }
/*     */ 
/*     */   public CommonConfig getConfig(UnifiedVirtualFile vfsRoot, String configName, String configFile)
/*     */   {
/* 125 */     if (this.log.isDebugEnabled()) this.log.debug("getConfig: [name=" + configName + ",url=" + configFile + "]");
/*     */ 
/* 127 */     if (configName == null)
/* 128 */       throw new IllegalArgumentException("Config name cannot be null");
/* 129 */     if (configFile == null) {
/* 130 */       throw new IllegalArgumentException("Config file cannot be null");
/*     */     }
/*     */ 
/* 133 */     URL configURL = filenameToURL(vfsRoot, configFile);
/* 134 */     Object configRoot = parse(configURL);
/*     */     CommonConfig config;
/*     */     CommonConfig config;
/* 138 */     if ((configRoot instanceof ConfigRootJAXRPC))
/*     */     {
/* 140 */       config = ((ConfigRootJAXRPC)configRoot).getConfigByName(configName);
/*     */     }
/*     */     else
/*     */     {
/* 144 */       config = ((ConfigRootJAXWS)configRoot).getConfigByName(configName);
/*     */     }
/*     */ 
/* 147 */     if (config == null) {
/* 148 */       throw new WSException("Cannot obtain config: " + configName);
/*     */     }
/* 150 */     return config;
/*     */   }
/*     */ 
/*     */   private URL filenameToURL(UnifiedVirtualFile vfsRoot, String configFile)
/*     */   {
/* 155 */     URL configURL = null;
/*     */     try
/*     */     {
/* 158 */       configURL = vfsRoot.findChild(configFile).toURL();
/*     */     }
/*     */     catch (IOException ex)
/*     */     {
/*     */     }
/*     */ 
/* 166 */     if (configURL == null)
/*     */     {
/*     */       try
/*     */       {
/* 170 */         configURL = new ResourceLoaderAdapter().findChild(configFile).toURL();
/*     */       }
/*     */       catch (IOException ex)
/*     */       {
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 178 */     if (configURL == null) {
/* 179 */       throw new WSException("Cannot find configFile: " + configFile);
/*     */     }
/* 181 */     return configURL;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.config.JBossWSConfigFactory
 * JD-Core Version:    0.6.0
 */