/*     */ package org.jboss.ws.metadata.config.binding;
/*     */ 
/*     */ import java.util.List;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.metadata.config.EndpointProperty;
/*     */ import org.jboss.ws.metadata.config.jaxrpc.ClientConfigJAXRPC;
/*     */ import org.jboss.ws.metadata.config.jaxrpc.CommonConfigJAXRPC;
/*     */ import org.jboss.ws.metadata.config.jaxrpc.ConfigRootJAXRPC;
/*     */ import org.jboss.ws.metadata.config.jaxrpc.EndpointConfigJAXRPC;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
/*     */ import org.jboss.xb.binding.ObjectModelFactory;
/*     */ import org.jboss.xb.binding.UnmarshallingContext;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class OMFactoryJAXRPC
/*     */   implements ObjectModelFactory
/*     */ {
/*  51 */   private final Logger log = Logger.getLogger(OMFactoryJAXRPC.class);
/*     */ 
/*     */   public Object newRoot(Object root, UnmarshallingContext ctx, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  55 */     return new ConfigRootJAXRPC();
/*     */   }
/*     */ 
/*     */   public Object completeRoot(Object root, UnmarshallingContext ctx, String namespaceURI, String localName)
/*     */   {
/*  60 */     return root;
/*     */   }
/*     */ 
/*     */   public Object newChild(ConfigRootJAXRPC config, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  68 */     this.log.trace("WSConfig newChild: " + localName);
/*  69 */     if ("endpoint-config".equals(localName))
/*     */     {
/*  71 */       EndpointConfigJAXRPC wsEndpointConfig = new EndpointConfigJAXRPC();
/*  72 */       config.getEndpointConfig().add(wsEndpointConfig);
/*  73 */       return wsEndpointConfig;
/*     */     }
/*  75 */     if ("client-config".equals(localName))
/*     */     {
/*  77 */       ClientConfigJAXRPC clientConfig = new ClientConfigJAXRPC();
/*  78 */       config.getClientConfig().add(clientConfig);
/*  79 */       return clientConfig;
/*     */     }
/*  81 */     return null;
/*     */   }
/*     */ 
/*     */   public void setValue(CommonConfigJAXRPC commonConfig, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/*  89 */     if (this.log.isTraceEnabled()) {
/*  90 */       this.log.trace("CommonConfig setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */     }
/*  92 */     if (localName.equals("config-name"))
/*  93 */       commonConfig.setConfigName(value);
/*  94 */     if (localName.equals("feature")) {
/*  95 */       commonConfig.setFeature(value, true);
/*     */     }
/*  97 */     if ("property-name".equals(localName))
/*     */     {
/*  99 */       commonConfig.addProperty(value, null);
/*     */     }
/* 101 */     else if ("property-value".equals(localName))
/*     */     {
/* 103 */       int lastEntry = commonConfig.getProperties().isEmpty() ? 0 : commonConfig.getProperties().size() - 1;
/* 104 */       EndpointProperty p = (EndpointProperty)commonConfig.getProperties().get(lastEntry);
/* 105 */       p.value = value;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object newChild(CommonConfigJAXRPC commonConfig, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 114 */     this.log.trace("CommonConfig newChild: " + localName);
/*     */ 
/* 116 */     if ("pre-handler-chain".equals(localName))
/*     */     {
/* 118 */       UnifiedHandlerChainMetaData preHandlerChain = new UnifiedHandlerChainMetaData(null);
/* 119 */       commonConfig.setPreHandlerChain(preHandlerChain);
/* 120 */       return preHandlerChain;
/*     */     }
/* 122 */     if ("post-handler-chain".equals(localName))
/*     */     {
/* 124 */       UnifiedHandlerChainMetaData postHandlerChain = new UnifiedHandlerChainMetaData(null);
/* 125 */       commonConfig.setPostHandlerChain(postHandlerChain);
/* 126 */       return postHandlerChain;
/*     */     }
/* 128 */     return null;
/*     */   }
/*     */ 
/*     */   public Object newChild(UnifiedHandlerChainMetaData UnifiedHandlerChainMetaData, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 136 */     this.log.trace("WSHandlerChainConfig newChild: " + localName);
/* 137 */     if ("handler".equals(localName))
/*     */     {
/* 139 */       UnifiedHandlerMetaData handler = new UnifiedHandlerMetaData(UnifiedHandlerChainMetaData);
/* 140 */       List handlers = UnifiedHandlerChainMetaData.getHandlers();
/* 141 */       handlers.add(handler);
/* 142 */       return handler;
/*     */     }
/* 144 */     return null;
/*     */   }
/*     */ 
/*     */   public Object newChild(UnifiedHandlerMetaData handler, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 152 */     if ("init-param".equals(localName))
/* 153 */       return new UnifiedInitParamMetaData();
/* 154 */     return null;
/*     */   }
/*     */ 
/*     */   public void addChild(UnifiedHandlerMetaData handler, UnifiedInitParamMetaData param, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 162 */     handler.addInitParam(param);
/*     */   }
/*     */ 
/*     */   public void setValue(UnifiedHandlerMetaData handler, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 170 */     if (this.log.isTraceEnabled()) {
/* 171 */       this.log.trace("UnifiedHandlerMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */     }
/* 173 */     if (localName.equals("handler-name"))
/* 174 */       handler.setHandlerName(value);
/* 175 */     else if (localName.equals("handler-class"))
/* 176 */       handler.setHandlerClass(value);
/* 177 */     else if (localName.equals("soap-header"))
/* 178 */       handler.addSoapHeader(navigator.resolveQName(value));
/* 179 */     else if (localName.equals("soap-role"))
/* 180 */       handler.addSoapRole(value);
/* 181 */     else if (localName.equals("port-name"))
/* 182 */       handler.addPortName(value);
/*     */   }
/*     */ 
/*     */   public void setValue(UnifiedInitParamMetaData param, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 190 */     if (this.log.isTraceEnabled()) {
/* 191 */       this.log.trace("UnifiedInitParamMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */     }
/* 193 */     if (localName.equals("param-name"))
/* 194 */       param.setParamName(value);
/* 195 */     else if (localName.equals("param-value"))
/* 196 */       param.setParamValue(value);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.config.binding.OMFactoryJAXRPC
 * JD-Core Version:    0.6.0
 */