/*     */ package org.jboss.ws.metadata.jaxrpcmapping;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import javax.xml.namespace.QName;
/*     */ 
/*     */ public class ExceptionMapping
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 2964098233936811614L;
/*     */   private JavaWsdlMapping javaWsdlMapping;
/*     */   private String exceptionType;
/*     */   private QName wsdlMessage;
/*  50 */   private ArrayList constructorParameterOrder = new ArrayList();
/*     */ 
/*     */   public ExceptionMapping(JavaWsdlMapping javaWsdlMapping)
/*     */   {
/*  54 */     this.javaWsdlMapping = javaWsdlMapping;
/*     */   }
/*     */ 
/*     */   public JavaWsdlMapping getJavaWsdlMapping()
/*     */   {
/*  59 */     return this.javaWsdlMapping;
/*     */   }
/*     */ 
/*     */   public String getExceptionType()
/*     */   {
/*  64 */     return this.exceptionType;
/*     */   }
/*     */ 
/*     */   public void setExceptionType(String exceptionType)
/*     */   {
/*  69 */     this.exceptionType = exceptionType;
/*     */   }
/*     */ 
/*     */   public QName getWsdlMessage()
/*     */   {
/*  74 */     return this.wsdlMessage;
/*     */   }
/*     */ 
/*     */   public void setWsdlMessage(QName wsdlMessage)
/*     */   {
/*  79 */     this.wsdlMessage = wsdlMessage;
/*     */   }
/*     */ 
/*     */   public String[] getConstructorParameterOrder()
/*     */   {
/*  84 */     String[] arr = new String[this.constructorParameterOrder.size()];
/*  85 */     this.constructorParameterOrder.toArray(arr);
/*  86 */     return arr;
/*     */   }
/*     */ 
/*     */   public void addConstructorParameter(String elementName)
/*     */   {
/*  91 */     this.constructorParameterOrder.add(elementName);
/*     */   }
/*     */ 
/*     */   public String serialize()
/*     */   {
/*  96 */     StringBuffer sb = new StringBuffer();
/*  97 */     sb.append("<exception-mapping>");
/*  98 */     sb.append("<exception-type>").append(this.exceptionType).append("</exception-type>");
/*  99 */     sb.append("<wsdl-message xmlns:exMsgNS='").append(this.wsdlMessage.getNamespaceURI()).append("'>");
/* 100 */     sb.append("exMsgNS").append(":").append(this.wsdlMessage.getLocalPart());
/* 101 */     sb.append("</wsdl-message>");
/*     */ 
/* 103 */     if (this.constructorParameterOrder.size() > 0)
/*     */     {
/* 105 */       sb.append("<constructor-parameter-order>");
/* 106 */       for (Iterator i = this.constructorParameterOrder.iterator(); i.hasNext(); )
/* 107 */         sb.append("<element-name>").append(i.next()).append("</element-name>");
/* 108 */       sb.append("</constructor-parameter-order>");
/*     */     }
/* 110 */     sb.append("</exception-mapping>");
/* 111 */     return sb.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.jaxrpcmapping.ExceptionMapping
 * JD-Core Version:    0.6.0
 */