/*     */ package org.jboss.ws.metadata.jaxrpcmapping;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ 
/*     */ public class VariableMapping
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 4168728468137337167L;
/*     */   private JavaXmlTypeMapping typeMapping;
/*     */   private String javaVariableName;
/*     */   private boolean dataMember;
/*     */   private String xmlAttributeName;
/*     */   private String xmlElementName;
/*     */   private boolean xmlWildcard;
/*     */ 
/*     */   public VariableMapping(JavaXmlTypeMapping typeMapping)
/*     */   {
/*  52 */     this.typeMapping = typeMapping;
/*     */   }
/*     */ 
/*     */   public JavaXmlTypeMapping getTypeMapping()
/*     */   {
/*  57 */     return this.typeMapping;
/*     */   }
/*     */ 
/*     */   public boolean isDataMember()
/*     */   {
/*  62 */     return this.dataMember;
/*     */   }
/*     */ 
/*     */   public void setDataMember(boolean dataMember)
/*     */   {
/*  67 */     this.dataMember = dataMember;
/*     */   }
/*     */ 
/*     */   public String getJavaVariableName()
/*     */   {
/*  72 */     return this.javaVariableName;
/*     */   }
/*     */ 
/*     */   public void setJavaVariableName(String javaVariableName)
/*     */   {
/*  77 */     this.javaVariableName = javaVariableName;
/*     */   }
/*     */ 
/*     */   public String getXmlAttributeName()
/*     */   {
/*  82 */     return this.xmlAttributeName;
/*     */   }
/*     */ 
/*     */   public void setXmlAttributeName(String xmlAttributeName)
/*     */   {
/*  87 */     this.xmlAttributeName = xmlAttributeName;
/*     */   }
/*     */ 
/*     */   public String getXmlElementName()
/*     */   {
/*  92 */     return this.xmlElementName;
/*     */   }
/*     */ 
/*     */   public void setXmlElementName(String xmlElementName)
/*     */   {
/*  97 */     this.xmlElementName = xmlElementName;
/*     */   }
/*     */ 
/*     */   public boolean getXmlWildcard()
/*     */   {
/* 102 */     return this.xmlWildcard;
/*     */   }
/*     */ 
/*     */   public void setXmlWildcard(boolean xmlWildcard)
/*     */   {
/* 107 */     this.xmlWildcard = xmlWildcard;
/*     */   }
/*     */ 
/*     */   public String serialize()
/*     */   {
/* 112 */     StringBuffer sb = new StringBuffer();
/* 113 */     sb.append("<variable-mapping>");
/* 114 */     sb.append("<java-variable-name>").append(this.javaVariableName).append("</java-variable-name>");
/* 115 */     if (this.dataMember)
/*     */     {
/* 117 */       sb.append("<data-member/>");
/*     */     }
/* 119 */     if (this.xmlElementName != null)
/*     */     {
/* 121 */       sb.append("<xml-element-name>").append(this.xmlElementName).append("</xml-element-name>");
/*     */     }
/* 123 */     else if (this.xmlAttributeName != null)
/*     */     {
/* 125 */       sb.append("<xml-attribute-name>").append(this.xmlAttributeName).append("</xml-attribute-name>");
/*     */     }
/* 127 */     else if (this.xmlWildcard)
/*     */     {
/* 129 */       sb.append("<xml-wildcard/>");
/*     */     }
/* 131 */     sb.append("</variable-mapping>");
/* 132 */     return sb.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.jaxrpcmapping.VariableMapping
 * JD-Core Version:    0.6.0
 */