/*     */ package org.jboss.ws.metadata.umdm;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.extensions.security.jaxrpc.WSSecurityHandlerInbound;
/*     */ import org.jboss.ws.extensions.security.jaxrpc.WSSecurityHandlerOutbound;
/*     */ import org.jboss.ws.extensions.security.jaxws.WSSecurityHandlerClient;
/*     */ import org.jboss.ws.extensions.security.jaxws.WSSecurityHandlerServer;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
/*     */ 
/*     */ public abstract class HandlerMetaData
/*     */   implements Serializable
/*     */ {
/*  48 */   private final Logger log = Logger.getLogger(HandlerMetaData.class);
/*     */   private transient EndpointMetaData epMetaData;
/*     */   private String handlerName;
/*     */   private String handlerClassName;
/*     */   private UnifiedHandlerMetaData.HandlerType handlerType;
/*  59 */   private Set<QName> soapHeaders = new HashSet();
/*     */ 
/*  61 */   private List<UnifiedInitParamMetaData> initParams = new ArrayList();
/*     */   private Class handlerClass;
/*     */ 
/*     */   public HandlerMetaData(UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/*  67 */     this.handlerType = type;
/*     */   }
/*     */ 
/*     */   public void setEndpointMetaData(EndpointMetaData epMetaData)
/*     */   {
/*  72 */     this.epMetaData = epMetaData;
/*     */   }
/*     */ 
/*     */   public EndpointMetaData getEndpointMetaData()
/*     */   {
/*  77 */     return this.epMetaData;
/*     */   }
/*     */ 
/*     */   public void setHandlerName(String value)
/*     */   {
/*  82 */     this.handlerName = value;
/*     */   }
/*     */ 
/*     */   public String getHandlerName()
/*     */   {
/*  87 */     return this.handlerName;
/*     */   }
/*     */ 
/*     */   public void setHandlerClassName(String handlerClass)
/*     */   {
/*  92 */     this.handlerClassName = handlerClass;
/*     */   }
/*     */ 
/*     */   public String getHandlerClassName()
/*     */   {
/*  97 */     return this.handlerClassName;
/*     */   }
/*     */ 
/*     */   public Class getHandlerClass()
/*     */   {
/* 102 */     if (this.handlerClassName == null) {
/* 103 */       throw new IllegalStateException("Handler class name cannot be null");
/*     */     }
/* 105 */     Class localClass = this.handlerClass;
/* 106 */     if (localClass == null)
/*     */     {
/*     */       try
/*     */       {
/* 110 */         ClassLoader loader = getClassLoader();
/* 111 */         localClass = loader.loadClass(this.handlerClassName);
/*     */       }
/*     */       catch (ClassNotFoundException ex)
/*     */       {
/* 115 */         throw new WSException("Cannot load handler: " + this.handlerClassName, ex);
/*     */       }
/*     */     }
/* 118 */     return localClass;
/*     */   }
/*     */ 
/*     */   private ClassLoader getClassLoader()
/*     */   {
/* 124 */     ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
/* 125 */     return this.epMetaData != null ? this.epMetaData.getClassLoader() : ctxLoader;
/*     */   }
/*     */ 
/*     */   public UnifiedHandlerMetaData.HandlerType getHandlerType()
/*     */   {
/* 130 */     return this.handlerType;
/*     */   }
/*     */ 
/*     */   public void setSoapHeaders(Set<QName> soapHeaders)
/*     */   {
/* 135 */     this.soapHeaders = soapHeaders;
/*     */   }
/*     */ 
/*     */   public Set<QName> getSoapHeaders()
/*     */   {
/* 140 */     return this.soapHeaders;
/*     */   }
/*     */ 
/*     */   public void setInitParams(List<UnifiedInitParamMetaData> initParams)
/*     */   {
/* 145 */     this.initParams = initParams;
/*     */   }
/*     */ 
/*     */   public List<UnifiedInitParamMetaData> getInitParams()
/*     */   {
/* 150 */     return this.initParams;
/*     */   }
/*     */ 
/*     */   public void validate()
/*     */   {
/* 155 */     List securityHandlers = new ArrayList();
/* 156 */     securityHandlers.add(WSSecurityHandlerInbound.class.getName());
/* 157 */     securityHandlers.add(WSSecurityHandlerOutbound.class.getName());
/* 158 */     securityHandlers.add(WSSecurityHandlerServer.class.getName());
/* 159 */     securityHandlers.add(WSSecurityHandlerClient.class.getName());
/*     */ 
/* 161 */     if ((securityHandlers.contains(this.handlerClassName)) && (this.epMetaData != null))
/*     */     {
/* 163 */       if (this.epMetaData.getServiceMetaData().getSecurityConfiguration() == null)
/* 164 */         this.log.warn("WS-Security requires security configuration");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void eagerInitialize()
/*     */   {
/* 170 */     this.handlerClass = getHandlerClass();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.umdm.HandlerMetaData
 * JD-Core Version:    0.6.0
 */