/*     */ package org.jboss.ws.metadata.umdm;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.StringTokenizer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
/*     */ 
/*     */ public class UnifiedMetaData
/*     */ {
/*  54 */   private static Logger log = Logger.getLogger(UnifiedMetaData.class);
/*     */   private String deploymentName;
/*     */   private ClassLoader classLoader;
/*     */   private UnifiedVirtualFile vfsRoot;
/*     */   private String securityDomain;
/*     */   private static String implementationVersion;
/*     */   private static boolean isFinalRelease;
/*  70 */   Map<String, WSDLDefinitions> wsdlMap = new HashMap();
/*     */ 
/*  73 */   Map<String, JavaWsdlMapping> jaxrpcMap = new HashMap();
/*     */ 
/*  75 */   private List<ServiceMetaData> services = new ArrayList();
/*     */   private boolean eagerInitialized;
/*     */   private boolean validated;
/*     */ 
/*     */   public UnifiedMetaData(UnifiedVirtualFile vfsRoot)
/*     */   {
/*  83 */     if (vfsRoot == null) {
/*  84 */       throw new IllegalArgumentException("VFS root cannot be null");
/*     */     }
/*  86 */     this.vfsRoot = vfsRoot;
/*  87 */     this.classLoader = Thread.currentThread().getContextClassLoader();
/*     */   }
/*     */ 
/*     */   public ClassLoader getClassLoader()
/*     */   {
/*  92 */     if (this.classLoader == null) {
/*  93 */       throw new IllegalStateException("Class loader not available");
/*     */     }
/*  95 */     return this.classLoader;
/*     */   }
/*     */ 
/*     */   public void setRootFile(UnifiedVirtualFile vfsRoot)
/*     */   {
/* 100 */     this.vfsRoot = vfsRoot;
/*     */   }
/*     */ 
/*     */   public UnifiedVirtualFile getRootFile()
/*     */   {
/* 105 */     return this.vfsRoot;
/*     */   }
/*     */ 
/*     */   public void setClassLoader(ClassLoader classLoader)
/*     */   {
/* 110 */     this.classLoader = classLoader;
/*     */   }
/*     */ 
/*     */   public String getDeploymentName()
/*     */   {
/* 115 */     return this.deploymentName;
/*     */   }
/*     */ 
/*     */   public void setDeploymentName(String deploymentName)
/*     */   {
/* 120 */     this.deploymentName = deploymentName;
/*     */   }
/*     */ 
/*     */   public String getSecurityDomain()
/*     */   {
/* 125 */     return this.securityDomain;
/*     */   }
/*     */ 
/*     */   public void setSecurityDomain(String domain)
/*     */   {
/* 130 */     String prefix = "java:/jaas/";
/* 131 */     if ((domain != null) && (domain.startsWith(prefix))) {
/* 132 */       domain = domain.substring(prefix.length());
/*     */     }
/* 134 */     this.securityDomain = domain;
/*     */   }
/*     */ 
/*     */   public List<ServiceMetaData> getServices()
/*     */   {
/* 139 */     return new ArrayList(this.services);
/*     */   }
/*     */ 
/*     */   public void addService(ServiceMetaData serviceMetaData)
/*     */   {
/* 144 */     this.services.add(serviceMetaData);
/*     */   }
/*     */ 
/*     */   public void addWsdlDefinition(String wsdlFile, WSDLDefinitions wsdlDefinitions)
/*     */   {
/* 149 */     this.wsdlMap.put(wsdlFile, wsdlDefinitions);
/*     */   }
/*     */ 
/*     */   public WSDLDefinitions getWsdlDefinition(String wsdlFile)
/*     */   {
/* 154 */     return (WSDLDefinitions)this.wsdlMap.get(wsdlFile);
/*     */   }
/*     */ 
/*     */   public void addMappingDefinition(String jaxrpcFile, JavaWsdlMapping javaWsdlMapping)
/*     */   {
/* 159 */     this.jaxrpcMap.put(jaxrpcFile, javaWsdlMapping);
/*     */   }
/*     */ 
/*     */   public JavaWsdlMapping getMappingDefinition(String jaxrpcFile)
/*     */   {
/* 164 */     return (JavaWsdlMapping)this.jaxrpcMap.get(jaxrpcFile);
/*     */   }
/*     */ 
/*     */   public void validate()
/*     */   {
/* 169 */     if (!this.validated)
/*     */     {
/* 171 */       for (ServiceMetaData service : this.services)
/*     */       {
/* 173 */         service.validate();
/*     */       }
/* 175 */       this.validated = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isEagerInitialized()
/*     */   {
/* 181 */     return this.eagerInitialized;
/*     */   }
/*     */ 
/*     */   public synchronized void eagerInitialize()
/*     */   {
/* 191 */     if (!this.eagerInitialized)
/*     */     {
/* 193 */       log.debug("Eagerly initialize the meta data model");
/* 194 */       for (ServiceMetaData service : this.services)
/*     */       {
/* 196 */         service.eagerInitialize();
/*     */       }
/* 198 */       this.eagerInitialized = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static String getImplementationVersion()
/*     */   {
/* 204 */     if (implementationVersion == null)
/*     */     {
/* 206 */       implementationVersion = UnifiedMetaData.class.getPackage().getImplementationVersion();
/* 207 */       if (implementationVersion != null)
/* 208 */         isFinalRelease = new StringTokenizer(implementationVersion).nextToken().endsWith(".GA");
/*     */     }
/* 210 */     return implementationVersion;
/*     */   }
/*     */ 
/*     */   public static boolean isFinalRelease()
/*     */   {
/* 215 */     getImplementationVersion();
/* 216 */     return isFinalRelease;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 221 */     StringBuilder buffer = new StringBuilder("\nUnifiedMetaData: ");
/* 222 */     buffer.append("\n implementation: " + getImplementationVersion());
/* 223 */     buffer.append("\n deploymentName: " + getDeploymentName());
/* 224 */     buffer.append("\n securityDomain: " + getSecurityDomain());
/*     */ 
/* 227 */     buffer.append("\n");
/*     */ 
/* 229 */     for (ServiceMetaData serviceMetaData : this.services)
/*     */     {
/* 231 */       buffer.append(serviceMetaData);
/*     */     }
/* 233 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.umdm.UnifiedMetaData
 * JD-Core Version:    0.6.0
 */