/*     */ package org.jboss.ws.metadata.wsdl;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.Map;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.ws.WSException;
/*     */ 
/*     */ public class WSDLInterfaceOperation extends Extendable
/*     */   implements Comparable
/*     */ {
/*     */   private static final long serialVersionUID = -5014918078197942626L;
/*     */   private WSDLInterface wsdlInterface;
/*     */   private final QName name;
/*     */   private String pattern;
/*  65 */   private String style = "http://www.w3.org/2004/03/wsdl/style/rpc";
/*     */   private boolean safe;
/*  72 */   private Map<QName, WSDLInterfaceOperationInput> inputs = new LinkedHashMap();
/*     */ 
/*  74 */   private Map<QName, WSDLInterfaceOperationOutput> outputs = new LinkedHashMap();
/*     */ 
/*  76 */   private ArrayList<WSDLInterfaceOperationInfault> infaults = new ArrayList();
/*     */ 
/*  78 */   private ArrayList<WSDLInterfaceOperationOutfault> outfaults = new ArrayList();
/*     */ 
/*  80 */   private LinkedHashMap<String, WSDLRPCSignatureItem> rpcSignatureItems = new LinkedHashMap();
/*     */ 
/*     */   public WSDLInterfaceOperation(WSDLInterface wsdlInterface, QName name)
/*     */   {
/*  84 */     this.name = name;
/*  85 */     this.wsdlInterface = wsdlInterface;
/*     */   }
/*     */ 
/*     */   public WSDLInterfaceOperation(WSDLInterface wsdlInterface, String localName)
/*     */   {
/*  90 */     this.wsdlInterface = wsdlInterface;
/*  91 */     this.name = new QName(wsdlInterface.getName().getNamespaceURI(), localName);
/*     */   }
/*     */ 
/*     */   public WSDLInterface getWsdlInterface()
/*     */   {
/*  96 */     return this.wsdlInterface;
/*     */   }
/*     */ 
/*     */   public QName getName()
/*     */   {
/* 101 */     return this.name;
/*     */   }
/*     */ 
/*     */   public String getPattern()
/*     */   {
/* 106 */     return this.pattern;
/*     */   }
/*     */ 
/*     */   public void setPattern(String pattern)
/*     */   {
/* 111 */     this.pattern = pattern;
/*     */   }
/*     */ 
/*     */   public String getStyle()
/*     */   {
/* 116 */     return this.style;
/*     */   }
/*     */ 
/*     */   public void setStyle(String style)
/*     */   {
/* 121 */     this.style = style;
/*     */   }
/*     */ 
/*     */   public boolean isSafe()
/*     */   {
/* 126 */     return this.safe;
/*     */   }
/*     */ 
/*     */   public void setSafe(boolean safe)
/*     */   {
/* 131 */     this.safe = safe;
/*     */   }
/*     */ 
/*     */   public WSDLInterfaceOperationInput[] getInputs()
/*     */   {
/* 136 */     WSDLInterfaceOperationInput[] arr = new WSDLInterfaceOperationInput[this.inputs.size()];
/* 137 */     new ArrayList(this.inputs.values()).toArray(arr);
/* 138 */     return arr;
/*     */   }
/*     */ 
/*     */   public void addInput(WSDLInterfaceOperationInput input)
/*     */   {
/* 143 */     QName xmlName = input.getElement();
/* 144 */     if (this.inputs.get(xmlName) != null)
/* 145 */       throw new WSException("Attempt to map multiple operation inputs to: " + xmlName);
/* 146 */     this.inputs.put(xmlName, input);
/*     */   }
/*     */ 
/*     */   public WSDLInterfaceOperationInput getInput(QName qname)
/*     */   {
/* 151 */     WSDLInterfaceOperationInput opInput = (WSDLInterfaceOperationInput)this.inputs.get(qname);
/* 152 */     return opInput;
/*     */   }
/*     */ 
/*     */   public void removeInput(QName element)
/*     */   {
/* 157 */     this.inputs.remove(element);
/*     */   }
/*     */ 
/*     */   public WSDLInterfaceOperationInput getInputByPartName(String partName)
/*     */   {
/* 162 */     WSDLInterfaceOperationInput opInput = null;
/* 163 */     for (WSDLInterfaceOperationInput auxInput : this.inputs.values())
/*     */     {
/* 165 */       WSDLProperty property = auxInput.getProperty("http://www.jboss.org/jbossws/partname");
/* 166 */       if ((property != null) && (property.getValue().equals(partName)))
/* 167 */         opInput = auxInput;
/*     */     }
/* 169 */     return opInput;
/*     */   }
/*     */ 
/*     */   public WSDLInterfaceOperationOutput[] getOutputs()
/*     */   {
/* 174 */     WSDLInterfaceOperationOutput[] arr = new WSDLInterfaceOperationOutput[this.outputs.size()];
/* 175 */     new ArrayList(this.outputs.values()).toArray(arr);
/* 176 */     return arr;
/*     */   }
/*     */ 
/*     */   public void addOutput(WSDLInterfaceOperationOutput output)
/*     */   {
/* 181 */     QName xmlName = output.getElement();
/* 182 */     if (this.outputs.get(xmlName) != null)
/* 183 */       throw new WSException("Attempt to map multiple operation outputs to: " + xmlName);
/* 184 */     this.outputs.put(xmlName, output);
/*     */   }
/*     */ 
/*     */   public WSDLInterfaceOperationOutput getOutput(QName qname)
/*     */   {
/* 189 */     WSDLInterfaceOperationOutput opOutput = (WSDLInterfaceOperationOutput)this.outputs.get(qname);
/* 190 */     return opOutput;
/*     */   }
/*     */ 
/*     */   public void removeOutput(QName element)
/*     */   {
/* 195 */     this.outputs.remove(element);
/*     */   }
/*     */ 
/*     */   public WSDLInterfaceOperationOutput getOutputByPartName(String partName)
/*     */   {
/* 200 */     WSDLInterfaceOperationOutput opOutput = null;
/* 201 */     for (WSDLInterfaceOperationOutput auxOutput : this.outputs.values())
/*     */     {
/* 203 */       WSDLProperty property = auxOutput.getProperty("http://www.jboss.org/jbossws/partname");
/* 204 */       if ((property != null) && (property.getValue().equals(partName)))
/* 205 */         opOutput = auxOutput;
/*     */     }
/* 207 */     return opOutput;
/*     */   }
/*     */ 
/*     */   public WSDLInterfaceOperationInfault[] getInfaults()
/*     */   {
/* 212 */     WSDLInterfaceOperationInfault[] arr = new WSDLInterfaceOperationInfault[this.infaults.size()];
/* 213 */     this.infaults.toArray(arr);
/* 214 */     return arr;
/*     */   }
/*     */ 
/*     */   public void addInfault(WSDLInterfaceOperationInfault infault)
/*     */   {
/* 219 */     this.infaults.add(infault);
/*     */   }
/*     */ 
/*     */   public WSDLInterfaceOperationOutfault[] getOutfaults()
/*     */   {
/* 224 */     WSDLInterfaceOperationOutfault[] arr = new WSDLInterfaceOperationOutfault[this.outfaults.size()];
/* 225 */     this.outfaults.toArray(arr);
/* 226 */     return arr;
/*     */   }
/*     */ 
/*     */   public void addOutfault(WSDLInterfaceOperationOutfault outfault)
/*     */   {
/* 231 */     this.outfaults.add(outfault);
/*     */   }
/*     */ 
/*     */   public Collection<WSDLRPCSignatureItem> getRpcSignatureItems()
/*     */   {
/* 236 */     return this.rpcSignatureItems.values();
/*     */   }
/*     */ 
/*     */   public void addRpcSignatureItem(WSDLRPCSignatureItem item)
/*     */   {
/* 242 */     if (item.getDirection() != WSDLRPCSignatureItem.Direction.RETURN)
/* 243 */       item.setPosition(this.rpcSignatureItems.size());
/* 244 */     this.rpcSignatureItems.put(item.getName(), item);
/*     */   }
/*     */ 
/*     */   public WSDLRPCSignatureItem getRpcSignatureitem(String name)
/*     */   {
/* 249 */     return (WSDLRPCSignatureItem)this.rpcSignatureItems.get(name);
/*     */   }
/*     */ 
/*     */   public WSDLBindingOperation getBindingOperation()
/*     */   {
/* 259 */     WSDLInterface wsdlInterface = getWsdlInterface();
/* 260 */     WSDLBinding binding = wsdlInterface.getWsdlDefinitions().getBindingByInterfaceName(wsdlInterface.getName());
/* 261 */     if (binding == null) {
/* 262 */       return null;
/*     */     }
/* 264 */     WSDLBindingOperation bindingOperation = binding.getOperationByRef(getName());
/* 265 */     return bindingOperation;
/*     */   }
/*     */ 
/*     */   public int compareTo(Object o)
/*     */   {
/* 270 */     int c = -1;
/* 271 */     if ((o instanceof WSDLInterfaceOperation))
/*     */     {
/* 273 */       WSDLInterfaceOperation w = (WSDLInterfaceOperation)o;
/* 274 */       String oname = w.getName().getLocalPart();
/* 275 */       String myname = this.name.getLocalPart();
/* 276 */       c = myname.compareTo(oname);
/*     */     }
/* 278 */     return c;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation
 * JD-Core Version:    0.6.0
 */