/*     */ package org.jboss.ws.metadata.wsdl;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.math.BigDecimal;
/*     */ import java.math.BigInteger;
/*     */ import java.net.URI;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Calendar;
/*     */ import java.util.Date;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Stack;
/*     */ import java.util.StringTokenizer;
/*     */ import javax.ejb.SessionBean;
/*     */ import javax.jws.WebMethod;
/*     */ import javax.jws.WebService;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.holders.BigDecimalHolder;
/*     */ import javax.xml.rpc.holders.BigIntegerHolder;
/*     */ import javax.xml.rpc.holders.BooleanHolder;
/*     */ import javax.xml.rpc.holders.BooleanWrapperHolder;
/*     */ import javax.xml.rpc.holders.ByteArrayHolder;
/*     */ import javax.xml.rpc.holders.ByteHolder;
/*     */ import javax.xml.rpc.holders.ByteWrapperHolder;
/*     */ import javax.xml.rpc.holders.CalendarHolder;
/*     */ import javax.xml.rpc.holders.DoubleHolder;
/*     */ import javax.xml.rpc.holders.DoubleWrapperHolder;
/*     */ import javax.xml.rpc.holders.FloatHolder;
/*     */ import javax.xml.rpc.holders.FloatWrapperHolder;
/*     */ import javax.xml.rpc.holders.Holder;
/*     */ import javax.xml.rpc.holders.IntHolder;
/*     */ import javax.xml.rpc.holders.IntegerWrapperHolder;
/*     */ import javax.xml.rpc.holders.LongHolder;
/*     */ import javax.xml.rpc.holders.LongWrapperHolder;
/*     */ import javax.xml.rpc.holders.ObjectHolder;
/*     */ import javax.xml.rpc.holders.QNameHolder;
/*     */ import javax.xml.rpc.holders.ShortHolder;
/*     */ import javax.xml.rpc.holders.ShortWrapperHolder;
/*     */ import javax.xml.rpc.holders.StringHolder;
/*     */ import org.apache.xerces.xs.XSComplexTypeDefinition;
/*     */ import org.apache.xerces.xs.XSTypeDefinition;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.jaxrpc.ParameterWrapping.WrapperType;
/*     */ import org.jboss.ws.core.utils.HolderUtils;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ import org.jboss.xb.binding.Util;
/*     */ 
/*     */ public class WSDLUtils
/*     */ {
/*  87 */   private String newline = "\n";
/*  88 */   private static WSDLUtils instance = new WSDLUtils();
/*     */ 
/*  90 */   private List wrapperlist = null;
/*  91 */   private List primlist = null;
/*     */ 
/*  93 */   private final Map primitiveMap = new HashMap();
/*     */ 
/*  95 */   private static final Map<String, Class> schemaBasicTypes = new HashMap();
/*     */ 
/*  97 */   private static final Map<Class, Class> holderTypes = new HashMap();
/*  98 */   private static final Map<Class, Class> reverseHolderTypes = new HashMap();
/*     */   private List<String> ignoredMethods;
/*     */ 
/*     */   public static WSDLUtils getInstance()
/*     */   {
/* 176 */     return instance;
/*     */   }
/*     */ 
/*     */   private WSDLUtils()
/*     */   {
/* 181 */     this.wrapperlist = new ArrayList();
/* 182 */     this.primlist = new ArrayList();
/* 183 */     populatePrimList();
/* 184 */     populateWrapperList();
/* 185 */     createPrimitiveMap();
/*     */   }
/*     */ 
/*     */   public boolean isPrimitive(String str)
/*     */   {
/* 195 */     return this.primlist.contains(str);
/*     */   }
/*     */ 
/*     */   public boolean isWrapper(String str)
/*     */   {
/* 205 */     return this.wrapperlist.contains(str);
/*     */   }
/*     */ 
/*     */   public boolean isBaseTypeIgnorable(XSTypeDefinition baseType, XSComplexTypeDefinition t)
/*     */   {
/* 217 */     boolean bool = false;
/*     */ 
/* 220 */     if (baseType != null)
/*     */     {
/* 222 */       if ((baseType.getNamespace() == "http://www.w3.org/2001/XMLSchema") && (baseType.getName().equals("anyType")))
/* 223 */         bool = true;
/*     */     }
/* 225 */     if (1 == t.getContentType())
/*     */     {
/* 227 */       bool = true;
/*     */     }
/*     */ 
/* 230 */     return bool;
/*     */   }
/*     */ 
/*     */   public boolean checkIgnoreClass(Class cls)
/*     */   {
/* 241 */     if (cls == null) {
/* 242 */       throw new IllegalArgumentException("Illegal null argument:cls");
/*     */     }
/* 244 */     if (!cls.isArray())
/*     */     {
/* 246 */       String pkgname = cls.getPackage() != null ? cls.getPackage().getName() : null;
/* 247 */       if ((pkgname != null) && (pkgname.startsWith("java"))) {
/* 248 */         return true;
/*     */       }
/* 250 */       if (ParameterWrapping.WrapperType.class.isAssignableFrom(cls)) {
/* 251 */         return true;
/*     */       }
/*     */     }
/* 254 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean checkIgnoreMethod(Method method)
/*     */   {
/* 261 */     String methodname = method.getName();
/* 262 */     if (this.ignoredMethods == null)
/*     */     {
/* 264 */       this.ignoredMethods = new ArrayList();
/* 265 */       Method[] objMethods = Object.class.getMethods();
/* 266 */       for (int i = 0; i < objMethods.length; i++)
/*     */       {
/* 268 */         this.ignoredMethods.add(objMethods[i].getName());
/*     */       }
/*     */ 
/* 271 */       Method[] sbMethods = SessionBean.class.getMethods();
/* 272 */       for (int i = 0; i < sbMethods.length; i++)
/*     */       {
/* 274 */         this.ignoredMethods.add(sbMethods[i].getName());
/*     */       }
/*     */     }
/*     */ 
/* 278 */     boolean ignoreMethod = this.ignoredMethods.contains(methodname);
/*     */ 
/* 281 */     if ((method.getDeclaringClass().isAnnotationPresent(WebService.class)) && (!method.isAnnotationPresent(WebMethod.class))) {
/* 282 */       ignoreMethod = true;
/*     */     }
/* 284 */     return ignoreMethod;
/*     */   }
/*     */ 
/*     */   public String chopPortType(String name)
/*     */   {
/* 294 */     int index = name.lastIndexOf("PortType");
/* 295 */     if (index > 0) {
/* 296 */       return name.substring(0, index);
/*     */     }
/* 298 */     return name;
/*     */   }
/*     */ 
/*     */   public String chop(String name, String chopstr)
/*     */   {
/* 309 */     int index = name.lastIndexOf(chopstr);
/* 310 */     if (index > 0) {
/* 311 */       return name.substring(0, index);
/*     */     }
/* 313 */     return name;
/*     */   }
/*     */ 
/*     */   public File createPackage(String path, String packageName)
/*     */   {
/* 322 */     if (packageName == null)
/* 323 */       throw new IllegalArgumentException("Illegal Null Argument: packageName");
/* 324 */     if (path == null)
/* 325 */       throw new IllegalArgumentException("Illegal Null Argument: path");
/* 326 */     String pac = packageName.replace('.', '/');
/* 327 */     File dir = new File(path + "/" + pac);
/* 328 */     dir.mkdirs();
/* 329 */     return dir;
/*     */   }
/*     */ 
/*     */   public File createPhysicalFile(File loc, String fname)
/*     */     throws IOException
/*     */   {
/* 341 */     if (loc == null)
/* 342 */       throw new IllegalArgumentException("Illegal Null Argument: loc");
/* 343 */     if (fname == null)
/* 344 */       throw new IllegalArgumentException("Illegal Null Argument: fname");
/* 345 */     File javaFile = new File(loc.getAbsolutePath() + "/" + fname + ".java");
/*     */ 
/* 347 */     if (javaFile.exists())
/* 348 */       javaFile.delete();
/* 349 */     boolean boolCreate = javaFile.createNewFile();
/* 350 */     if (!boolCreate)
/* 351 */       throw new WSException(fname + ".java cannot be created");
/* 352 */     return javaFile;
/*     */   }
/*     */ 
/*     */   public StringBuilder createClassBasicStructure(String pkgname, String fname, XSTypeDefinition type, List importList, String baseName)
/*     */   {
/* 365 */     StringBuilder buf = new StringBuilder();
/* 366 */     writeJbossHeader(buf);
/* 367 */     buf.append(this.newline);
/* 368 */     buf.append("package " + pkgname + ";");
/* 369 */     buf.append(this.newline);
/* 370 */     buf.append(this.newline);
/* 371 */     if (importList != null)
/*     */     {
/* 373 */       Iterator iter = importList.iterator();
/* 374 */       while (iter.hasNext())
/*     */       {
/* 376 */         buf.append("import " + (String)iter.next() + ";");
/* 377 */         buf.append(this.newline);
/*     */       }
/*     */     }
/* 380 */     buf.append(this.newline);
/* 381 */     XSTypeDefinition baseType = null;
/* 382 */     if ((type instanceof XSComplexTypeDefinition))
/*     */     {
/* 384 */       XSComplexTypeDefinition t = (XSComplexTypeDefinition)type;
/*     */ 
/* 386 */       baseType = t.getBaseType();
/*     */ 
/* 388 */       if (baseType != null)
/*     */       {
/* 390 */         if ((baseType.getNamespace() == "http://www.w3.org/2001/XMLSchema") && (baseType.getName().equals("anyType")))
/* 391 */           baseType = null;
/*     */       }
/* 393 */       if (1 == t.getContentType())
/*     */       {
/* 395 */         baseType = null;
/*     */       }
/*     */     }
/*     */ 
/* 399 */     buf.append("public class  " + fname);
/* 400 */     if ((baseName == null) && (baseType != null))
/* 401 */       baseName = baseType.getName();
/* 402 */     if (baseName != null)
/* 403 */       buf.append(" extends " + baseName);
/* 404 */     buf.append(this.newline);
/* 405 */     buf.append("{");
/* 406 */     buf.append(this.newline);
/*     */ 
/* 408 */     return buf;
/*     */   }
/*     */ 
/*     */   public boolean doesPublicFieldExist(Class javaType, String name)
/*     */   {
/* 419 */     Field fld = null;
/*     */     try
/*     */     {
/* 422 */       fld = javaType.getField(name);
/*     */     }
/*     */     catch (SecurityException e)
/*     */     {
/* 426 */       throw e;
/*     */     }
/*     */     catch (NoSuchFieldException e)
/*     */     {
/* 430 */       return false;
/*     */     }
/* 432 */     int mod = fld.getModifiers();
/*     */ 
/* 434 */     return mod == 1;
/*     */   }
/*     */ 
/*     */   public String firstLetterUpperCase(String fname)
/*     */   {
/* 445 */     if ((fname == "") || (fname == null)) {
/* 446 */       throw new WSException("String passed is null");
/*     */     }
/* 448 */     if (Character.isLowerCase(fname.charAt(0)))
/*     */     {
/* 450 */       char[] chars = fname.toCharArray();
/* 451 */       char f = Character.toUpperCase(chars[0]);
/* 452 */       chars[0] = f;
/* 453 */       fname = new String(chars);
/*     */     }
/* 455 */     return fname;
/*     */   }
/*     */ 
/*     */   public int getArrayDimension(Class arr)
/*     */   {
/* 465 */     if ((arr == null) || (!arr.isArray()))
/* 466 */       throw new IllegalArgumentException("Illegal null or array arg:arr");
/* 467 */     int counter = 0;
/* 468 */     while (arr.isArray())
/*     */     {
/* 470 */       counter++;
/* 471 */       arr = arr.getComponentType();
/*     */     }
/* 473 */     return counter;
/*     */   }
/*     */ 
/*     */   public Class getHolder(Class cls)
/*     */   {
/* 484 */     return (Class)holderTypes.get(cls);
/*     */   }
/*     */ 
/*     */   public Class getJavaTypeForHolder(Class cls)
/*     */   {
/* 495 */     if (Holder.class.isAssignableFrom(cls))
/* 496 */       return HolderUtils.getValueType(cls);
/* 497 */     return cls;
/*     */   }
/*     */ 
/*     */   public String getMessagePartForArray(Class javaType)
/*     */   {
/* 510 */     StringBuilder sb = new StringBuilder();
/* 511 */     while (javaType.isArray())
/*     */     {
/* 513 */       sb.append("arrayOf");
/* 514 */       javaType = javaType.getComponentType();
/*     */     }
/*     */ 
/* 517 */     sb.append(getJustClassName(javaType));
/* 518 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public static String getJustClassName(Class cls)
/*     */   {
/* 530 */     if (cls == null)
/* 531 */       return null;
/* 532 */     if (cls.isArray())
/*     */     {
/* 534 */       Class c = cls.getComponentType();
/* 535 */       return getJustClassName(c.getName());
/*     */     }
/*     */ 
/* 538 */     return getJustClassName(cls.getName());
/*     */   }
/*     */ 
/*     */   public static String getJustClassName(String classname)
/*     */   {
/* 549 */     int index = classname.lastIndexOf(".");
/* 550 */     if (index < 0)
/* 551 */       index = 0;
/* 552 */     else index += 1;
/* 553 */     return classname.substring(index);
/*     */   }
/*     */ 
/*     */   public Field[] getPublicFields(Class cls)
/*     */   {
/* 562 */     ArrayList list = new ArrayList();
/*     */ 
/* 564 */     Field[] fld = cls.getDeclaredFields();
/* 565 */     for (int i = 0; i < fld.length; i++)
/*     */     {
/* 567 */       Field field = fld[i];
/* 568 */       int mod = field.getModifiers();
/* 569 */       if (mod == 1) {
/* 570 */         list.add(field);
/*     */       }
/*     */     }
/* 573 */     Field[] retarr = new Field[list.size()];
/* 574 */     list.toArray(retarr);
/*     */ 
/* 576 */     return retarr;
/*     */   }
/*     */ 
/*     */   public Method[] getPublicProtectedMethods(Method[] methods)
/*     */   {
/* 588 */     ArrayList list = new ArrayList();
/* 589 */     int len = methods.length;
/*     */ 
/* 591 */     for (int i = 0; i < len; i++)
/*     */     {
/* 593 */       Method method = methods[i];
/* 594 */       int mod = method.getModifiers();
/* 595 */       if ((mod == 1) || (mod == 4)) {
/* 596 */         list.add(method);
/*     */       }
/*     */     }
/* 599 */     Method[] retarr = new Method[list.size()];
/* 600 */     list.toArray(retarr);
/* 601 */     return retarr;
/*     */   }
/*     */ 
/*     */   public Class getJavaType(QName xmlType)
/*     */   {
/* 613 */     if (xmlType == null)
/* 614 */       return null;
/* 615 */     String localPart = xmlType.getLocalPart();
/* 616 */     return (Class)schemaBasicTypes.get(localPart);
/*     */   }
/*     */ 
/*     */   public String getMixedCase(String str)
/*     */   {
/* 626 */     if ((str == null) || (str.length() == 0)) {
/* 627 */       throw new IllegalArgumentException("String passed to WSDLUtils.getMixedCase is null");
/*     */     }
/* 629 */     if (str.length() == 1)
/* 630 */       return str.toUpperCase();
/* 631 */     char[] charr = str.toCharArray();
/* 632 */     charr[0] = Character.toUpperCase(charr[0]);
/* 633 */     return new String(charr);
/*     */   }
/*     */ 
/*     */   public String getFormattedString(QName qn)
/*     */   {
/* 643 */     if (qn == null)
/* 644 */       throw new IllegalArgumentException(" QName passed is null");
/* 645 */     StringBuilder sb = new StringBuilder();
/* 646 */     String prefix = qn.getPrefix();
/* 647 */     String localpart = qn.getLocalPart();
/* 648 */     if ((prefix == null) || (prefix == ""))
/* 649 */       prefix = "tns";
/* 650 */     sb.append(prefix + ":");
/* 651 */     sb.append(localpart);
/*     */ 
/* 653 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public QName getQName(String formattedStr)
/*     */   {
/* 663 */     QName qn = null;
/* 664 */     int ind = formattedStr.lastIndexOf(":");
/* 665 */     if (ind < 0)
/* 666 */       throw new IllegalArgumentException("Formatted String is not of format prefix:localpart");
/* 667 */     String prefix = formattedStr.substring(0, ind);
/* 668 */     String nsuri = null;
/* 669 */     if ("xsd".equals(prefix))
/* 670 */       nsuri = "http://www.w3.org/2001/XMLSchema";
/* 671 */     if (nsuri == null)
/* 672 */       qn = new QName(formattedStr.substring(ind + 1));
/* 673 */     else qn = new QName(nsuri, formattedStr.substring(ind + 1), prefix);
/* 674 */     return qn;
/*     */   }
/*     */ 
/*     */   public String getPrimitive(String str)
/*     */   {
/* 684 */     return (String)this.primitiveMap.get(str);
/*     */   }
/*     */ 
/*     */   public String getPackageName(String typeNS)
/*     */   {
/* 694 */     String pkgname = Util.xmlNamespaceToJavaPackage(typeNS);
/* 695 */     return pkgname;
/*     */   }
/*     */ 
/*     */   public static String getTypeNamespace(Class javaType)
/*     */   {
/* 700 */     return getTypeNamespace(JavaUtils.getPackageName(javaType));
/*     */   }
/*     */ 
/*     */   public static String getTypeNamespace(String packageName)
/*     */   {
/* 709 */     StringBuilder sb = new StringBuilder("http://");
/*     */ 
/* 712 */     StringTokenizer st = new StringTokenizer(packageName, ".");
/*     */ 
/* 715 */     Stack stk = new Stack();
/* 716 */     while ((st != null) && (st.hasMoreTokens()))
/*     */     {
/* 718 */       stk.push(st.nextToken());
/*     */     }
/*     */     String next;
/* 722 */     while ((!stk.isEmpty()) && ((next = (String)stk.pop()) != null))
/*     */     {
/* 724 */       if (!sb.toString().equals("http://"))
/* 725 */         sb.append(".");
/* 726 */       sb.append(next);
/*     */     }
/*     */ 
/* 730 */     sb.append("/");
/*     */ 
/* 732 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public String getWSDLStyle(WSDLDefinitions wsdl)
/*     */   {
/* 743 */     WSDLInterface wi = wsdl.getInterfaces()[0];
/* 744 */     WSDLInterfaceOperation wio = wi.getOperations()[0];
/* 745 */     String style = wio.getStyle();
/* 746 */     if ((style == null) || (style.equals("http://www.w3.org/2004/03/wsdl/style/rpc")) || ("rpc".equalsIgnoreCase(style)))
/* 747 */       return "RPC/Literal";
/* 748 */     return "Document/Literal";
/*     */   }
/*     */ 
/*     */   public static JBossXSModel getSchemaModel(WSDLTypes types)
/*     */   {
/* 753 */     if ((types instanceof XSModelTypes)) {
/* 754 */       return ((XSModelTypes)types).getSchemaModel();
/*     */     }
/* 756 */     throw new WSException("WSDLTypes is not an XSModelTypes");
/*     */   }
/*     */ 
/*     */   public static void addSchemaModel(WSDLTypes types, String namespace, JBossXSModel model)
/*     */   {
/* 761 */     if (!(types instanceof XSModelTypes)) {
/* 762 */       throw new WSException("WSDLTypes is not an XSModelTypes");
/*     */     }
/* 764 */     XSModelTypes modelTypes = (XSModelTypes)types;
/* 765 */     modelTypes.addSchemaModel(namespace, model);
/*     */   }
/*     */ 
/*     */   public boolean isStandardHolder(Class cls)
/*     */   {
/* 776 */     if (!Holder.class.isAssignableFrom(cls)) {
/* 777 */       return false;
/*     */     }
/*     */ 
/* 780 */     return cls.getPackage().getName().startsWith("javax.xml.rpc");
/*     */   }
/*     */ 
/*     */   public void writeJbossHeader(StringBuilder buf)
/*     */   {
/* 790 */     buf.append("/*").append(this.newline);
/* 791 */     buf.append(" * JBossWS WS-Tools Generated Source").append(this.newline);
/* 792 */     buf.append(" *").append(this.newline);
/* 793 */     buf.append(" * Generation Date: " + new Date() + this.newline);
/* 794 */     buf.append(" *").append(this.newline);
/* 795 */     buf.append(" * This generated source code represents a derivative work of the input to").append(this.newline);
/* 796 */     buf.append(" * the generator that produced it. Consult the input for the copyright and").append(this.newline);
/* 797 */     buf.append(" * terms of use that apply to this source code.").append(this.newline);
/* 798 */     buf.append(" */").append(this.newline);
/*     */   }
/*     */ 
/*     */   protected void populatePrimList()
/*     */   {
/* 803 */     this.primlist.add("int");
/* 804 */     this.primlist.add("boolean");
/* 805 */     this.primlist.add("short");
/* 806 */     this.primlist.add("byte");
/* 807 */     this.primlist.add("long");
/* 808 */     this.primlist.add("float");
/* 809 */     this.primlist.add("double");
/*     */   }
/*     */ 
/*     */   protected void populateWrapperList()
/*     */   {
/* 814 */     this.wrapperlist.add("java.lang.Integer");
/* 815 */     this.wrapperlist.add("java.lang.Boolean");
/* 816 */     this.wrapperlist.add("java.lang.Short");
/* 817 */     this.wrapperlist.add("java.lang.Byte");
/* 818 */     this.wrapperlist.add("java.lang.Long");
/* 819 */     this.wrapperlist.add("java.lang.Float");
/* 820 */     this.wrapperlist.add("java.lang.Double");
/* 821 */     this.wrapperlist.add("java.lang.String");
/*     */ 
/* 823 */     this.wrapperlist.add("java.math.BigInteger");
/* 824 */     this.wrapperlist.add("java.math.BigDecimal");
/* 825 */     this.wrapperlist.add("java.util.Calendar");
/* 826 */     this.wrapperlist.add("javax.xml.namespace.QName");
/*     */   }
/*     */ 
/*     */   private void createPrimitiveMap()
/*     */   {
/* 831 */     this.primitiveMap.put("Integer", "int");
/* 832 */     this.primitiveMap.put("Float", "float");
/* 833 */     this.primitiveMap.put("Long", "long");
/* 834 */     this.primitiveMap.put("Double", "double");
/* 835 */     this.primitiveMap.put("Short", "short");
/* 836 */     this.primitiveMap.put("Boolean", "boolean");
/* 837 */     this.primitiveMap.put("Byte", "byte");
/* 838 */     this.primitiveMap.put("java.lang.Integer", "int");
/* 839 */     this.primitiveMap.put("java.lang.Float", "float");
/* 840 */     this.primitiveMap.put("java.lang.Long", "long");
/* 841 */     this.primitiveMap.put("java.lang.Double", "double");
/* 842 */     this.primitiveMap.put("java.lang.Short", "short");
/* 843 */     this.primitiveMap.put("java.lang.Boolean", "boolean");
/* 844 */     this.primitiveMap.put("java.lang.Byte", "byte");
/*     */   }
/*     */ 
/*     */   public static WSDLInterfaceOperationOutput getWsdl11Output(WSDLInterfaceOperation operation)
/*     */   {
/* 849 */     WSDLInterfaceOperationOutput[] outputs = operation.getOutputs();
/* 850 */     if (outputs == null) {
/* 851 */       return null;
/*     */     }
/* 853 */     switch (outputs.length)
/*     */     {
/*     */     case 0:
/* 856 */       return null;
/*     */     case 1:
/* 858 */       return outputs[0];
/*     */     }
/*     */ 
/* 861 */     throw new WSException("Only Request-Only and Request-Response MEPs are allowed");
/*     */   }
/*     */ 
/*     */   public static WSDLInterfaceOperationInput getWsdl11Input(WSDLInterfaceOperation operation)
/*     */   {
/* 866 */     WSDLInterfaceOperationInput[] inputs = operation.getInputs();
/* 867 */     if (inputs == null) {
/* 868 */       return null;
/*     */     }
/* 870 */     switch (inputs.length)
/*     */     {
/*     */     case 0:
/* 873 */       return null;
/*     */     case 1:
/* 875 */       return inputs[0];
/*     */     }
/*     */ 
/* 878 */     throw new WSException("Only Request-Only and Request-Response MEPs are allowed");
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 105 */     schemaBasicTypes.put("anyURI", URI.class);
/* 106 */     schemaBasicTypes.put("boolean", Boolean.TYPE);
/* 107 */     schemaBasicTypes.put("byte", Byte.TYPE);
/* 108 */     schemaBasicTypes.put("decimal", BigDecimal.class);
/* 109 */     schemaBasicTypes.put("double", Double.TYPE);
/* 110 */     schemaBasicTypes.put("dateTime", Calendar.class);
/* 111 */     schemaBasicTypes.put("float", Float.TYPE);
/* 112 */     schemaBasicTypes.put("int", Integer.TYPE);
/* 113 */     schemaBasicTypes.put("integer", BigInteger.class);
/* 114 */     schemaBasicTypes.put("long", Long.TYPE);
/* 115 */     schemaBasicTypes.put("QName", QName.class);
/* 116 */     schemaBasicTypes.put("short", Short.TYPE);
/* 117 */     schemaBasicTypes.put("String", String.class);
/*     */ 
/* 122 */     holderTypes.put(BigDecimal.class, BigDecimalHolder.class);
/* 123 */     holderTypes.put(BigInteger.class, BigIntegerHolder.class);
/* 124 */     holderTypes.put(Boolean.TYPE, BooleanHolder.class);
/* 125 */     holderTypes.put(Boolean.class, BooleanWrapperHolder.class);
/* 126 */     holderTypes.put(Byte.TYPE, ByteHolder.class);
/* 127 */     holderTypes.put(Byte.class, ByteWrapperHolder.class);
/* 128 */     holderTypes.put([Ljava.lang.Byte.class, ByteArrayHolder.class);
/* 129 */     holderTypes.put(Calendar.class, CalendarHolder.class);
/* 130 */     holderTypes.put(Double.TYPE, DoubleHolder.class);
/* 131 */     holderTypes.put(Double.class, DoubleWrapperHolder.class);
/* 132 */     holderTypes.put(Float.TYPE, FloatHolder.class);
/* 133 */     holderTypes.put(Float.class, FloatWrapperHolder.class);
/* 134 */     holderTypes.put(Integer.TYPE, IntHolder.class);
/* 135 */     holderTypes.put(Integer.class, IntegerWrapperHolder.class);
/* 136 */     holderTypes.put(Long.TYPE, LongHolder.class);
/* 137 */     holderTypes.put(Long.class, LongWrapperHolder.class);
/* 138 */     holderTypes.put(Object.class, ObjectHolder.class);
/* 139 */     holderTypes.put(QName.class, QNameHolder.class);
/* 140 */     holderTypes.put(Short.TYPE, ShortHolder.class);
/* 141 */     holderTypes.put(Short.class, ShortWrapperHolder.class);
/* 142 */     holderTypes.put(String.class, StringHolder.class);
/*     */ 
/* 147 */     reverseHolderTypes.put(BigDecimalHolder.class, BigDecimal.class);
/* 148 */     reverseHolderTypes.put(BigIntegerHolder.class, BigInteger.class);
/* 149 */     reverseHolderTypes.put(BooleanHolder.class, Boolean.TYPE);
/* 150 */     reverseHolderTypes.put(BooleanWrapperHolder.class, Boolean.class);
/* 151 */     reverseHolderTypes.put(ByteArrayHolder.class, [Ljava.lang.Byte.class);
/* 152 */     reverseHolderTypes.put(ByteHolder.class, Byte.TYPE);
/* 153 */     reverseHolderTypes.put(ByteWrapperHolder.class, Byte.class);
/* 154 */     reverseHolderTypes.put(CalendarHolder.class, Calendar.class);
/* 155 */     reverseHolderTypes.put(DoubleHolder.class, Double.TYPE);
/* 156 */     reverseHolderTypes.put(DoubleWrapperHolder.class, Double.class);
/* 157 */     reverseHolderTypes.put(FloatHolder.class, Float.TYPE);
/* 158 */     reverseHolderTypes.put(FloatWrapperHolder.class, Float.class);
/* 159 */     reverseHolderTypes.put(IntHolder.class, Integer.TYPE);
/* 160 */     reverseHolderTypes.put(IntegerWrapperHolder.class, Integer.class);
/* 161 */     reverseHolderTypes.put(LongHolder.class, Long.TYPE);
/* 162 */     reverseHolderTypes.put(LongWrapperHolder.class, Long.class);
/* 163 */     reverseHolderTypes.put(ObjectHolder.class, Object.class);
/* 164 */     reverseHolderTypes.put(QNameHolder.class, QName.class);
/* 165 */     reverseHolderTypes.put(ShortHolder.class, Short.TYPE);
/* 166 */     reverseHolderTypes.put(ShortWrapperHolder.class, Short.class);
/* 167 */     reverseHolderTypes.put(StringHolder.class, String.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsdl.WSDLUtils
 * JD-Core Version:    0.6.0
 */