/*     */ package org.jboss.ws.metadata.wsdl.xmlschema;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.apache.xerces.xni.XMLResourceIdentifier;
/*     */ import org.apache.xerces.xni.XNIException;
/*     */ import org.apache.xerces.xni.parser.XMLEntityResolver;
/*     */ import org.apache.xerces.xni.parser.XMLInputSource;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.utils.ResourceURL;
/*     */ import org.xml.sax.EntityResolver;
/*     */ import org.xml.sax.InputSource;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public class JBossXSEntityResolver
/*     */   implements XMLEntityResolver
/*     */ {
/*  52 */   private static final Logger log = Logger.getLogger(JBossXSEntityResolver.class);
/*     */ 
/*  54 */   private Map<String, URL> schemaLocationByNamespace = new HashMap();
/*     */   private EntityResolver delegate;
/*     */ 
/*     */   public JBossXSEntityResolver(EntityResolver resolver, Map<String, URL> schemaLocationByNamespace)
/*     */   {
/*  60 */     this.schemaLocationByNamespace = schemaLocationByNamespace;
/*  61 */     this.delegate = resolver;
/*     */   }
/*     */ 
/*     */   public XMLInputSource resolveEntity(XMLResourceIdentifier resId)
/*     */     throws XNIException, IOException
/*     */   {
/*  70 */     log.trace("Resolve entity: " + resId);
/*     */ 
/*  73 */     String publicId = resId.getPublicId();
/*  74 */     String systemId = resId.getLiteralSystemId();
/*  75 */     String namespace = resId.getNamespace();
/*     */     try
/*     */     {
/*  78 */       String publicURI = publicId != null ? publicId : namespace;
/*  79 */       InputSource inputSource = this.delegate.resolveEntity(publicURI, systemId);
/*  80 */       if (inputSource != null)
/*     */       {
/*  82 */         XMLInputSource source = getXMLInputSource(inputSource, resId);
/*  83 */         return source;
/*     */       }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*  88 */       log.trace(ex);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  93 */       String expandedSysId = resId.getExpandedSystemId();
/*  94 */       if (expandedSysId != null)
/*     */       {
/*  96 */         log.trace("Use ExpandedSystemId: " + expandedSysId);
/*  97 */         return getXMLInputSource(new URL(expandedSysId), resId);
/*     */       }
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 102 */       log.trace(e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 107 */       if (systemId != null)
/*     */       {
/* 109 */         log.trace("Use LiteralSystemId: " + systemId);
/* 110 */         return getXMLInputSource(new URL(systemId), resId);
/*     */       }
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 115 */       log.trace(e);
/*     */     }
/*     */ 
/* 119 */     String namespaceURI = resId.getNamespace() != null ? resId.getNamespace() : resId.getLiteralSystemId();
/*     */ 
/* 122 */     if ("http://www.w3.org/2001/XMLSchema".equals(namespaceURI)) {
/* 123 */       return null;
/*     */     }
/*     */     try
/*     */     {
/* 127 */       URL url = (URL)this.schemaLocationByNamespace.get(namespaceURI);
/* 128 */       if (url != null)
/*     */       {
/* 130 */         log.trace("Use SchemaLocationByNamespace: " + url);
/* 131 */         return getXMLInputSource(url, resId);
/*     */       }
/*     */ 
/* 135 */       XMLInputSource source = getXMLInputSource(this.delegate.resolveEntity(null, namespaceURI), resId);
/* 136 */       if (source != null)
/* 137 */         return source;
/*     */     }
/*     */     catch (SAXException e)
/*     */     {
/* 141 */       log.trace(e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 146 */       log.trace("Use NamespaceURI: " + namespaceURI);
/* 147 */       return getXMLInputSource(new URL(namespaceURI), resId);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 151 */       log.trace(e);
/*     */ 
/* 154 */       log.trace("Cannot obtain XMLInputSource for: " + resId);
/* 155 */     }return null;
/*     */   }
/*     */ 
/*     */   private XMLInputSource getXMLInputSource(URL url, XMLResourceIdentifier resId) throws IOException
/*     */   {
/* 160 */     InputStream inputStream = new ResourceURL(url).openStream();
/* 161 */     InputSource inputSource = new InputSource(inputStream);
/* 162 */     return getXMLInputSource(inputSource, resId);
/*     */   }
/*     */ 
/*     */   private XMLInputSource getXMLInputSource(InputSource inputSource, XMLResourceIdentifier resId)
/*     */   {
/* 167 */     String encoding = inputSource.getEncoding();
/* 168 */     InputStream byteStream = inputSource.getByteStream();
/* 169 */     return new XMLInputSource(resId.getPublicId(), resId.getExpandedSystemId(), resId.getBaseSystemId(), byteStream, encoding);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsdl.xmlschema.JBossXSEntityResolver
 * JD-Core Version:    0.6.0
 */