/*     */ package org.jboss.ws.metadata.wsdl.xmlschema;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.apache.xerces.xs.StringList;
/*     */ import org.apache.xerces.xs.XSAnnotation;
/*     */ import org.apache.xerces.xs.XSAttributeDeclaration;
/*     */ import org.apache.xerces.xs.XSAttributeGroupDefinition;
/*     */ import org.apache.xerces.xs.XSComplexTypeDefinition;
/*     */ import org.apache.xerces.xs.XSElementDeclaration;
/*     */ import org.apache.xerces.xs.XSModel;
/*     */ import org.apache.xerces.xs.XSModelGroup;
/*     */ import org.apache.xerces.xs.XSModelGroupDefinition;
/*     */ import org.apache.xerces.xs.XSNamedMap;
/*     */ import org.apache.xerces.xs.XSNamespaceItem;
/*     */ import org.apache.xerces.xs.XSNamespaceItemList;
/*     */ import org.apache.xerces.xs.XSNotationDeclaration;
/*     */ import org.apache.xerces.xs.XSObjectList;
/*     */ import org.apache.xerces.xs.XSParticle;
/*     */ import org.apache.xerces.xs.XSSimpleTypeDefinition;
/*     */ import org.apache.xerces.xs.XSTerm;
/*     */ import org.apache.xerces.xs.XSTypeDefinition;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.wsf.common.DOMWriter;
/*     */ import org.jboss.xb.binding.NamespaceRegistry;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ 
/*     */ public class JBossXSModel
/*     */   implements XSModel, Cloneable
/*     */ {
/*  75 */   private static final Logger log = Logger.getLogger(JBossXSModel.class);
/*     */ 
/*  77 */   private AnonymousMapper anonymousMapper = new AnonymousMapper(null);
/*     */ 
/*  79 */   private boolean qualifiedElements = false;
/*     */ 
/*  81 */   private NamespaceRegistry namespaceRegistry = new NamespaceRegistry();
/*     */ 
/*  83 */   protected XSNamespaceItemList nslist = null;
/*     */ 
/*  85 */   protected HashMap<String, JBossXSNamespaceItem> nsimap = new HashMap();
/*     */ 
/*     */   public JBossXSModel clone()
/*     */     throws CloneNotSupportedException
/*     */   {
/*  94 */     return (JBossXSModel)super.clone();
/*     */   }
/*     */ 
/*     */   public StringList getNamespaces()
/*     */   {
/* 105 */     return new JBossXSStringList(this.nsimap.keySet());
/*     */   }
/*     */ 
/*     */   public XSNamespaceItemList getNamespaceItems()
/*     */   {
/* 119 */     this.nslist = new JBossXSNamespaceItemList(this.nsimap.values());
/*     */ 
/* 122 */     JBossXSNamespaceItem nsxsd = new JBossXSNamespaceItem("http://www.w3.org/2001/XMLSchema", this.namespaceRegistry, this.qualifiedElements);
/* 123 */     ((JBossXSNamespaceItemList)this.nslist).addItem(nsxsd);
/* 124 */     return this.nslist;
/*     */   }
/*     */ 
/*     */   public XSNamedMap getComponents(short objectType)
/*     */   {
/* 142 */     JBossXSNamedMap map = new JBossXSNamedMap();
/* 143 */     JBossXSStringList sl = (JBossXSStringList)getNamespaces();
/* 144 */     int len = sl != null ? sl.getLength() : 0;
/*     */ 
/* 146 */     for (int i = 0; i < len; i++)
/*     */     {
/* 148 */       String ns = sl.item(i);
/* 149 */       JBossXSNamespaceItem ni = (JBossXSNamespaceItem)this.nsimap.get(ns);
/* 150 */       JBossXSNamedMap nm = null;
/* 151 */       if (ni == null)
/*     */         continue;
/* 153 */       nm = (JBossXSNamedMap)ni.getComponents(objectType);
/* 154 */       map.addItems(nm.toList());
/*     */     }
/*     */ 
/* 158 */     return map;
/*     */   }
/*     */ 
/*     */   public XSNamedMap getComponentsByNamespace(short objectType, String namespace)
/*     */   {
/* 175 */     JBossXSNamedMap map = new JBossXSNamedMap();
/*     */ 
/* 177 */     JBossXSNamespaceItem ni = (JBossXSNamespaceItem)this.nsimap.get(namespace);
/* 178 */     if (ni == null) {
/* 179 */       return map;
/*     */     }
/* 181 */     return ni.getComponents(objectType);
/*     */   }
/*     */ 
/*     */   public XSObjectList getAnnotations()
/*     */   {
/* 190 */     List lst = new ArrayList();
/* 191 */     JBossXSObjectList objlist = new JBossXSObjectList(lst);
/* 192 */     Set keyset = this.nsimap.keySet();
/* 193 */     for (String ns : keyset)
/*     */     {
/* 195 */       XSNamespaceItem xs = (XSNamespaceItem)this.nsimap.get(ns);
/* 196 */       objlist.addObjects(xs.getAnnotations());
/*     */     }
/* 198 */     return objlist;
/*     */   }
/*     */ 
/*     */   public XSElementDeclaration getElementDeclaration(String name, String namespace)
/*     */   {
/* 211 */     if (name == null) {
/* 212 */       return null;
/*     */     }
/* 214 */     if ((name.startsWith(">")) || (name.endsWith("]"))) {
/* 215 */       return this.anonymousMapper.getElementDeclaration(name, namespace);
/*     */     }
/* 217 */     JBossXSNamespaceItem ni = (JBossXSNamespaceItem)this.nsimap.get(namespace);
/* 218 */     if (ni == null)
/* 219 */       return null;
/* 220 */     return ni.getElementDeclaration(name);
/*     */   }
/*     */ 
/*     */   public XSAttributeDeclaration getAttributeDeclaration(String name, String namespace)
/*     */   {
/* 233 */     JBossXSNamespaceItem ni = (JBossXSNamespaceItem)this.nsimap.get(namespace);
/* 234 */     if (ni == null)
/* 235 */       return null;
/* 236 */     return ni.getAttributeDeclaration(name);
/*     */   }
/*     */ 
/*     */   public XSTypeDefinition getTypeDefinition(String name, String namespace)
/*     */   {
/* 250 */     if (name == null) {
/* 251 */       return null;
/*     */     }
/* 253 */     if ((name.startsWith(">")) || (name.endsWith("]"))) {
/* 254 */       return this.anonymousMapper.getTypeDefinition(name, namespace);
/*     */     }
/* 256 */     JBossXSNamespaceItem ni = (JBossXSNamespaceItem)this.nsimap.get(namespace);
/* 257 */     if (ni == null)
/* 258 */       return null;
/* 259 */     return ni.getTypeDefinition(name);
/*     */   }
/*     */ 
/*     */   public XSAttributeGroupDefinition getAttributeGroup(String name, String namespace)
/*     */   {
/* 272 */     return null;
/*     */   }
/*     */ 
/*     */   public XSModelGroupDefinition getModelGroupDefinition(String name, String namespace)
/*     */   {
/* 285 */     return null;
/*     */   }
/*     */ 
/*     */   public XSNotationDeclaration getNotationDeclaration(String name, String namespace)
/*     */   {
/* 298 */     return null;
/*     */   }
/*     */ 
/*     */   public void addXSAnnotation(XSAnnotation xa)
/*     */   {
/* 303 */     String ns = xa.getNamespace();
/* 304 */     if ((ns == null) && (this.nsimap.keySet().size() == 1))
/*     */     {
/* 306 */       ns = (String)this.nsimap.keySet().iterator().next();
/*     */     }
/* 308 */     if (ns != null)
/*     */     {
/* 310 */       createNamespaceItemIfNotExistent(ns);
/* 311 */       JBossXSNamespaceItem jbnm = (JBossXSNamespaceItem)this.nsimap.get(ns);
/* 312 */       jbnm.addXSAnnotation(xa);
/*     */     }
/*     */     else
/*     */     {
/* 316 */       log.trace("Cannot assign XSAnnotation to null namespace");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addXSAttributeDeclaration(XSAttributeDeclaration attr)
/*     */   {
/* 323 */     String ns = attr.getNamespace();
/* 324 */     JBossXSNamespaceItem jbnm = createNamespaceItemIfNotExistent(ns);
/* 325 */     jbnm.addXSAttributeDeclaration(attr);
/*     */   }
/*     */ 
/*     */   public void addXSTypeDefinition(XSTypeDefinition xst)
/*     */   {
/* 331 */     String ns = xst.getNamespace();
/* 332 */     if (ns == null)
/* 333 */       throw new WSException("Illegal namespace:null");
/* 334 */     JBossXSNamespaceItem jbnm = createNamespaceItemIfNotExistent(ns);
/* 335 */     jbnm.addXSTypeDefinition(xst);
/*     */ 
/* 337 */     this.anonymousMapper.rebuild();
/*     */   }
/*     */ 
/*     */   public void addXSComplexTypeDefinition(XSTypeDefinition xst)
/*     */   {
/* 342 */     addXSTypeDefinition(xst);
/*     */ 
/* 344 */     this.anonymousMapper.rebuild();
/*     */   }
/*     */ 
/*     */   public void addXSElementDeclaration(XSElementDeclaration xsel)
/*     */   {
/* 350 */     String ns = xsel.getNamespace();
/* 351 */     JBossXSNamespaceItem jbnm = createNamespaceItemIfNotExistent(ns);
/* 352 */     jbnm.addXSElementDeclaration(xsel);
/*     */ 
/* 354 */     this.anonymousMapper.rebuild();
/*     */   }
/*     */ 
/*     */   public void addSchemaLocation(String nsURI, URL locationURL)
/*     */   {
/* 359 */     JBossXSNamespaceItem ni = createNamespaceItemIfNotExistent(nsURI);
/* 360 */     ni.addDocumentLocation(locationURL.toExternalForm());
/*     */   }
/*     */ 
/*     */   public void addXSNamespaceItem(XSNamespaceItem xsitem)
/*     */   {
/* 365 */     ((JBossXSNamespaceItemList)this.nslist).addItem(xsitem);
/*     */ 
/* 367 */     this.anonymousMapper.rebuild();
/*     */   }
/*     */ 
/*     */   public void setXSNamespaceItemList(XSNamespaceItemList list)
/*     */   {
/* 372 */     this.nslist = list;
/*     */   }
/*     */ 
/*     */   public void merge(JBossXSModel xsm)
/*     */   {
/* 377 */     JBossXSNamespaceItemList jxsm = (JBossXSNamespaceItemList)xsm.getNamespaceItems();
/* 378 */     int len = jxsm.getLength();
/* 379 */     for (int i = 0; i < len; i++)
/*     */     {
/* 381 */       JBossXSNamespaceItem ni = (JBossXSNamespaceItem)jxsm.item(i);
/* 382 */       String sns = ni.getSchemaNamespace();
/* 383 */       JBossXSNamespaceItem mynsi = (JBossXSNamespaceItem)this.nsimap.get(sns);
/* 384 */       if (mynsi != null) {
/* 385 */         mynsi.merge(ni);
/*     */       }
/*     */       else
/*     */       {
/* 389 */         this.nsimap.put(sns, ni);
/* 390 */         ni.setNamespaceRegistry(this.namespaceRegistry);
/*     */       }
/*     */     }
/*     */ 
/* 394 */     NamespaceRegistry xsmRegistry = xsm.getNamespaceRegistry();
/* 395 */     Iterator iter = xsmRegistry.getRegisteredPrefixes();
/* 396 */     while (iter.hasNext())
/*     */     {
/* 398 */       String prefix = (String)iter.next();
/* 399 */       String ns = xsmRegistry.getNamespaceURI(prefix);
/* 400 */       this.namespaceRegistry.registerURI(ns, prefix);
/*     */     }
/*     */ 
/* 403 */     this.anonymousMapper.rebuild();
/*     */   }
/*     */ 
/*     */   public void removeXSTypeDefinition(XSTypeDefinition xst)
/*     */   {
/* 408 */     String ns = xst.getNamespace();
/* 409 */     JBossXSNamespaceItem ni = (JBossXSNamespaceItem)this.nsimap.get(ns);
/* 410 */     ni.removeXSTypeDefinition(xst);
/*     */ 
/* 412 */     this.anonymousMapper.rebuild();
/*     */   }
/*     */ 
/*     */   public JBossXSNamespaceItem getNamespaceItem(String nsuri)
/*     */   {
/* 422 */     return (JBossXSNamespaceItem)this.nsimap.get(nsuri);
/*     */   }
/*     */ 
/*     */   public void writeTo(OutputStream out) throws IOException
/*     */   {
/* 427 */     out.write(serialize().getBytes());
/*     */   }
/*     */ 
/*     */   public String serialize()
/*     */   {
/* 432 */     StringBuilder sb = serializeNamespaceItems();
/*     */ 
/* 439 */     sb.insert(0, "<root>");
/* 440 */     sb.append("</root>");
/*     */ 
/* 442 */     String xsModelString = sb.toString();
/*     */ 
/* 444 */     if (xsModelString.length() > 0)
/*     */     {
/*     */       try
/*     */       {
/* 448 */         Element root = DOMUtils.parse(xsModelString);
/*     */ 
/* 450 */         xsModelString = getChildNodesSerialized(root);
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 454 */         log.error("Cannot parse xsModelString: " + xsModelString, e);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 459 */     return xsModelString;
/*     */   }
/*     */ 
/*     */   public Map<String, XSTypeDefinition> getAnonymousTypes()
/*     */   {
/* 464 */     return this.anonymousMapper.getTypes();
/*     */   }
/*     */ 
/*     */   public Map<String, XSElementDeclaration> getAnonymousElements()
/*     */   {
/* 469 */     return this.anonymousMapper.getElements();
/*     */   }
/*     */ 
/*     */   public boolean isQualifiedElements()
/*     */   {
/* 474 */     return this.qualifiedElements;
/*     */   }
/*     */ 
/*     */   public void setQualifiedElements(boolean qualifiedElements)
/*     */   {
/* 479 */     this.qualifiedElements = qualifiedElements;
/* 480 */     for (JBossXSNamespaceItem item : this.nsimap.values())
/* 481 */       item.setQualifiedElements(qualifiedElements);
/*     */   }
/*     */ 
/*     */   public NamespaceRegistry getNamespaceRegistry()
/*     */   {
/* 486 */     return this.namespaceRegistry;
/*     */   }
/*     */ 
/*     */   public void eagerInitialize()
/*     */   {
/* 491 */     this.anonymousMapper.build();
/*     */   }
/*     */ 
/*     */   private String registerNamespace(String ns)
/*     */   {
/* 496 */     String prefix = this.namespaceRegistry.getPrefix(ns);
/*     */ 
/* 498 */     if (prefix != null) {
/* 499 */       return prefix;
/*     */     }
/*     */ 
/* 502 */     if ("http://www.w3.org/XML/1998/namespace".equals(ns)) {
/* 503 */       prefix = "xml";
/*     */     }
/* 505 */     return this.namespaceRegistry.registerURI(ns, prefix);
/*     */   }
/*     */ 
/*     */   private JBossXSNamespaceItem createNamespaceItemIfNotExistent(String ns)
/*     */   {
/* 510 */     if (ns == null) {
/* 511 */       throw new IllegalArgumentException("Illegal null argument:ns");
/*     */     }
/* 513 */     JBossXSNamespaceItem jbnm = (JBossXSNamespaceItem)this.nsimap.get(ns);
/* 514 */     if (jbnm == null)
/*     */     {
/* 516 */       jbnm = new JBossXSNamespaceItem(ns, this.namespaceRegistry, this.qualifiedElements);
/* 517 */       this.nsimap.put(ns, jbnm);
/* 518 */       registerNamespace(ns);
/*     */     }
/*     */ 
/* 521 */     return jbnm;
/*     */   }
/*     */ 
/*     */   private StringBuilder serializeNamespaceItems()
/*     */   {
/* 526 */     StringBuilder sb = new StringBuilder();
/*     */ 
/* 528 */     Collection col = this.nsimap.values();
/* 529 */     for (JBossXSNamespaceItem i : col)
/*     */     {
/* 531 */       String nameS = i.getSchemaNamespace();
/* 532 */       if (("http://www.w3.org/2001/XMLSchema".equals(nameS)) || ("http://schemas.xmlsoap.org/soap/encoding/".equals(nameS))) {
/*     */         continue;
/*     */       }
/* 535 */       sb.append(i.toString());
/*     */     }
/*     */ 
/* 538 */     return sb;
/*     */   }
/*     */ 
/*     */   private String getChildNodesSerialized(Element root)
/*     */   {
/* 543 */     StringBuilder sb = new StringBuilder();
/* 544 */     Iterator iter = DOMUtils.getChildElements(root);
/* 545 */     while ((iter != null) && (iter.hasNext()))
/*     */     {
/* 547 */       Node n = (Node)iter.next();
/* 548 */       sb.append(DOMWriter.printNode(n, true));
/* 549 */       sb.append("\n");
/*     */     }
/* 551 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public XSObjectList getSubstitutionGroup(XSElementDeclaration arg0)
/*     */   {
/* 749 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   private class AnonymousMapper
/*     */     implements Serializable
/*     */   {
/*     */     private static final long serialVersionUID = 5572350092914194023L;
/*     */     private HashMap<String, XSTypeDefinition> anonymousTypeMap;
/*     */     private HashMap<String, XSElementDeclaration> anonymousElementMap;
/* 563 */     private HashSet<XSComplexTypeDefinition> stack = new HashSet();
/*     */ 
/*     */     private AnonymousMapper()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void rebuild() {
/* 570 */       if (this.anonymousTypeMap != null)
/* 571 */         build();
/*     */     }
/*     */ 
/*     */     public void build()
/*     */     {
/* 579 */       XSModel model = JBossXSModel.this;
/*     */ 
/* 581 */       this.anonymousTypeMap = new HashMap();
/*     */ 
/* 583 */       this.anonymousElementMap = new HashMap();
/*     */ 
/* 585 */       XSNamedMap namedMap = model.getComponents(3);
/* 586 */       for (int i = 0; i < namedMap.getLength(); i++)
/*     */       {
/* 588 */         XSTypeDefinition type = (XSTypeDefinition)namedMap.item(i);
/* 589 */         if (type.getTypeCategory() != 15) {
/*     */           continue;
/*     */         }
/* 592 */         analyzeComplexType((XSComplexTypeDefinition)type, null, type.getNamespace());
/*     */       }
/*     */ 
/* 595 */       namedMap = model.getComponents(2);
/* 596 */       for (int i = 0; i < namedMap.getLength(); i++)
/*     */       {
/* 598 */         XSElementDeclaration element = (XSElementDeclaration)namedMap.item(i);
/* 599 */         analyzeElement(element, null, element.getNamespace(), null, null);
/*     */       }
/*     */     }
/*     */ 
/*     */     private void analyzeElement(XSElementDeclaration element, String parentName, String namespace, Integer minOccurs, Integer maxOccurs)
/*     */     {
/* 605 */       String name = element.getName();
/*     */ 
/* 607 */       if (element.getScope() != 1)
/*     */       {
/* 609 */         name = parentName + ">" + name;
/* 610 */         this.anonymousElementMap.put(namespace + ":" + name, element);
/*     */       }
/*     */ 
/* 613 */       if ((maxOccurs != null) && (maxOccurs.intValue() > 1))
/*     */       {
/* 615 */         String key = namespace + ":" + name + "[" + minOccurs.intValue() + "," + maxOccurs.intValue() + "]";
/* 616 */         this.anonymousTypeMap.put(key, createArrayWrapperComplexType(element, name, namespace, minOccurs, maxOccurs));
/* 617 */         if (minOccurs.intValue() == 1)
/*     */         {
/* 619 */           key = namespace + ":" + name + "[" + "," + maxOccurs.intValue() + "]";
/* 620 */           this.anonymousTypeMap.put(key, createArrayWrapperComplexType(element, name, namespace, minOccurs, maxOccurs));
/*     */         }
/*     */       }
/*     */ 
/* 624 */       XSTypeDefinition type = element.getTypeDefinition();
/* 625 */       if (type.getTypeCategory() == 15) {
/* 626 */         analyzeComplexType((XSComplexTypeDefinition)type, name, namespace);
/*     */       }
/* 628 */       if (type.getTypeCategory() == 16)
/* 629 */         analyzeSimpleType((XSSimpleTypeDefinition)type, name, namespace);
/*     */     }
/*     */ 
/*     */     private XSComplexTypeDefinition createArrayWrapperComplexType(XSElementDeclaration element, String name, String namespace, Integer minOccurs, Integer maxOccurs)
/*     */     {
/* 634 */       JBossXSComplexTypeDefinition definition = new JBossXSComplexTypeDefinition(name, namespace);
/* 635 */       definition.setAnonymous(true);
/*     */ 
/* 637 */       JBossXSModelGroup group = new JBossXSModelGroup();
/* 638 */       group.setCompositor(1);
/* 639 */       List particles = new ArrayList(1);
/* 640 */       JBossXSParticle particle = new JBossXSParticle();
/* 641 */       particle.setMaxOccurs(maxOccurs.intValue());
/* 642 */       particle.setMinOccurs(minOccurs.intValue());
/* 643 */       particle.setTerm(element);
/* 644 */       particles.add(particle);
/* 645 */       group.setParticles(particles);
/*     */ 
/* 647 */       particle = new JBossXSParticle();
/* 648 */       particle.setTerm(group);
/* 649 */       definition.setParticle(particle);
/*     */ 
/* 651 */       return definition;
/*     */     }
/*     */ 
/*     */     private String analyzeType(XSTypeDefinition type, String parentName, String namespace)
/*     */     {
/*     */       String name;
/*     */       String name;
/* 657 */       if (type.getAnonymous())
/* 658 */         name = ">" + parentName;
/* 659 */       else name = type.getName();
/*     */ 
/* 661 */       if (type.getAnonymous())
/*     */       {
/* 663 */         this.anonymousTypeMap.put(namespace + ":" + name, type);
/* 664 */         if (JBossXSModel.log.isDebugEnabled()) JBossXSModel.log.debug("Registered as anon type: {" + namespace + ":" + name + "} -> " + type);
/*     */       }
/* 666 */       return name;
/*     */     }
/*     */ 
/*     */     private void analyzeSimpleType(XSSimpleTypeDefinition simpleType, String parentName, String namespace)
/*     */     {
/* 671 */       analyzeType(simpleType, parentName, namespace);
/*     */     }
/*     */ 
/*     */     private void analyzeComplexType(XSComplexTypeDefinition complexType, String parentName, String namespace)
/*     */     {
/* 677 */       if (this.stack.contains(complexType)) {
/* 678 */         return;
/*     */       }
/* 680 */       this.stack.add(complexType);
/* 681 */       String name = analyzeType(complexType, parentName, namespace);
/* 682 */       analyzeParticle(complexType.getParticle(), name, namespace);
/* 683 */       this.stack.remove(complexType);
/*     */     }
/*     */ 
/*     */     private void analyzeParticle(XSParticle particle, String parentName, String namespace)
/*     */     {
/* 689 */       if (particle == null)
/* 690 */         return;
/* 691 */       XSTerm term = particle.getTerm();
/*     */ 
/* 694 */       if (term == null)
/* 695 */         return;
/* 696 */       switch (term.getType())
/*     */       {
/*     */       case 7:
/* 699 */         XSModelGroup group = (XSModelGroup)term;
/* 700 */         XSObjectList list = group.getParticles();
/* 701 */         for (int i = 0; i < list.getLength(); i++)
/* 702 */           analyzeParticle((XSParticle)list.item(i), parentName, namespace);
/* 703 */         break;
/*     */       case 2:
/* 705 */         XSElementDeclaration decl = (XSElementDeclaration)term;
/* 706 */         analyzeElement(decl, parentName, namespace, new Integer(particle.getMinOccurs()), new Integer(particle.getMaxOccurs()));
/*     */       }
/*     */     }
/*     */ 
/*     */     public XSTypeDefinition getTypeDefinition(String name, String namespace)
/*     */     {
/* 713 */       if (this.anonymousTypeMap == null) {
/* 714 */         build();
/*     */       }
/* 716 */       return (XSTypeDefinition)this.anonymousTypeMap.get(namespace + ":" + name);
/*     */     }
/*     */ 
/*     */     public XSElementDeclaration getElementDeclaration(String name, String namespace)
/*     */     {
/* 722 */       if (this.anonymousElementMap == null) {
/* 723 */         build();
/*     */       }
/* 725 */       return (XSElementDeclaration)this.anonymousElementMap.get(namespace + ":" + name);
/*     */     }
/*     */ 
/*     */     public Map<String, XSElementDeclaration> getElements()
/*     */     {
/* 730 */       if (this.anonymousElementMap == null) {
/* 731 */         build();
/*     */       }
/*     */ 
/* 734 */       return this.anonymousElementMap;
/*     */     }
/*     */ 
/*     */     public Map<String, XSTypeDefinition> getTypes()
/*     */     {
/* 739 */       if (this.anonymousTypeMap == null) {
/* 740 */         build();
/*     */       }
/*     */ 
/* 743 */       return this.anonymousTypeMap;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel
 * JD-Core Version:    0.6.0
 */