/*     */ package org.jboss.ws.tools;
/*     */ 
/*     */ import java.io.StringWriter;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.jws.soap.SOAPBinding.ParameterStyle;
/*     */ import javax.xml.rpc.encoding.TypeMapping;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.soap.Style;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
/*     */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.jboss.ws.tools.metadata.ToolsUnifiedMetaDataBuilder;
/*     */ import org.jboss.ws.tools.wsdl.WSDLWriter;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.wsf.common.DOMWriter;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class JavaToWSDL
/*     */ {
/*  66 */   private static final Logger log = Logger.getLogger(JavaToWSDL.class);
/*     */   private String wsdlNamespace;
/*     */   private String targetNamespace;
/*     */   private String typeNamespace;
/*     */   private String serviceName;
/*     */   private String portTypeName;
/*     */   private Style style;
/*     */   private SOAPBinding.ParameterStyle parameterStyle;
/*  84 */   private Map<String, Boolean> features = new HashMap();
/*     */ 
/*  87 */   private Map<String, String> packageNamespaceMap = new HashMap();
/*     */ 
/*  89 */   private TypeMapping typeMapping = null;
/*     */ 
/*  91 */   private JavaWsdlMapping javaWsdlMapping = null;
/*     */ 
/*  93 */   private UnifiedMetaData umd = null;
/*     */ 
/*  95 */   private boolean qualifiedElements = false;
/*     */ 
/*  97 */   private Map<String, List<Configuration.OperationConfig>> operationMap = null;
/*     */ 
/*     */   public JavaToWSDL(String namespace)
/*     */   {
/* 108 */     if (!"http://schemas.xmlsoap.org/wsdl/".equals(namespace)) {
/* 109 */       throw new IllegalArgumentException("Unsupported wsdl version: " + namespace);
/*     */     }
/* 111 */     this.wsdlNamespace = namespace;
/*     */   }
/*     */ 
/*     */   public void addFeature(String name, boolean value)
/*     */   {
/* 122 */     this.features.put(name, new Boolean(value));
/*     */   }
/*     */ 
/*     */   public boolean getFeature(String name)
/*     */   {
/* 134 */     Boolean val = (Boolean)this.features.get(name);
/* 135 */     if (val == null) {
/* 136 */       throw new WSException("Feature value not available: " + name);
/*     */     }
/* 138 */     return val.booleanValue();
/*     */   }
/*     */ 
/*     */   public String getWsdlNamespace()
/*     */   {
/* 145 */     return this.wsdlNamespace;
/*     */   }
/*     */ 
/*     */   public String getTargetNamespace()
/*     */   {
/* 152 */     return this.targetNamespace;
/*     */   }
/*     */ 
/*     */   public void setTargetNamespace(String targetNamespace)
/*     */   {
/* 159 */     this.targetNamespace = targetNamespace;
/*     */   }
/*     */ 
/*     */   public String getTypeNamespace()
/*     */   {
/* 165 */     return this.typeNamespace;
/*     */   }
/*     */ 
/*     */   public void setTypeNamespace(String typeNamespace)
/*     */   {
/* 171 */     this.typeNamespace = typeNamespace;
/*     */   }
/*     */ 
/*     */   public String getServiceName()
/*     */   {
/* 178 */     return this.serviceName;
/*     */   }
/*     */ 
/*     */   public void setServiceName(String serviceName)
/*     */   {
/* 185 */     this.serviceName = serviceName;
/*     */   }
/*     */ 
/*     */   public String getPortTypeName()
/*     */   {
/* 192 */     return this.portTypeName;
/*     */   }
/*     */ 
/*     */   public void setPortTypeName(String endpointName)
/*     */   {
/* 199 */     this.portTypeName = endpointName;
/*     */   }
/*     */ 
/*     */   public TypeMapping getTypeMapping()
/*     */   {
/* 211 */     if (this.typeMapping == null)
/* 212 */       throw new WSException("TypeMapping has not been generated");
/* 213 */     return this.typeMapping;
/*     */   }
/*     */ 
/*     */   public Style getStyle()
/*     */   {
/* 218 */     return this.style;
/*     */   }
/*     */ 
/*     */   public void setStyle(Style style)
/*     */   {
/* 223 */     this.style = style;
/*     */   }
/*     */ 
/*     */   public SOAPBinding.ParameterStyle getParameterStyle()
/*     */   {
/* 228 */     return this.parameterStyle;
/*     */   }
/*     */ 
/*     */   public void setParameterStyle(SOAPBinding.ParameterStyle parameterStyle)
/*     */   {
/* 233 */     this.parameterStyle = parameterStyle;
/*     */   }
/*     */ 
/*     */   public void setPackageNamespaceMap(Map<String, String> pn)
/*     */   {
/* 249 */     this.packageNamespaceMap = pn;
/*     */   }
/*     */ 
/*     */   public void setOperationMap(Map<String, List<Configuration.OperationConfig>> operationMap)
/*     */   {
/* 254 */     this.operationMap = operationMap;
/*     */   }
/*     */ 
/*     */   public void setUnifiedMetaData(UnifiedMetaData um)
/*     */   {
/* 265 */     this.umd = um;
/*     */   }
/*     */ 
/*     */   public UnifiedMetaData getUnifiedMetaData()
/*     */   {
/* 270 */     return this.umd;
/*     */   }
/*     */ 
/*     */   public void setUmd(UnifiedMetaData umd)
/*     */   {
/* 275 */     this.umd = umd;
/*     */   }
/*     */ 
/*     */   public boolean isQualifiedElements()
/*     */   {
/* 280 */     return this.qualifiedElements;
/*     */   }
/*     */ 
/*     */   public void setQualifiedElements(boolean qualifiedElements)
/*     */   {
/* 285 */     this.qualifiedElements = qualifiedElements;
/*     */   }
/*     */ 
/*     */   public JavaWsdlMapping getJavaWsdlMapping()
/*     */   {
/* 290 */     return this.javaWsdlMapping;
/*     */   }
/*     */ 
/*     */   public WSDLDefinitions generate(Class endpoint)
/*     */   {
/* 297 */     if (log.isDebugEnabled()) log.debug("generate [endpoint=" + endpoint.getName() + ",tnsURI=" + this.targetNamespace + ",service=" + this.serviceName + ",portType=" + this.portTypeName + "]");
/*     */ 
/* 300 */     if (this.umd == null)
/*     */     {
/* 302 */       this.umd = new ToolsUnifiedMetaDataBuilder(endpoint, this.targetNamespace, this.typeNamespace, this.serviceName, this.style, this.parameterStyle, this.operationMap).getUnifiedMetaData();
/*     */     }
/*     */ 
/* 306 */     if (this.typeNamespace != null) {
/* 307 */       this.packageNamespaceMap.put(endpoint.getPackage().getName(), this.typeNamespace);
/*     */     }
/* 309 */     WSDLDefinitions wsdlDefinitions = null;
/*     */     try
/*     */     {
/* 312 */       if ("http://schemas.xmlsoap.org/wsdl/".equals(this.wsdlNamespace))
/*     */       {
/* 314 */         JavaToWSDL11 javaWSDL11 = new JavaToWSDL11();
/* 315 */         javaWSDL11.addFeatures(this.features);
/* 316 */         javaWSDL11.setPackageNamespaceMap(this.packageNamespaceMap);
/* 317 */         javaWSDL11.addFeatures(this.features);
/* 318 */         if (this.umd != null)
/* 319 */           javaWSDL11.setUnifiedMetaData(this.umd);
/* 320 */         javaWSDL11.setQualifiedElements(this.qualifiedElements);
/*     */ 
/* 322 */         wsdlDefinitions = javaWSDL11.generate(endpoint);
/* 323 */         this.typeMapping = javaWSDL11.getTypeMapping();
/* 324 */         this.javaWsdlMapping = javaWSDL11.getJavaWsdlMapping();
/*     */       }
/* 326 */       if (wsdlDefinitions == null) {
/* 327 */         throw new WSException("Cannot generate WSDL definitions");
/*     */       }
/*     */ 
/* 330 */       StringWriter sw = new StringWriter();
/* 331 */       new WSDLWriter(wsdlDefinitions).write(sw, "UTF-8");
/* 332 */       if (log.isDebugEnabled()) log.debug("Generated WSDL:\n" + sw.toString());
/*     */ 
/* 335 */       String jaxrpcMappingStr = null;
/* 336 */       if (this.javaWsdlMapping != null)
/*     */       {
/* 338 */         Element root = DOMUtils.parse(this.javaWsdlMapping.serialize());
/* 339 */         jaxrpcMappingStr = DOMWriter.printNode(root, true);
/*     */       }
/* 341 */       if (log.isDebugEnabled()) log.debug("Generated Mapping:\n" + jaxrpcMappingStr);
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 345 */       throw rte;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 349 */       log.error("Cannot generate WSDL", e);
/* 350 */       throw new WSException("Cannot generate wsdl from: " + endpoint);
/*     */     }
/* 352 */     return wsdlDefinitions;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.JavaToWSDL
 * JD-Core Version:    0.6.0
 */