/*     */ package org.jboss.ws.tools;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ 
/*     */ public class JavaToWSDL20
/*     */ {
/*  43 */   private static final Logger log = Logger.getLogger(JavaToWSDL20.class);
/*     */ 
/*  46 */   private final String wsdlNamespace = "http://schemas.xmlsoap.org/wsdl/";
/*     */   private String targetNamespace;
/*     */   private String typeNamespace;
/*     */   private String serviceName;
/*     */   private String portTypeName;
/*  58 */   private HashMap<String, Boolean> features = new HashMap();
/*     */ 
/*  61 */   private Map<String, String> packageNamespaceMap = null;
/*     */ 
/*     */   public JavaToWSDL20()
/*     */   {
/*  80 */     if (log.isDebugEnabled()) log.debug("Creating JavaToWSDL20 instance");
/*     */   }
/*     */ 
/*     */   public void addFeature(String name, boolean value)
/*     */   {
/*  90 */     this.features.put(name, new Boolean(value));
/*     */   }
/*     */ 
/*     */   public void addFeatures(Map<String, Boolean> map)
/*     */   {
/*  99 */     this.features.putAll(map);
/*     */   }
/*     */ 
/*     */   public boolean getFeature(String name)
/*     */   {
/* 110 */     Boolean val = (Boolean)this.features.get(name);
/* 111 */     if (val != null) return val.booleanValue();
/* 112 */     throw new WSException("Feature unrecognized");
/*     */   }
/*     */ 
/*     */   public String getPortTypeName()
/*     */   {
/* 120 */     return this.portTypeName;
/*     */   }
/*     */ 
/*     */   public void setPortTypeName(String endpointName)
/*     */   {
/* 130 */     this.portTypeName = endpointName;
/*     */   }
/*     */ 
/*     */   public void setPackageNamespaceMap(Map<String, String> map)
/*     */   {
/* 140 */     this.packageNamespaceMap = map;
/*     */   }
/*     */ 
/*     */   public String getServiceName()
/*     */   {
/* 150 */     return this.serviceName;
/*     */   }
/*     */ 
/*     */   public void setServiceName(String serviceName)
/*     */   {
/* 159 */     this.serviceName = serviceName;
/*     */   }
/*     */ 
/*     */   public String getTargetNamespace()
/*     */   {
/* 168 */     return this.targetNamespace;
/*     */   }
/*     */ 
/*     */   public void setTargetNamespace(String targetNamespace)
/*     */   {
/* 177 */     this.targetNamespace = targetNamespace;
/*     */   }
/*     */ 
/*     */   public String getTypeNamespace()
/*     */   {
/* 187 */     return this.typeNamespace;
/*     */   }
/*     */ 
/*     */   public void setTypeNamespace(String typeNamespace)
/*     */   {
/* 197 */     this.typeNamespace = typeNamespace;
/*     */   }
/*     */ 
/*     */   public WSDLDefinitions generate(Class endpoint)
/*     */   {
/* 225 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.JavaToWSDL20
 * JD-Core Version:    0.6.0
 */