/*    */ package org.jboss.ws.tools;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.Collection;
/*    */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
/*    */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
/*    */ import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
/*    */ import org.jboss.ws.metadata.wsdl.WSDLRPCPart;
/*    */ import org.jboss.ws.metadata.wsdl.WSDLRPCSignatureItem;
/*    */ import org.jboss.ws.metadata.wsdl.WSDLRPCSignatureItem.Direction;
/*    */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*    */ 
/*    */ public class RPCSignature
/*    */ {
/* 37 */   private Collection<WSDLRPCPart> parameters = new ArrayList();
/*    */   private WSDLRPCPart returnParameter;
/*    */ 
/*    */   public Collection<WSDLRPCPart> parameters()
/*    */   {
/* 42 */     return this.parameters;
/*    */   }
/*    */ 
/*    */   public WSDLRPCPart returnParameter()
/*    */   {
/* 47 */     return this.returnParameter;
/*    */   }
/*    */ 
/*    */   public RPCSignature(WSDLInterfaceOperation operation)
/*    */   {
/* 52 */     WSDLInterfaceOperationInput input = WSDLUtils.getWsdl11Input(operation);
/* 53 */     WSDLInterfaceOperationOutput output = WSDLUtils.getWsdl11Output(operation);
/* 54 */     for (WSDLRPCSignatureItem item : operation.getRpcSignatureItems())
/*    */     {
/* 56 */       if (item.getDirection() == WSDLRPCSignatureItem.Direction.RETURN)
/*    */       {
/* 58 */         if (output != null) {
/* 59 */           this.returnParameter = output.getChildPart(item.getName()); continue;
/*    */         }
/*    */       }
/*    */ 
/* 63 */       WSDLRPCPart part = null;
/* 64 */       if (input != null)
/* 65 */         part = input.getChildPart(item.getName());
/* 66 */       if ((output != null) && (part == null)) {
/* 67 */         part = output.getChildPart(item.getName());
/*    */       }
/* 69 */       if (part != null) {
/* 70 */         this.parameters.add(part);
/*    */       }
/*    */     }
/* 73 */     for (WSDLRPCPart part : input.getChildParts())
/*    */     {
/* 75 */       if (operation.getRpcSignatureitem(part.getName()) == null) {
/* 76 */         this.parameters.add(part);
/*    */       }
/*    */     }
/* 79 */     if (output != null)
/*    */     {
/* 81 */       for (WSDLRPCPart part : output.getChildParts())
/*    */       {
/* 83 */         if (operation.getRpcSignatureitem(part.getName()) == null)
/*    */         {
/* 86 */           if (input.getChildPart(part.getName()) != null) {
/*    */             continue;
/*    */           }
/* 89 */           if (this.returnParameter == null)
/*    */           {
/* 91 */             this.returnParameter = part;
/*    */           }
/*    */           else
/*    */           {
/* 95 */             this.parameters.add(part);
/*    */           }
/*    */         }
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.RPCSignature
 * JD-Core Version:    0.6.0
 */