/*     */ package org.jboss.ws.tools;
/*     */ 
/*     */ import java.beans.Introspector;
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.apache.xerces.xs.StringList;
/*     */ import org.apache.xerces.xs.XSAttributeDeclaration;
/*     */ import org.apache.xerces.xs.XSAttributeUse;
/*     */ import org.apache.xerces.xs.XSComplexTypeDefinition;
/*     */ import org.apache.xerces.xs.XSElementDeclaration;
/*     */ import org.apache.xerces.xs.XSModel;
/*     */ import org.apache.xerces.xs.XSModelGroup;
/*     */ import org.apache.xerces.xs.XSObjectList;
/*     */ import org.apache.xerces.xs.XSParticle;
/*     */ import org.apache.xerces.xs.XSSimpleTypeDefinition;
/*     */ import org.apache.xerces.xs.XSTerm;
/*     */ import org.apache.xerces.xs.XSTypeDefinition;
/*     */ import org.apache.xerces.xs.XSWildcard;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ 
/*     */ public class XSDTypeToJava
/*     */ {
/*  64 */   protected LiteralTypeMapping typeMapping = null;
/*  65 */   protected WSDLUtils utils = WSDLUtils.getInstance();
/*  66 */   protected SchemaUtils schemautils = SchemaUtils.getInstance();
/*  67 */   protected WSDLUtils wsdlUtils = WSDLUtils.getInstance();
/*     */ 
/*  69 */   protected JavaWriter jwriter = new JavaWriter();
/*     */ 
/*  72 */   protected String containingElement = "";
/*  73 */   protected String fname = "";
/*  74 */   protected File loc = null;
/*  75 */   protected String pkgname = "";
/*     */ 
/*  77 */   private Set<String> generatedFiles = new HashSet();
/*     */ 
/*  84 */   private Map<String, List> typeNameToBaseVARList = new HashMap();
/*     */ 
/*     */   public void createJavaFile(XSComplexTypeDefinition type, File loc, String pkgname, XSModel schema)
/*     */     throws IOException
/*     */   {
/*  92 */     if (this.typeMapping == null)
/*  93 */       throw new WSException("TypeMapping has not been set");
/*  94 */     this.fname = type.getName();
/*  95 */     if (this.fname == null)
/*  96 */       throw new WSException("File Name is null");
/*  97 */     this.loc = loc;
/*  98 */     this.pkgname = pkgname;
/*     */ 
/* 100 */     createJavaFile(type, schema, false);
/*     */   }
/*     */ 
/*     */   public void createJavaFile(XSComplexTypeDefinition type, String containingElement, File loc, String pkgname, XSModel schema, boolean isExceptionType)
/*     */     throws IOException
/*     */   {
/* 106 */     if (this.typeMapping == null)
/* 107 */       throw new WSException("TypeMapping has not been set");
/* 108 */     this.fname = type.getName();
/* 109 */     this.containingElement = containingElement;
/* 110 */     if (this.fname == null)
/* 111 */       this.fname = containingElement;
/* 112 */     this.loc = loc;
/* 113 */     this.pkgname = pkgname;
/*     */ 
/* 115 */     createJavaFile(type, schema, isExceptionType);
/*     */   }
/*     */ 
/*     */   public void createJavaFile(XSSimpleTypeDefinition type, File loc, String pkgname, XSModel schema) throws IOException
/*     */   {
/* 120 */     if (this.typeMapping == null)
/* 121 */       throw new WSException("TypeMapping has not been set");
/* 122 */     this.fname = type.getName();
/* 123 */     this.loc = loc;
/* 124 */     this.pkgname = pkgname;
/*     */ 
/* 126 */     createJavaFile(type, schema);
/*     */   }
/*     */ 
/*     */   public void createJavaFile(XSComplexTypeDefinition type, XSModel schema, boolean isExceptionType) throws IOException
/*     */   {
/* 131 */     if (this.typeMapping == null)
/* 132 */       throw new WSException("TypeMapping has not been set");
/* 133 */     XSTypeDefinition baseType = type.getBaseType();
/*     */ 
/* 135 */     this.fname = ToolsUtils.convertInvalidCharacters(this.fname);
/*     */ 
/* 137 */     this.fname = this.utils.firstLetterUpperCase(this.fname);
/* 138 */     List vars = new ArrayList();
/*     */ 
/* 140 */     String baseName = getBaseTypeName(type);
/* 141 */     if ((baseName != null) && (baseType != null) && (!this.generatedFiles.contains(baseName)))
/*     */     {
/* 143 */       if ((baseType instanceof XSComplexTypeDefinition))
/*     */       {
/* 145 */         this.generatedFiles.add(baseName);
/* 146 */         String pushName = this.fname;
/* 147 */         this.fname = baseName;
/* 148 */         createJavaFile((XSComplexTypeDefinition)baseType, schema, isExceptionType);
/* 149 */         this.fname = pushName;
/*     */       }
/*     */     }
/*     */ 
/* 153 */     vars = getVARList(type, schema, isExceptionType);
/*     */ 
/* 155 */     if ((baseName == null) && (isExceptionType))
/* 156 */       baseName = "Exception";
/* 157 */     this.jwriter.createJavaFile(this.loc, this.fname, this.pkgname, vars, null, baseName, isExceptionType, this.typeNameToBaseVARList);
/*     */   }
/*     */ 
/*     */   public void createJavaFile(XSSimpleTypeDefinition xsSimple, XSModel schema) throws IOException
/*     */   {
/* 162 */     if (this.typeMapping == null)
/* 163 */       throw new WSException("TypeMapping has not been set");
/* 164 */     XSTypeDefinition baseType = xsSimple.getBaseType();
/*     */ 
/* 166 */     short variety = xsSimple.getVariety();
/* 167 */     if (1 == variety)
/*     */     {
/* 170 */       StringList slist = xsSimple.getLexicalEnumeration();
/* 171 */       if ((slist != null) && (slist.getLength() > 0))
/*     */       {
/* 174 */         this.jwriter.createJavaFileForEnumeratedValues(this.fname, slist, this.loc, this.pkgname, xsSimple);
/*     */       }
/*     */       else
/*     */       {
/* 178 */         if ("http://www.w3.org/2001/XMLSchema".equals(xsSimple.getNamespace())) {
/* 179 */           return;
/*     */         }
/* 181 */         return;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public List<VAR> getVARList(XSComplexTypeDefinition type, XSModel schema, boolean isExceptionType) throws IOException
/*     */   {
/* 188 */     if (this.typeMapping == null)
/* 189 */       throw new WSException("TypeMapping has not been set");
/* 190 */     XSTypeDefinition baseType = type.getBaseType();
/* 191 */     List vars = new ArrayList();
/*     */ 
/* 193 */     vars = handleAttributes(type, vars);
/*     */ 
/* 196 */     short contentType = type.getContentType();
/*     */ 
/* 199 */     if (1 == contentType)
/*     */     {
/* 201 */       short der = type.getDerivationMethod();
/*     */ 
/* 203 */       if (1 == der)
/*     */       {
/* 205 */         XSSimpleTypeDefinition xssimple = type.getSimpleType();
/* 206 */         QName q = new QName(xssimple.getNamespace(), xssimple.getName());
/* 207 */         QName qn = this.schemautils.patchXSDQName(q);
/* 208 */         Class javaType = this.typeMapping.getJavaType(qn);
/* 209 */         String jtype = null;
/* 210 */         if (javaType.isArray())
/*     */         {
/* 212 */           jtype = JavaUtils.getSourceName(javaType);
/*     */         }
/*     */         else
/*     */         {
/* 216 */           jtype = javaType.getName();
/*     */         }
/* 218 */         VAR v = new VAR("_value", jtype, false);
/* 219 */         vars.add(v);
/*     */       }
/*     */     }
/* 222 */     else if (0 == contentType)
/*     */     {
/* 224 */       short der = type.getDerivationMethod();
/*     */ 
/* 226 */       if (2 == der)
/*     */       {
/* 228 */         vars.addAll(createVARsforXSParticle(type, schema));
/*     */       }
/*     */     }
/* 231 */     else if (2 == contentType)
/*     */     {
/* 233 */       if (!this.utils.isBaseTypeIgnorable(baseType, type))
/*     */       {
/* 235 */         short der = type.getDerivationMethod();
/*     */ 
/* 237 */         if (0 == der)
/*     */         {
/* 239 */           handleContentTypeElementsWithDerivationNone(type, schema, isExceptionType, vars, type.getParticle());
/*     */         }
/* 241 */         if (1 == der)
/*     */         {
/* 243 */           handleContentTypeElementsWithDerivationExtension(type, schema, isExceptionType, vars, type.getParticle());
/*     */         }
/* 245 */         else if (2 == der)
/*     */         {
/* 247 */           handleContentTypeElementsWithDerivationRestriction(type, schema, vars, type.getParticle());
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 253 */         vars.addAll(createVARsforXSParticle(type, schema));
/*     */       }
/*     */     }
/*     */ 
/* 257 */     return vars;
/*     */   }
/*     */ 
/*     */   public void setPackageName(String packageName)
/*     */   {
/* 263 */     this.pkgname = packageName;
/*     */   }
/*     */ 
/*     */   public void setTypeMapping(LiteralTypeMapping tm)
/*     */   {
/* 268 */     this.typeMapping = tm;
/*     */   }
/*     */ 
/*     */   private void handleContentTypeElementsWithDerivationRestriction(XSComplexTypeDefinition type, XSModel schema, List vars, XSParticle xsparticle)
/*     */     throws IOException
/*     */   {
/* 275 */     if (xsparticle != null)
/*     */     {
/* 277 */       XSTerm xsterm = xsparticle.getTerm();
/* 278 */       if ((xsterm instanceof XSModelGroup))
/*     */       {
/* 280 */         XSModelGroup xsm = (XSModelGroup)xsterm;
/* 281 */         XSObjectList xparts = xsm.getParticles();
/*     */ 
/* 283 */         XSParticle xspar = (XSParticle)xparts.item(1);
/* 284 */         XSTerm xterm = xspar.getTerm();
/* 285 */         if ((xterm instanceof XSElementDeclaration))
/*     */         {
/* 287 */           vars.addAll(createVARforXSElementDeclaration(xterm, this.schemautils.isArrayType(xspar), schema, type));
/*     */         }
/* 289 */         else if ((xterm instanceof XSModelGroup))
/*     */         {
/* 291 */           XSModelGroup xsmodelgrp = (XSModelGroup)xterm;
/* 292 */           vars.addAll(createVARsforXSModelGroup(xsmodelgrp, schema, type));
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void handleContentTypeElementsWithDerivationExtension(XSComplexTypeDefinition type, XSModel schema, boolean isExceptionType, List vars, XSParticle xsparticle)
/*     */     throws IOException
/*     */   {
/* 301 */     if (xsparticle != null)
/*     */     {
/* 303 */       XSTerm xsterm = xsparticle.getTerm();
/* 304 */       if ((xsterm instanceof XSModelGroup))
/*     */       {
/* 306 */         XSModelGroup xsm = (XSModelGroup)xsterm;
/* 307 */         XSObjectList xparts = xsm.getParticles();
/*     */ 
/* 309 */         int length = xparts.getLength();
/*     */ 
/* 311 */         XSTypeDefinition baseType = type.getBaseType();
/*     */ 
/* 313 */         if (((baseType instanceof XSComplexTypeDefinition)) && (((XSComplexTypeDefinition)baseType).getContentType() != 0))
/*     */         {
/* 315 */           XSTerm baseTerm = ((XSComplexTypeDefinition)baseType).getParticle().getTerm();
/* 316 */           if ((isExceptionType) && ((baseTerm instanceof XSModelGroup)))
/*     */           {
/* 318 */             this.typeNameToBaseVARList.put(type.getName(), createVARsforXSModelGroup((XSModelGroup)baseTerm, schema, type));
/*     */           }
/*     */ 
/* 323 */           if ((!(baseType instanceof XSComplexTypeDefinition)) || (((XSComplexTypeDefinition)baseType).getParticle().getTerm() == xsterm))
/* 324 */             return;
/*     */         }
/*     */         XSParticle xspar;
/*     */         XSParticle xspar;
/* 329 */         if (((baseType instanceof XSComplexTypeDefinition)) && (((XSComplexTypeDefinition)baseType).getContentType() == 0))
/*     */         {
/* 332 */           xspar = xsparticle;
/*     */         }
/*     */         else
/*     */         {
/* 336 */           xspar = (XSParticle)xparts.item(length - 1);
/*     */         }
/*     */ 
/* 339 */         XSTerm xsparTerm = xspar.getTerm();
/* 340 */         if ((xsparTerm instanceof XSModelGroup))
/*     */         {
/* 342 */           XSModelGroup xsmodelgrp = (XSModelGroup)xspar.getTerm();
/* 343 */           vars.addAll(createVARsforXSModelGroup(xsmodelgrp, schema, type));
/*     */         }
/* 345 */         else if ((xsparTerm instanceof XSElementDeclaration)) {
/* 346 */           vars.addAll(createVARforXSElementDeclaration(xsparTerm, this.schemautils.isArrayType(xspar), schema, type));
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void handleContentTypeElementsWithDerivationNone(XSComplexTypeDefinition type, XSModel schema, boolean isExceptionType, List vars, XSParticle xsparticle)
/*     */     throws IOException
/*     */   {
/* 355 */     if (xsparticle != null)
/*     */     {
/* 357 */       XSTerm xsterm = xsparticle.getTerm();
/* 358 */       if ((xsterm instanceof XSModelGroup))
/*     */       {
/* 360 */         XSModelGroup xsm = (XSModelGroup)xsterm;
/* 361 */         XSObjectList xparts = xsm.getParticles();
/* 362 */         int len = xparts != null ? xparts.getLength() : 0;
/* 363 */         int diff = len - 0;
/*     */ 
/* 365 */         for (int i = 0; i < len; i++)
/*     */         {
/* 367 */           if ((isExceptionType) && (type.getBaseType() != null))
/*     */           {
/* 369 */             List baseList = new ArrayList();
/*     */ 
/* 372 */             for (int j = 0; j < diff - 1; j++)
/*     */             {
/* 374 */               XSParticle xspar = (XSParticle)xparts.item(j);
/* 375 */               XSTerm xsparTerm = xspar.getTerm();
/* 376 */               if (!(xsparTerm instanceof XSModelGroup))
/*     */                 continue;
/* 378 */               XSModelGroup xsmodelgrp = (XSModelGroup)xspar.getTerm();
/* 379 */               baseList.addAll(createVARsforXSModelGroup(xsmodelgrp, schema, type));
/*     */             }
/*     */ 
/* 383 */             if (baseList.size() > 0) {
/* 384 */               this.typeNameToBaseVARList.put(type.getName(), baseList);
/*     */             }
/* 386 */             XSParticle xspar = (XSParticle)xparts.item(len - 1);
/* 387 */             XSTerm xsparTerm = xspar.getTerm();
/* 388 */             if (!(xsparTerm instanceof XSModelGroup))
/*     */               break;
/* 390 */             XSModelGroup xsmodelgrp = (XSModelGroup)xspar.getTerm();
/* 391 */             vars.addAll(createVARsforXSModelGroup(xsmodelgrp, schema, type));
/* 392 */             break;
/*     */           }
/*     */ 
/* 395 */           XSParticle xspar = (XSParticle)xparts.item(i);
/* 396 */           XSTerm xsparTerm = xspar.getTerm();
/* 397 */           if ((xsparTerm instanceof XSModelGroup))
/*     */           {
/* 399 */             XSModelGroup xsmodelgrp = (XSModelGroup)xspar.getTerm();
/* 400 */             vars.addAll(createVARsforXSModelGroup(xsmodelgrp, schema, type));
/*     */           }
/* 402 */           else if ((xsparTerm instanceof XSElementDeclaration)) {
/* 403 */             vars.addAll(createVARforXSElementDeclaration(xsparTerm, this.schemautils.isArrayType(xspar), schema, type));
/*     */           }
/*     */         }
/* 406 */       } else if ((xsterm instanceof XSElementDeclaration))
/*     */       {
/* 408 */         vars.addAll(createVARforXSElementDeclaration(xsterm, this.schemautils.isArrayType(xsparticle), schema, type));
/*     */       } else {
/* 410 */         throw new WSException("Unhandled Type");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private List handleAttributes(XSComplexTypeDefinition type, List vars)
/*     */   {
/* 417 */     XSObjectList xsobjlist = type.getAttributeUses();
/* 418 */     if (xsobjlist != null)
/*     */     {
/* 420 */       int len = xsobjlist.getLength();
/* 421 */       for (int i = 0; i < len; i++)
/*     */       {
/* 423 */         XSAttributeUse obj = (XSAttributeUse)xsobjlist.item(i);
/* 424 */         XSAttributeDeclaration att = obj.getAttrDeclaration();
/* 425 */         XSSimpleTypeDefinition xstype = att.getTypeDefinition();
/* 426 */         QName qn = SchemaUtils.handleSimpleType(xstype);
/* 427 */         boolean primitive = obj.getRequired();
/* 428 */         VAR v = createVAR(qn, att.getName(), this.pkgname, primitive);
/* 429 */         if (vars == null)
/* 430 */           vars = new ArrayList();
/* 431 */         vars.add(v);
/*     */       }
/*     */     }
/* 434 */     return vars;
/*     */   }
/*     */ 
/*     */   private List createVARsforXSParticle(XSComplexTypeDefinition type, XSModel schema) throws IOException
/*     */   {
/* 439 */     List list = new ArrayList();
/* 440 */     XSParticle xsparticle = type.getParticle();
/*     */ 
/* 442 */     if (xsparticle != null)
/*     */     {
/* 444 */       short xsptype = xsparticle.getType();
/* 445 */       XSTerm xsterm = xsparticle.getTerm();
/* 446 */       if (xsptype != 2)
/*     */       {
/* 450 */         if ((xsterm instanceof XSModelGroup))
/*     */         {
/* 452 */           XSModelGroup xsm = (XSModelGroup)xsterm;
/* 453 */           XSObjectList xparts = xsm.getParticles();
/* 454 */           list.addAll(createVARsForElements(xparts, schema, type));
/*     */         }
/*     */       }
/*     */     }
/* 457 */     return list;
/*     */   }
/*     */ 
/*     */   private List<VAR> createVARsforXSModelGroup(XSModelGroup xsm, XSModel schema, XSComplexTypeDefinition origType) throws IOException
/*     */   {
/* 462 */     List vars = new ArrayList();
/* 463 */     short compositor = xsm.getCompositor();
/*     */ 
/* 465 */     if (1 == compositor)
/*     */     {
/* 467 */       XSObjectList xsobjlist = xsm.getParticles();
/* 468 */       int len = xsobjlist.getLength();
/*     */ 
/* 470 */       for (int i = 0; i < len; i++)
/*     */       {
/* 472 */         XSParticle xsparticle = (XSParticle)xsobjlist.item(i);
/* 473 */         XSTerm term = xsparticle.getTerm();
/*     */ 
/* 475 */         if ((term instanceof XSElementDeclaration))
/*     */         {
/* 477 */           vars.addAll(createVARforXSElementDeclaration(term, this.schemautils.isArrayType(xsparticle), schema, origType));
/*     */         } else {
/* 479 */           if (!(term instanceof XSModelGroup))
/*     */             continue;
/* 481 */           vars.addAll(createVARsforXSModelGroup((XSModelGroup)term, schema, origType));
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 486 */     return vars;
/*     */   }
/*     */ 
/*     */   private VAR createVAR(QName qn, String varstr, String pkgname, boolean primitive)
/*     */   {
/* 491 */     String clname = "";
/* 492 */     Class cls = this.typeMapping.getJavaType(qn);
/* 493 */     VAR v = null;
/* 494 */     if (cls != null)
/*     */     {
/* 496 */       clname = cls.getName();
/* 497 */       if (primitive)
/*     */       {
/* 499 */         String primName = this.utils.getPrimitive(clname);
/* 500 */         if (primName != null) {
/* 501 */           clname = primName;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/* 507 */     else if (qn != null)
/*     */     {
/* 509 */       if (!"http://www.w3.org/2001/XMLSchema".equals(qn.getNamespaceURI()))
/* 510 */         clname = pkgname + ".";
/* 511 */       clname = clname + qn.getLocalPart();
/*     */     }
/*     */ 
/* 514 */     v = new VAR(varstr, clname, false);
/* 515 */     return v;
/*     */   }
/*     */ 
/*     */   private List createVARsForElements(XSObjectList xsobjlist, XSModel schema, XSComplexTypeDefinition origType) throws IOException
/*     */   {
/* 520 */     List list = new ArrayList();
/* 521 */     int len = xsobjlist.getLength();
/* 522 */     for (int i = 0; i < len; i++)
/*     */     {
/* 524 */       XSParticle xsparticle = (XSParticle)xsobjlist.item(i);
/* 525 */       XSTerm xsterm = xsparticle.getTerm();
/*     */ 
/* 527 */       list.addAll(createVARforXSElementDeclaration(xsterm, this.schemautils.isArrayType(xsparticle), schema, origType));
/*     */     }
/*     */ 
/* 531 */     return list;
/*     */   }
/*     */ 
/*     */   private List createVARforXSElementDeclaration(XSTerm xsterm, boolean arrayType, XSModel schema, XSComplexTypeDefinition origType) throws IOException
/*     */   {
/* 536 */     List vars = new ArrayList();
/*     */ 
/* 538 */     if ((xsterm instanceof XSWildcard))
/*     */     {
/* 540 */       VAR v = new VAR("_any", "javax.xml.soap.SOAPElement", arrayType);
/* 541 */       vars.add(v);
/* 542 */       return vars;
/*     */     }
/*     */ 
/* 546 */     if ((xsterm instanceof XSModelGroup))
/*     */     {
/* 548 */       vars.addAll(createVARsforXSModelGroup((XSModelGroup)xsterm, schema, origType));
/* 549 */       return vars;
/*     */     }
/*     */ 
/* 552 */     XSElementDeclaration elem = (XSElementDeclaration)xsterm;
/*     */ 
/* 559 */     String tname = elem.getName();
/* 560 */     XSTypeDefinition xstypedef = elem.getTypeDefinition();
/*     */ 
/* 562 */     String xstypename = xstypedef.getName();
/*     */ 
/* 564 */     if ((xstypename != null) && (xstypedef.getName().equals(origType.getName())) && (xstypedef.getNamespace().equals(origType.getNamespace())))
/*     */     {
/* 567 */       QName qn = new QName(origType.getNamespace(), origType.getName());
/* 568 */       VAR vr = createVAR(qn, elem, (XSComplexTypeDefinition)xstypedef, tname, this.pkgname, arrayType);
/* 569 */       vars.add(vr);
/* 570 */       return vars;
/*     */     }
/*     */ 
/* 574 */     if ((xstypename == null) && ((xstypedef instanceof XSComplexTypeDefinition)))
/*     */     {
/* 576 */       XSComplexTypeDefinition xsc = (XSComplexTypeDefinition)xstypedef;
/* 577 */       String subname = this.utils.firstLetterUpperCase(tname);
/*     */ 
/* 579 */       String tempfname = this.fname;
/*     */ 
/* 581 */       if ((this.containingElement == null) || (this.containingElement.length() == 0))
/* 582 */         this.containingElement = origType.getName();
/*     */       String anonName;
/* 585 */       if (elem.getScope() == 1)
/*     */       {
/* 587 */         anonName = subname;
/*     */       }
/*     */       else
/*     */       {
/* 591 */         anonName = this.containingElement + subname;
/*     */       }
/*     */ 
/* 594 */       String anonName = this.utils.firstLetterUpperCase(anonName);
/* 595 */       this.fname = anonName;
/*     */ 
/* 597 */       if (!this.generatedFiles.contains(this.fname))
/*     */       {
/* 599 */         this.generatedFiles.add(this.fname);
/* 600 */         createJavaFile((XSComplexTypeDefinition)xstypedef, schema, false);
/*     */       }
/*     */ 
/* 604 */       this.fname = tempfname;
/*     */ 
/* 606 */       QName anonqn = new QName(anonName);
/* 607 */       VAR vr = createVAR(anonqn, elem, xsc, tname, this.pkgname, arrayType);
/* 608 */       vars.add(vr);
/* 609 */       return vars;
/*     */     }
/*     */ 
/* 613 */     String temp = this.fname;
/*     */ 
/* 615 */     if (SchemaUtils.isWrapperArrayType(xstypedef))
/*     */     {
/* 617 */       XSComplexTypeDefinition complex = (XSComplexTypeDefinition)xstypedef;
/* 618 */       XSModelGroup group = (XSModelGroup)complex.getParticle().getTerm();
/* 619 */       XSElementDeclaration element = (XSElementDeclaration)((XSParticle)group.getParticles().item(0)).getTerm();
/* 620 */       xstypedef = element.getTypeDefinition();
/* 621 */       xstypename = xstypedef.getName();
/* 622 */       arrayType = true;
/*     */     }
/*     */ 
/* 625 */     QName qn = null;
/* 626 */     if ((xstypedef instanceof XSSimpleTypeDefinition))
/*     */     {
/* 628 */       qn = SchemaUtils.handleSimpleType((XSSimpleTypeDefinition)xstypedef);
/*     */     }
/*     */     else
/*     */     {
/* 632 */       qn = new QName(xstypedef.getNamespace(), xstypename);
/*     */     }
/*     */ 
/* 635 */     if ((xstypename != null) && ((xstypedef instanceof XSComplexTypeDefinition)))
/*     */     {
/* 637 */       this.fname = ToolsUtils.convertInvalidCharacters(this.utils.firstLetterUpperCase(xstypename));
/* 638 */       if (!this.generatedFiles.contains(this.fname))
/*     */       {
/* 640 */         this.generatedFiles.add(this.fname);
/* 641 */         createJavaFile((XSComplexTypeDefinition)xstypedef, schema, false);
/*     */       }
/* 643 */       this.fname = temp;
/*     */     }
/*     */ 
/* 646 */     VAR v = createVAR(qn, elem, xstypedef, tname, this.pkgname, arrayType);
/* 647 */     vars.add(v);
/*     */ 
/* 649 */     return vars;
/*     */   }
/*     */ 
/*     */   private VAR createVAR(QName qn, XSElementDeclaration elem, XSTypeDefinition t, String varstr, String pkgname, boolean arrayType)
/*     */   {
/* 654 */     if ((t instanceof XSSimpleTypeDefinition))
/*     */     {
/* 656 */       QName tempqn = SchemaUtils.handleSimpleType((XSSimpleTypeDefinition)t);
/* 657 */       if (tempqn != null)
/* 658 */         qn = tempqn;
/*     */     }
/* 660 */     String qualifiedClassName = "";
/* 661 */     Class cls = this.typeMapping.getJavaType(qn);
/* 662 */     VAR v = null;
/* 663 */     if (cls != null)
/*     */     {
/* 665 */       qualifiedClassName = JavaUtils.getSourceName(cls);
/* 666 */       String primitive = this.utils.getPrimitive(qualifiedClassName);
/* 667 */       if ((!elem.getNillable()) && (primitive != null))
/* 668 */         qualifiedClassName = primitive;
/*     */     }
/*     */     else
/*     */     {
/* 672 */       QName typename = null;
/*     */ 
/* 674 */       if (t.getName() == null)
/* 675 */         typename = qn;
/* 676 */       else typename = new QName(t.getName());
/* 677 */       if (typename != null)
/*     */       {
/* 679 */         String nsuri = typename.getNamespaceURI();
/* 680 */         if (!nsuri.equals("http://www.w3.org/2001/XMLSchema"))
/* 681 */           qualifiedClassName = pkgname + ".";
/* 682 */         String className = this.wsdlUtils.firstLetterUpperCase(ToolsUtils.convertInvalidCharacters(typename.getLocalPart()));
/* 683 */         qualifiedClassName = qualifiedClassName + className;
/*     */       }
/* 685 */       else if (qn != null) {
/* 686 */         qualifiedClassName = qn.getLocalPart();
/*     */       }
/*     */     }
/* 689 */     v = new VAR(Introspector.decapitalize(varstr), qualifiedClassName, arrayType);
/* 690 */     return v;
/*     */   }
/*     */ 
/*     */   private String getBaseTypeName(XSComplexTypeDefinition type)
/*     */   {
/* 695 */     String baseName = null;
/* 696 */     XSTypeDefinition baseType = null;
/* 697 */     if ((type instanceof XSComplexTypeDefinition))
/*     */     {
/* 699 */       XSComplexTypeDefinition t = type;
/*     */ 
/* 701 */       baseType = t.getBaseType();
/*     */ 
/* 703 */       if (baseType != null)
/*     */       {
/* 705 */         if ((baseType.getNamespace() == "http://www.w3.org/2001/XMLSchema") && (baseType.getName().equals("anyType")))
/* 706 */           baseType = null;
/*     */       }
/* 708 */       if (1 == t.getContentType())
/*     */       {
/* 710 */         baseType = null;
/*     */       }
/*     */     }
/*     */ 
/* 714 */     if ((baseName == null) && (baseType != null)) {
/* 715 */       baseName = baseType.getName();
/*     */     }
/* 717 */     return baseName;
/*     */   }
/*     */ 
/*     */   public static class VAR
/*     */   {
/*     */     String varname;
/*     */     String vartype;
/* 728 */     boolean isArrayType = false;
/*     */ 
/*     */     public VAR(String varname, String vartype, boolean arrayType)
/*     */     {
/* 732 */       this.varname = varname;
/* 733 */       this.vartype = vartype;
/* 734 */       this.isArrayType = arrayType;
/*     */     }
/*     */ 
/*     */     public String getVarname()
/*     */     {
/* 739 */       return this.varname;
/*     */     }
/*     */ 
/*     */     public void setVarname(String varname)
/*     */     {
/* 744 */       this.varname = varname;
/*     */     }
/*     */ 
/*     */     public String getVartype()
/*     */     {
/* 749 */       return this.vartype;
/*     */     }
/*     */ 
/*     */     public void setVartype(String vartype)
/*     */     {
/* 754 */       this.vartype = vartype;
/*     */     }
/*     */ 
/*     */     public boolean isArrayType()
/*     */     {
/* 759 */       return this.isArrayType;
/*     */     }
/*     */ 
/*     */     public void setArrayType(boolean arrayType)
/*     */     {
/* 764 */       this.isArrayType = arrayType;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.XSDTypeToJava
 * JD-Core Version:    0.6.0
 */