/*     */ package org.jboss.ws.tools.helpers;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.ParameterMode;
/*     */ import javax.xml.rpc.encoding.TypeMapping;
/*     */ import javax.xml.rpc.holders.Holder;
/*     */ import org.apache.xerces.xs.XSTypeDefinition;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.soap.Style;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.ExceptionMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaXmlTypeMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.MethodParamPartsMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.PackageMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.PortMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointMethodMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.ServiceInterfaceMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.VariableMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.WsdlMessageMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.WsdlReturnValueMapping;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.FaultMetaData;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.WrappedParameter;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLBinding;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLInterface;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLService;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLTypes;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLUtils;
/*     */ import org.jboss.ws.metadata.wsdl.XSModelTypes;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSElementDeclaration;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.WSSchemaUtils;
/*     */ import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
/*     */ import org.jboss.ws.tools.JavaToXSD;
/*     */ import org.jboss.ws.tools.interfaces.JavaToXSDIntf;
/*     */ import org.jboss.ws.tools.interfaces.SchemaCreatorIntf;
/*     */ import org.jboss.ws.tools.wsdl.WSDLGenerator;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ 
/*     */ public class JavaToWSDLHelper extends WSDLGenerator
/*     */ {
/*  81 */   private JavaToXSDIntf javaToXSD = new JavaToXSD();
/*  82 */   private JavaWsdlMapping javaWsdlMapping = new JavaWsdlMapping();
/*  83 */   private Map<QName, JavaXmlTypeMapping> mappedTypes = new HashMap();
/*  84 */   private Set<String> mappedPackages = new HashSet();
/*  85 */   private Map<String, String> packageNamespaceMap = new HashMap();
/*  86 */   private Set<String> mappedExceptions = new HashSet();
/*     */ 
/*     */   protected void processTypes()
/*     */   {
/*  91 */     this.wsdl.setWsdlTypes(new XSModelTypes());
/*     */   }
/*     */ 
/*     */   protected void processOperation(WSDLInterface wsdlInterface, WSDLBinding wsdlBinding, OperationMetaData operation)
/*     */   {
/*  97 */     super.processOperation(wsdlInterface, wsdlBinding, operation);
/*     */     try
/*     */     {
/* 102 */       for (ParameterMetaData paramMetaData : operation.getParameters())
/*     */       {
/* 104 */         generateTypesForXSD(paramMetaData);
/*     */       }
/*     */ 
/* 107 */       for (FaultMetaData faultMetaData : operation.getFaults())
/*     */       {
/* 109 */         generateTypesForXSD(faultMetaData);
/*     */       }
/*     */ 
/* 112 */       ParameterMetaData returnMetaData = operation.getReturnParameter();
/* 113 */       if (returnMetaData != null)
/*     */       {
/* 115 */         generateTypesForXSD(returnMetaData);
/*     */       }
/*     */     }
/*     */     catch (IOException io)
/*     */     {
/* 120 */       throw new WSException(io);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void generateTypesForXSD(ParameterMetaData pmd)
/*     */     throws IOException
/*     */   {
/* 127 */     QName xmlType = pmd.getXmlType();
/* 128 */     if (!xmlType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
/* 129 */       generateType(xmlType, pmd.getJavaType(), buildElementNameMap(pmd));
/*     */     }
/* 131 */     if ((pmd.getOperationMetaData().getStyle() == Style.DOCUMENT) || (pmd.isInHeader())) {
/* 132 */       generateElement(pmd.getXmlName(), xmlType);
/*     */     }
/*     */ 
/* 135 */     if (pmd.isSwA())
/* 136 */       this.wsdl.registerNamespaceURI("http://schemas.xmlsoap.org/wsdl/mime/", "mime");
/*     */   }
/*     */ 
/*     */   private Map<String, QName> buildElementNameMap(ParameterMetaData pmd)
/*     */   {
/* 141 */     List wrappedParameters = pmd.getWrappedParameters();
/*     */ 
/* 143 */     if (wrappedParameters == null) {
/* 144 */       return null;
/*     */     }
/* 146 */     Map map = new LinkedHashMap(wrappedParameters.size());
/*     */ 
/* 148 */     for (WrappedParameter param : wrappedParameters) {
/* 149 */       map.put(param.getVariable(), param.getName());
/*     */     }
/* 151 */     return map;
/*     */   }
/*     */ 
/*     */   public void generateTypesForXSD(FaultMetaData fmd)
/*     */     throws IOException
/*     */   {
/* 157 */     SchemaCreatorIntf sc = this.javaToXSD.getSchemaCreator();
/*     */ 
/* 159 */     QName xmlType = fmd.getXmlType();
/* 160 */     if (!xmlType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema"))
/* 161 */       generateType(xmlType, fmd.getJavaType(), null);
/*     */   }
/*     */ 
/*     */   public void processEndpoint(WSDLService service, EndpointMetaData endpoint)
/*     */   {
/* 166 */     super.processEndpoint(service, endpoint);
/*     */ 
/* 169 */     buildServiceMapping(endpoint);
/*     */   }
/*     */ 
/*     */   private void buildServiceMapping(EndpointMetaData endpoint)
/*     */   {
/* 178 */     QName origQName = endpoint.getServiceMetaData().getServiceName();
/* 179 */     String serviceInterfaceName = endpoint.getServiceEndpointInterface().getPackage().getName() + "." + origQName.getLocalPart();
/* 180 */     QName serviceQName = new QName(origQName.getNamespaceURI(), origQName.getLocalPart(), "serviceNS");
/*     */ 
/* 182 */     ServiceInterfaceMapping serviceMapping = new ServiceInterfaceMapping(this.javaWsdlMapping);
/* 183 */     serviceMapping.setServiceInterface(serviceInterfaceName);
/* 184 */     serviceMapping.setWsdlServiceName(serviceQName);
/*     */ 
/* 186 */     String endpointName = endpoint.getPortName().getLocalPart();
/* 187 */     PortMapping portMapping = new PortMapping(serviceMapping);
/* 188 */     portMapping.setJavaPortName(endpointName);
/* 189 */     portMapping.setPortName(endpointName);
/* 190 */     serviceMapping.addPortMapping(portMapping);
/*     */ 
/* 192 */     this.javaWsdlMapping.addServiceInterfaceMappings(serviceMapping);
/*     */ 
/* 194 */     String interfaceName = endpoint.getPortTypeName().getLocalPart();
/* 195 */     ServiceEndpointInterfaceMapping seiMapping = new ServiceEndpointInterfaceMapping(this.javaWsdlMapping);
/* 196 */     seiMapping.setServiceEndpointInterface(endpoint.getServiceEndpointInterfaceName());
/* 197 */     seiMapping.setWsdlPortType(new QName(this.wsdl.getTargetNamespace(), interfaceName, "portTypeNS"));
/* 198 */     seiMapping.setWsdlBinding(new QName(this.wsdl.getTargetNamespace(), interfaceName + "Binding", "bindingNS"));
/* 199 */     for (OperationMetaData operation : endpoint.getOperations())
/*     */     {
/* 201 */       ServiceEndpointMethodMapping methodMapping = new ServiceEndpointMethodMapping(seiMapping);
/* 202 */       methodMapping.setJavaMethodName(operation.getJavaName());
/* 203 */       methodMapping.setWsdlOperation(operation.getQName().getLocalPart());
/* 204 */       boolean isWrapped = operation.isDocumentWrapped();
/* 205 */       methodMapping.setWrappedElement(isWrapped);
/* 206 */       int i = 0;
/* 207 */       for (ParameterMetaData param : operation.getParameters())
/*     */       {
/* 209 */         if ((isWrapped) && (!param.isInHeader()))
/*     */         {
/* 211 */           List wrappedParameters = param.getWrappedParameters();
/* 212 */           for (WrappedParameter wrapped : wrappedParameters)
/*     */           {
/* 214 */             String type = JavaUtils.convertJVMNameToSourceName(wrapped.getType(), endpoint.getClassLoader());
/* 215 */             String name = wrapped.getName().getLocalPart();
/*     */ 
/* 217 */             buildParamMapping(methodMapping, interfaceName, operation, name, type, "IN", false, i++);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 222 */           String name = param.getXmlName().getLocalPart();
/* 223 */           String type = JavaUtils.convertJVMNameToSourceName(param.getJavaTypeName(), endpoint.getClassLoader());
/* 224 */           buildParamMapping(methodMapping, interfaceName, operation, name, type, param.getMode().toString(), param.isInHeader(), i++);
/*     */         }
/*     */       }
/*     */ 
/* 228 */       ParameterMetaData returnParam = operation.getReturnParameter();
/* 229 */       if ((returnParam != null) && ((!isWrapped) || (!returnParam.getWrappedParameters().isEmpty())))
/*     */       {
/*     */         String type;
/*     */         String name;
/* 232 */         if (isWrapped)
/*     */         {
/* 234 */           WrappedParameter wrappedParameter = (WrappedParameter)returnParam.getWrappedParameters().get(0);
/* 235 */           String name = wrappedParameter.getName().getLocalPart();
/* 236 */           type = wrappedParameter.getType();
/*     */         }
/*     */         else
/*     */         {
/* 240 */           name = returnParam.getXmlName().getLocalPart();
/* 241 */           type = returnParam.getJavaTypeName();
/*     */         }
/*     */ 
/* 244 */         String type = JavaUtils.convertJVMNameToSourceName(type, endpoint.getClassLoader());
/*     */ 
/* 246 */         buildReturnParamMapping(methodMapping, interfaceName, operation, name, type);
/*     */       }
/* 248 */       seiMapping.addServiceEndpointMethodMapping(methodMapping);
/*     */ 
/* 250 */       for (FaultMetaData fmd : operation.getFaults())
/*     */       {
/* 252 */         JavaXmlTypeMapping typeMapping = (JavaXmlTypeMapping)this.mappedTypes.get(fmd.getXmlType());
/* 253 */         if (typeMapping == null) {
/*     */           continue;
/*     */         }
/* 256 */         String javaTypeName = fmd.getJavaTypeName();
/* 257 */         if (this.mappedExceptions.contains(javaTypeName)) {
/*     */           continue;
/*     */         }
/* 260 */         this.mappedExceptions.add(javaTypeName);
/*     */ 
/* 262 */         ExceptionMapping mapping = new ExceptionMapping(this.javaWsdlMapping);
/*     */ 
/* 264 */         mapping.setExceptionType(javaTypeName);
/* 265 */         QName name = new QName(this.wsdl.getTargetNamespace(), fmd.getXmlName().getLocalPart());
/* 266 */         mapping.setWsdlMessage(name);
/*     */ 
/* 269 */         for (VariableMapping variableMapping : typeMapping.getVariableMappings()) {
/* 270 */           mapping.addConstructorParameter(variableMapping.getXmlElementName());
/*     */         }
/* 272 */         this.javaWsdlMapping.addExceptionMappings(mapping);
/*     */       }
/*     */     }
/*     */ 
/* 276 */     this.javaWsdlMapping.addServiceEndpointInterfaceMappings(seiMapping);
/*     */ 
/* 279 */     String name = endpoint.getServiceEndpointInterface().getPackage().getName();
/* 280 */     String namespace = (String)this.packageNamespaceMap.get(name);
/* 281 */     if (namespace == null) {
/* 282 */       WSDLUtils.getInstance(); namespace = WSDLUtils.getTypeNamespace(name);
/* 283 */     }addPackageMapping(name, namespace);
/*     */   }
/*     */ 
/*     */   private void buildParamMapping(ServiceEndpointMethodMapping methodMapping, String interfaceName, OperationMetaData operation, String name, String type, String mode, boolean header, int position)
/*     */   {
/* 289 */     MethodParamPartsMapping paramMapping = new MethodParamPartsMapping(methodMapping);
/* 290 */     paramMapping.setParamPosition(position);
/* 291 */     paramMapping.setParamType(type);
/*     */ 
/* 293 */     WsdlMessageMapping messageMapping = new WsdlMessageMapping(paramMapping);
/* 294 */     messageMapping.setWsdlMessagePartName(name);
/* 295 */     String messageName = interfaceName + "_" + operation.getQName().getLocalPart();
/* 296 */     if ("OUT".equals(mode))
/* 297 */       messageName = messageName + "Response";
/* 298 */     QName messageQName = new QName(this.wsdl.getTargetNamespace(), messageName, "wsdlMsgNS");
/*     */ 
/* 300 */     messageMapping.setWsdlMessage(messageQName);
/* 301 */     messageMapping.setParameterMode(mode);
/* 302 */     messageMapping.setSoapHeader(header);
/* 303 */     paramMapping.setWsdlMessageMapping(messageMapping);
/* 304 */     methodMapping.addMethodParamPartsMapping(paramMapping);
/*     */   }
/*     */ 
/*     */   private void buildReturnParamMapping(ServiceEndpointMethodMapping methodMapping, String interfaceName, OperationMetaData operation, String name, String type)
/*     */   {
/* 309 */     WsdlReturnValueMapping returnMapping = new WsdlReturnValueMapping(methodMapping);
/* 310 */     returnMapping.setMethodReturnValue(type);
/* 311 */     returnMapping.setWsdlMessagePartName(name);
/* 312 */     String messageName = interfaceName + "_" + operation.getQName().getLocalPart() + "Response";
/* 313 */     QName messageQName = new QName(this.wsdl.getTargetNamespace(), messageName, "wsdlMsgNS");
/* 314 */     returnMapping.setWsdlMessage(messageQName);
/* 315 */     methodMapping.setWsdlReturnValueMapping(returnMapping);
/*     */   }
/*     */ 
/*     */   public TypeMapping getTypeMapping()
/*     */   {
/* 326 */     return this.javaToXSD.getSchemaCreator().getTypeMapping();
/*     */   }
/*     */ 
/*     */   public void setPackageNamespaceMap(Map<String, String> map)
/*     */   {
/* 336 */     this.packageNamespaceMap = map;
/* 337 */     this.javaToXSD.setPackageNamespaceMap(map);
/*     */   }
/*     */ 
/*     */   public void setJavaToXSD(JavaToXSDIntf jxsd)
/*     */   {
/* 342 */     this.javaToXSD = jxsd;
/*     */   }
/*     */ 
/*     */   public JavaWsdlMapping getJavaWsdlMapping()
/*     */   {
/* 347 */     return this.javaWsdlMapping;
/*     */   }
/*     */ 
/*     */   protected void generateType(QName xmlType, Class javaType, Map<String, QName> elementNames)
/*     */     throws IOException
/*     */   {
/* 358 */     if (Holder.class.isAssignableFrom(javaType))
/* 359 */       javaType = WSDLUtils.getInstance().getJavaTypeForHolder(javaType);
/* 360 */     JBossXSModel xsModel = this.javaToXSD.generateForSingleType(xmlType, javaType, elementNames);
/*     */ 
/* 364 */     if (xsModel == null) {
/* 365 */       throw new WSException("XSModel is null");
/*     */     }
/* 367 */     WSDLTypes wsdlTypes = this.wsdl.getWsdlTypes();
/* 368 */     WSDLUtils.addSchemaModel(wsdlTypes, xmlType.getNamespaceURI(), xsModel);
/* 369 */     this.wsdl.registerNamespaceURI(xmlType.getNamespaceURI(), null);
/*     */ 
/* 372 */     SchemaCreatorIntf schemaCreator = this.javaToXSD.getSchemaCreator();
/* 373 */     mergeJavaWsdlMapping(schemaCreator.getJavaWsdlMapping());
/*     */ 
/* 375 */     HashMap map = schemaCreator.getCustomNamespaceMap();
/* 376 */     Set keys = map != null ? map.keySet() : null;
/* 377 */     Iterator iter = (keys != null) && (!keys.isEmpty()) ? keys.iterator() : null;
/* 378 */     while ((iter != null) && (iter.hasNext()))
/*     */     {
/* 380 */       String pref = (String)iter.next();
/* 381 */       String ns = (String)map.get(pref);
/* 382 */       if (ns != null)
/* 383 */         this.wsdl.registerNamespaceURI(ns, null);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void mergeJavaWsdlMapping(JavaWsdlMapping source)
/*     */   {
/* 390 */     for (PackageMapping packageMapping : source.getPackageMappings())
/*     */     {
/* 392 */       String name = packageMapping.getPackageType();
/* 393 */       String namespaceURI = packageMapping.getNamespaceURI();
/*     */ 
/* 395 */       addPackageMapping(name, namespaceURI);
/*     */     }
/*     */ 
/* 398 */     for (JavaXmlTypeMapping type : source.getJavaXmlTypeMappings())
/*     */     {
/* 400 */       QName name = type.getRootTypeQName();
/* 401 */       if (name == null) {
/* 402 */         name = type.getAnonymousTypeQName();
/*     */       }
/* 404 */       if (this.mappedTypes.containsKey(name)) {
/*     */         continue;
/*     */       }
/* 407 */       this.mappedTypes.put(name, type);
/*     */ 
/* 409 */       JavaXmlTypeMapping typeCopy = new JavaXmlTypeMapping(this.javaWsdlMapping);
/* 410 */       typeCopy.setQNameScope(type.getQnameScope());
/* 411 */       typeCopy.setAnonymousTypeQName(type.getAnonymousTypeQName());
/* 412 */       typeCopy.setJavaType(type.getJavaType());
/* 413 */       typeCopy.setRootTypeQName(type.getRootTypeQName());
/*     */ 
/* 415 */       for (VariableMapping variable : type.getVariableMappings())
/*     */       {
/* 417 */         VariableMapping variableCopy = new VariableMapping(typeCopy);
/* 418 */         variableCopy.setDataMember(variable.isDataMember());
/* 419 */         variableCopy.setJavaVariableName(variable.getJavaVariableName());
/* 420 */         variableCopy.setXmlAttributeName(variable.getXmlAttributeName());
/* 421 */         variableCopy.setXmlElementName(variable.getXmlElementName());
/* 422 */         variableCopy.setXmlWildcard(variable.getXmlWildcard());
/*     */ 
/* 424 */         typeCopy.addVariableMapping(variableCopy);
/*     */       }
/*     */ 
/* 427 */       this.javaWsdlMapping.addJavaXmlTypeMappings(typeCopy);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void addPackageMapping(String name, String namespaceURI)
/*     */   {
/* 433 */     if (this.mappedPackages.contains(name)) {
/* 434 */       return;
/*     */     }
/* 436 */     this.mappedPackages.add(name);
/* 437 */     PackageMapping copy = new PackageMapping(this.javaWsdlMapping);
/* 438 */     copy.setPackageType(name);
/*     */ 
/* 440 */     copy.setNamespaceURI(namespaceURI);
/* 441 */     this.javaWsdlMapping.addPackageMapping(copy);
/*     */   }
/*     */ 
/*     */   protected void generateElement(QName xmlName, QName xmlType)
/*     */   {
/* 446 */     WSDLTypes types = this.wsdl.getWsdlTypes();
/* 447 */     String namespaceURI = xmlType.getNamespaceURI();
/* 448 */     JBossXSModel schemaModel = WSDLUtils.getSchemaModel(types);
/*     */     XSTypeDefinition type;
/*     */     XSTypeDefinition type;
/* 451 */     if ("http://www.w3.org/2001/XMLSchema".equals(namespaceURI))
/* 452 */       type = SchemaUtils.getInstance().getSchemaBasicType(xmlType.getLocalPart());
/*     */     else {
/* 454 */       type = schemaModel.getTypeDefinition(xmlType.getLocalPart(), namespaceURI);
/*     */     }
/* 456 */     WSSchemaUtils utils = WSSchemaUtils.getInstance(schemaModel.getNamespaceRegistry(), null);
/* 457 */     JBossXSElementDeclaration element = utils.createGlobalXSElementDeclaration(xmlName.getLocalPart(), type, xmlName.getNamespaceURI());
/*     */ 
/* 459 */     schemaModel.addXSElementDeclaration(element);
/*     */ 
/* 461 */     this.wsdl.registerNamespaceURI(xmlName.getNamespaceURI(), null);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.helpers.JavaToWSDLHelper
 * JD-Core Version:    0.6.0
 */