/*     */ package org.jboss.ws.tools.wsdl;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.StringWriter;
/*     */ import java.net.ConnectException;
/*     */ import java.net.URL;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import javax.wsdl.Definition;
/*     */ import javax.wsdl.factory.WSDLFactory;
/*     */ import javax.wsdl.xml.WSDLReader;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.utils.JBossWSEntityResolver;
/*     */ import org.jboss.ws.core.utils.ResourceURL;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLException;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.xml.sax.EntityResolver;
/*     */ 
/*     */ public class WSDLDefinitionsFactory
/*     */ {
/*  62 */   private static final Logger log = Logger.getLogger(WSDLDefinitionsFactory.class);
/*     */   public static final String FEATURE_IMPORT_DOCUMENTS = "javax.wsdl.importDocuments";
/*     */   public static final String FEATURE_VERBOSE = "javax.wsdl.verbose";
/*  70 */   private Map features = new HashMap();
/*     */ 
/*     */   public static WSDLDefinitionsFactory newInstance()
/*     */   {
/*  82 */     return new WSDLDefinitionsFactory();
/*     */   }
/*     */ 
/*     */   public void setFeature(String name, boolean value)
/*     */     throws IllegalArgumentException
/*     */   {
/*  90 */     this.features.put(name, new Boolean(value));
/*     */   }
/*     */ 
/*     */   public WSDLDefinitions parse(URL wsdlLocation)
/*     */     throws WSDLException
/*     */   {
/*  98 */     if (wsdlLocation == null) {
/*  99 */       throw new IllegalArgumentException("URL cannot be null");
/*     */     }
/* 101 */     if (log.isDebugEnabled()) {
/* 102 */       log.debug("parse: " + wsdlLocation.toExternalForm());
/*     */     }
/* 104 */     EntityResolver entityResolver = new JBossWSEntityResolver();
/* 105 */     WSDLDefinitions wsdlDefinitions = null;
/*     */     try
/*     */     {
/* 108 */       Document wsdlDoc = getDocument(wsdlLocation);
/* 109 */       String defaultNamespace = getDefaultNamespace(wsdlDoc);
/* 110 */       if ("http://schemas.xmlsoap.org/wsdl/".equals(defaultNamespace))
/*     */       {
/* 112 */         WSDLFactory wsdlFactory = WSDLFactory.newInstance(JBossWSDLFactoryImpl.class.getName());
/* 113 */         WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
/* 114 */         wsdlReader.setFeature("javax.wsdl.verbose", false);
/*     */ 
/* 117 */         Iterator it = this.features.entrySet().iterator();
/*     */ 
/* 119 */         while (it.hasNext())
/*     */         {
/* 121 */           Map.Entry entry = (Map.Entry)it.next();
/* 122 */           String key = (String)entry.getKey();
/* 123 */           Boolean flag = (Boolean)entry.getValue();
/* 124 */           wsdlReader.setFeature(key, flag.booleanValue());
/*     */         }
/*     */ 
/* 127 */         Definition definition = wsdlReader.readWSDL(new WSDLLocatorImpl(entityResolver, wsdlLocation));
/* 128 */         wsdlDefinitions = new WSDL11Reader().processDefinition(definition, wsdlLocation);
/* 129 */         wsdlDefinitions.setWsdlDocument(wsdlDoc);
/*     */       }
/*     */       else
/*     */       {
/* 133 */         throw new WSDLException("Invalid default namespace: " + defaultNamespace);
/*     */       }
/*     */ 
/* 136 */       if (log.isTraceEnabled())
/*     */       {
/* 138 */         StringWriter stwr = new StringWriter();
/* 139 */         WSDL11Writer wsdlWriter = new WSDL11Writer(wsdlDefinitions);
/* 140 */         wsdlWriter.write(stwr);
/* 141 */         log.trace("\n" + stwr.toString());
/*     */       }
/*     */     }
/*     */     catch (WSDLException e)
/*     */     {
/* 146 */       throw e;
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 150 */       throw rte;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 154 */       throw new WSDLException(e);
/*     */     }
/*     */ 
/* 157 */     return wsdlDefinitions;
/*     */   }
/*     */ 
/*     */   private Document getDocument(URL wsdlLocation)
/*     */     throws WSDLException
/*     */   {
/*     */     try
/*     */     {
/* 166 */       InputStream inputStream = new ResourceURL(wsdlLocation).openStream();
/*     */       try
/*     */       {
/* 169 */         DocumentBuilder builder = DOMUtils.getDocumentBuilder();
/* 170 */         Document localDocument = builder.parse(inputStream);
/*     */         return localDocument; } finally { inputStream.close();
/*     */       }
/*     */     }
/*     */     catch (ConnectException ex)
/*     */     {
/* 179 */       throw new WSDLException("Cannot connect to: " + wsdlLocation);
/*     */     }
/*     */     catch (Exception ex) {
/*     */     }
/* 183 */     throw new WSDLException("Cannot parse wsdlLocation: " + wsdlLocation, ex);
/*     */   }
/*     */ 
/*     */   private String getDefaultNamespace(Document wsdlDoc)
/*     */     throws WSDLException
/*     */   {
/* 191 */     Element root = wsdlDoc.getDocumentElement();
/* 192 */     String defaultNamespace = root.getNamespaceURI();
/* 193 */     return defaultNamespace;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.tools.wsdl.WSDLDefinitionsFactory
 * JD-Core Version:    0.6.0
 */